/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import java.util.function.Consumer;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.procedure.internal.EntityDomainResultBuilder;
import org.hibernate.procedure.internal.ScalarDomainResultBuilder;
import org.hibernate.query.UnknownSqlResultSetMappingException;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.NamedObjectRepository;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.results.ResultSetMapping;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;

public class Util {
    private Util() {
    }

    public static void resolveResultSetMappings(String[] resultSetMappingNames, Class[] resultSetMappingClasses, ResultSetMapping resultSetMapping, Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        if (!ArrayHelper.isEmpty(resultSetMappingNames)) {
            if (!ArrayHelper.isEmpty(resultSetMappingClasses)) {
                throw new IllegalArgumentException("Cannot specify both result-set mapping names and classes");
            }
            Util.resolveResultSetMappingNames(resultSetMappingNames, resultSetMapping, querySpaceConsumer, context);
        } else if (!ArrayHelper.isEmpty(resultSetMappingClasses)) {
            Util.resolveResultSetMappingClasses(resultSetMappingClasses, resultSetMapping, querySpaceConsumer, context);
        }
    }

    public static void resolveResultSetMappingNames(String[] resultSetMappingNames, ResultSetMapping resultSetMapping, Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        NamedObjectRepository namedObjectRepository = context.getSessionFactory().getQueryEngine().getNamedObjectRepository();
        for (String resultSetMappingName : resultSetMappingNames) {
            NamedResultSetMappingMemento memento = namedObjectRepository.getResultSetMappingMemento(resultSetMappingName);
            if (memento == null) {
                throw new UnknownSqlResultSetMappingException("Unknown SqlResultSetMapping [" + resultSetMappingName + "]");
            }
            memento.resolve(resultSetMapping, querySpaceConsumer, context);
        }
    }

    public static void resolveResultSetMappingClasses(Class[] resultSetMappingClasses, ResultSetMapping resultSetMapping, Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        MappingMetamodelImplementor mappingMetamodel = context.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel();
        JavaTypeRegistry javaTypeRegistry = mappingMetamodel.getTypeConfiguration().getJavaTypeRegistry();
        for (Class resultSetMappingClass : resultSetMappingClasses) {
            EntityPersister entityDescriptor = mappingMetamodel.findEntityDescriptor(resultSetMappingClass);
            if (entityDescriptor != null) {
                resultSetMapping.addResultBuilder(new EntityDomainResultBuilder(entityDescriptor));
                for (String querySpace : entityDescriptor.getSynchronizedQuerySpaces()) {
                    querySpaceConsumer.accept(querySpace);
                }
                continue;
            }
            JavaType basicType = javaTypeRegistry.getDescriptor(resultSetMappingClass);
            if (basicType == null) continue;
            resultSetMapping.addResultBuilder(new ScalarDomainResultBuilder(basicType));
        }
    }
}

