/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.implicit;

import java.util.function.BiFunction;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.ConvertibleModelPart;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.query.results.BasicValuedFetchBuilder;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.ResultSetMappingSqlSelection;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.implicit.ImplicitFetchBuilder;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class ImplicitFetchBuilderBasic
implements ImplicitFetchBuilder,
BasicValuedFetchBuilder {
    private final NavigablePath fetchPath;
    private final BasicValuedModelPart fetchable;

    public ImplicitFetchBuilderBasic(NavigablePath fetchPath, BasicValuedModelPart fetchable) {
        this.fetchPath = fetchPath;
        this.fetchable = fetchable;
    }

    @Override
    public FetchBuilder cacheKeyInstance() {
        return this;
    }

    @Override
    public BasicFetch<?> buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        TableGroup parentTableGroup = creationStateImpl.getFromClauseAccess().getTableGroup(parent.getNavigablePath());
        String table = this.fetchable.getContainingTableExpression();
        String column = this.fetchable.isFormula() ? this.fetchable.getFetchableName() : this.fetchable.getSelectionExpression();
        Expression expression = creationStateImpl.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(parentTableGroup.resolveTableReference(fetchPath, table), this.fetchable.getSelectionExpression()), processingState -> {
            int jdbcPosition = jdbcResultsMetadata.resolveColumnPosition(column);
            int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
            return new ResultSetMappingSqlSelection(valuesArrayPosition, this.fetchable);
        });
        SqlSelection sqlSelection = creationStateImpl.resolveSqlSelection(expression, this.fetchable.getJavaType(), parent, domainResultCreationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
        BasicValueConverter valueConverter = this.fetchable instanceof ConvertibleModelPart ? ((ConvertibleModelPart)this.fetchable).getValueConverter() : null;
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), parent, fetchPath, this.fetchable, valueConverter, FetchTiming.IMMEDIATE, domainResultCreationState);
    }

    public String toString() {
        return "ImplicitFetchBuilderBasic(" + this.fetchPath + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImplicitFetchBuilderBasic that = (ImplicitFetchBuilderBasic)o;
        return this.fetchPath.equals(that.fetchPath) && this.fetchable.equals(that.fetchable);
    }

    public int hashCode() {
        int result = this.fetchPath.hashCode();
        result = 31 * result + this.fetchable.hashCode();
        return result;
    }
}

