/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Locale;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.ConvertibleModelPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.SqlTreeCreationException;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.WrapperOptions;

public class QueryLiteral<T>
implements Literal,
DomainResultProducer<T> {
    private final T value;
    private final BasicValuedMapping type;

    public QueryLiteral(T value, BasicValuedMapping type) {
        if (type instanceof ConvertibleModelPart) {
            ConvertibleModelPart convertibleModelPart = (ConvertibleModelPart)type;
            BasicValueConverter valueConverter = convertibleModelPart.getValueConverter();
            if (valueConverter != null) {
                Object sqlLiteralValue;
                T literalValue = value;
                if (literalValue == null || valueConverter.getDomainJavaType().getJavaTypeClass().isInstance(literalValue)) {
                    sqlLiteralValue = valueConverter.toRelationalValue(literalValue);
                } else if (valueConverter.getRelationalJavaType().getJavaTypeClass().isInstance(literalValue)) {
                    sqlLiteralValue = literalValue;
                } else {
                    throw new SqlTreeCreationException(String.format(Locale.ROOT, "QueryLiteral type [`%s`] did not match domain Java-type [`%s`] nor JDBC Java-type [`%s`]", literalValue.getClass(), valueConverter.getDomainJavaType().getJavaTypeClass().getName(), valueConverter.getRelationalJavaType().getJavaTypeClass().getName()));
                }
                this.value = sqlLiteralValue;
                this.type = convertibleModelPart;
            } else {
                this.value = value;
                this.type = type;
            }
        } else {
            this.value = value;
            this.type = type;
        }
    }

    public T getLiteralValue() {
        return this.value;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.type.getJdbcMapping();
    }

    @Override
    public void accept(SqlAstWalker walker) {
        walker.visitQueryLiteral(this);
    }

    @Override
    public BasicValuedMapping getExpressionType() {
        return this.type;
    }

    @Override
    public DomainResult<T> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        SqlExpressionResolver sqlExpressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(this, this.type.getMappedType().getMappedJavaType(), null, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.type.getMappedType().getMappedJavaType());
    }

    @Override
    public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) throws SQLException {
        ConvertibleModelPart convertibleModelPart;
        Object literalValue = this.getLiteralValue();
        if (this.type instanceof ConvertibleModelPart && (convertibleModelPart = (ConvertibleModelPart)this.type).getValueConverter() != null) {
            literalValue = convertibleModelPart.getValueConverter().toRelationalValue(literalValue);
        }
        this.type.getJdbcMapping().getJdbcValueBinder().bind(statement, literalValue, startPosition, (WrapperOptions)executionContext.getSession());
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(this, this.type.getJdbcMapping().getJavaTypeDescriptor(), null, creationState.getSqlAstCreationState().getCreationContext().getMappingMetamodel().getTypeConfiguration());
    }
}

