/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class LocalDateJavaType
extends AbstractTemporalJavaType<LocalDate> {
    public static final LocalDateJavaType INSTANCE = new LocalDateJavaType();

    public LocalDateJavaType() {
        super(LocalDate.class, ImmutableMutabilityPlan.instance());
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.DATE;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        return context.getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(91);
    }

    @Override
    protected <X> TemporalJavaType<X> forDatePrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    @Override
    public String toString(LocalDate value) {
        return DateTimeFormatter.ISO_LOCAL_DATE.format(value);
    }

    @Override
    public LocalDate fromString(CharSequence string) {
        return LocalDate.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(string));
    }

    @Override
    public <X> X unwrap(LocalDate value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (LocalDate.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Date.class.isAssignableFrom(type)) {
            return (X)Date.valueOf(value);
        }
        LocalDateTime localDateTime = value.atStartOfDay();
        if (Timestamp.class.isAssignableFrom(type)) {
            return (X)Timestamp.valueOf(localDateTime);
        }
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)GregorianCalendar.from(zonedDateTime);
        }
        Instant instant = zonedDateTime.toInstant();
        if (java.util.Date.class.equals(type)) {
            return (X)java.util.Date.from(instant);
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(instant.toEpochMilli());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> LocalDate wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            return ts.toLocalDateTime().toLocalDate();
        }
        if (value instanceof Long) {
            Instant instant = Instant.ofEpochMilli((Long)value);
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalDate();
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return LocalDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId()).toLocalDate();
        }
        if (value instanceof java.util.Date) {
            if (value instanceof Date) {
                return ((Date)value).toLocalDate();
            }
            return Instant.ofEpochMilli(((java.util.Date)value).getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
        }
        throw this.unknownWrap(value.getClass());
    }
}

