/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.UndertowAttachments;

public class UndertowServletContainerDependencyProcessor
implements DeploymentUnitProcessor {
    private final String defaultServletContainer;

    public UndertowServletContainerDependencyProcessor(String defaultContainer) {
        this.defaultServletContainer = defaultContainer;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData != null) {
            String servletContainerName = this.defaultServletContainer;
            JBossWebMetaData metaData = warMetaData.getMergedJBossWebMetaData();
            if (metaData != null && metaData.getServletContainerName() != null) {
                servletContainerName = metaData.getServletContainerName();
            }
            phaseContext.addDeploymentDependency(UndertowService.SERVLET_CONTAINER.append(new String[]{servletContainerName}), UndertowAttachments.SERVLET_CONTAINER_SERVICE);
        }
    }
}

