/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.job.model;

import java.util.List;
import org.jberet.job.model.Chunk;
import org.jberet.job.model.Decision;
import org.jberet.job.model.ExceptionClassFilter;
import org.jberet.job.model.Flow;
import org.jberet.job.model.Job;
import org.jberet.job.model.JobElement;
import org.jberet.job.model.JobMapperImpl;
import org.jberet.job.model.Listeners;
import org.jberet.job.model.Partition;
import org.jberet.job.model.PartitionPlan;
import org.jberet.job.model.Properties;
import org.jberet.job.model.RefArtifact;
import org.jberet.job.model.Split;
import org.jberet.job.model.Step;
import org.jberet.job.model.Transition;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.NullValueCheckStrategy;
import org.mapstruct.ObjectFactory;

@Mapper(uses={JobMapperFactory.class}, nullValueCheckStrategy=NullValueCheckStrategy.ALWAYS)
public interface JobMapper {
    public Job job(Job var1);

    public List<Properties> properties(List<Properties> var1);

    public Properties properties(Properties var1);

    public Listeners listeners(Listeners var1);

    public List<Transition> transitions(List<Transition> var1);

    public Transition transition(Transition var1);

    public List<JobElement> jobElements(List<JobElement> var1);

    @Mapping(target="transitionElements", ignore=true)
    public JobElement jobElement(JobElement var1);

    public Step step(Step var1);

    public List<RefArtifact> refArtifacts(List<RefArtifact> var1);

    public RefArtifact refArtifact(RefArtifact var1);

    public Chunk chunk(Chunk var1);

    public ExceptionClassFilter exceptionClassFilter(ExceptionClassFilter var1);

    public Partition partition(Partition var1);

    public PartitionPlan partitionPlan(PartitionPlan var1);

    public Decision decision(Decision var1);

    public List<Flow> flows(List<Flow> var1);

    public Flow flow(Flow var1);

    public Split split(Split var1);

    public static class JobMapperFactory {
        private static final JobMapper jobMapper = new JobMapperImpl();

        @ObjectFactory
        static Job createJob(Job job) {
            return new Job(job.getId());
        }

        @ObjectFactory
        static Transition createTransition(Transition transition) {
            if (transition instanceof Transition.Next) {
                Transition.Next next = new Transition.Next(transition.getOn());
                next.setTo(((Transition.Next)transition).getTo());
                return next;
            }
            if (transition instanceof Transition.Stop) {
                Transition.Stop stop = new Transition.Stop(transition.getOn(), ((Transition.Stop)transition).getRestart());
                stop.setExitStatus(((Transition.Termination)transition).getExitStatus());
                return stop;
            }
            if (transition instanceof Transition.Fail) {
                Transition.Fail fail = new Transition.Fail(transition.getOn());
                fail.setExitStatus(((Transition.Termination)transition).getExitStatus());
                return fail;
            }
            if (transition instanceof Transition.End) {
                Transition.End end = new Transition.End(transition.getOn());
                end.setExitStatus(((Transition.Termination)transition).getExitStatus());
                return end;
            }
            throw new UnsupportedOperationException();
        }

        @ObjectFactory
        static JobElement createJobElement(JobElement jobElement) {
            if (jobElement instanceof Step) {
                return jobMapper.step((Step)jobElement);
            }
            if (jobElement instanceof Decision) {
                return jobMapper.decision((Decision)jobElement);
            }
            if (jobElement instanceof Flow) {
                return jobMapper.flow((Flow)jobElement);
            }
            if (jobElement instanceof Split) {
                return jobMapper.split((Split)jobElement);
            }
            throw new UnsupportedOperationException();
        }

        @ObjectFactory
        static RefArtifact createRefArtifact(RefArtifact refArtifact) {
            return new RefArtifact(refArtifact.getRef());
        }

        @ObjectFactory
        static Step createStep(Step step) {
            return new Step(step.getId());
        }

        @ObjectFactory
        static Decision createDecision(Decision decision) {
            return new Decision(decision.getId(), decision.getRef());
        }

        @ObjectFactory
        static Flow createFlow(Flow flow) {
            return new Flow(flow.getId());
        }

        @ObjectFactory
        static Split createSplit(Split split) {
            return new Split(split.getId());
        }
    }
}

