/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import org.apache.lucene.facet.taxonomy.OrdinalsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;

public class DocValuesOrdinalsReader
extends OrdinalsReader {
    private final String field;

    public DocValuesOrdinalsReader() {
        this("$facets");
    }

    public DocValuesOrdinalsReader(String field) {
        this.field = field;
    }

    @Override
    public OrdinalsReader.OrdinalsSegmentReader getReader(LeafReaderContext context) throws IOException {
        BinaryDocValues values0 = context.reader().getBinaryDocValues(this.field);
        if (values0 == null) {
            values0 = DocValues.emptyBinary();
        }
        final BinaryDocValues values = values0;
        return new OrdinalsReader.OrdinalsSegmentReader(){
            private int lastDocID;

            @Override
            public void get(int docID, IntsRef ordinals) throws IOException {
                if (docID < this.lastDocID) {
                    throw new AssertionError((Object)("docs out of order: lastDocID=" + this.lastDocID + " vs docID=" + docID));
                }
                this.lastDocID = docID;
                if (docID > values.docID()) {
                    values.advance(docID);
                }
                BytesRef bytes = values.docID() == docID ? values.binaryValue() : new BytesRef(BytesRef.EMPTY_BYTES);
                DocValuesOrdinalsReader.this.decode(bytes, ordinals);
            }
        };
    }

    @Override
    public String getIndexFieldName() {
        return this.field;
    }

    public void decode(BytesRef buf, IntsRef ordinals) {
        if (ordinals.ints.length < buf.length) {
            ordinals.ints = ArrayUtil.grow((int[])ordinals.ints, (int)buf.length);
        }
        ordinals.offset = 0;
        ordinals.length = 0;
        int upto = buf.offset + buf.length;
        int value = 0;
        int offset = buf.offset;
        int prev = 0;
        while (offset < upto) {
            byte b;
            if ((b = buf.bytes[offset++]) >= 0) {
                ordinals.ints[ordinals.length] = (value << 7 | b) + prev;
                value = 0;
                prev = ordinals.ints[ordinals.length];
                ++ordinals.length;
                continue;
            }
            value = value << 7 | b & 0x7F;
        }
    }
}

