/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.StartException;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.GenericTransportDefinition;
import org.wildfly.extension.messaging.activemq.HTTPConnectorDefinition;
import org.wildfly.extension.messaging.activemq.InVMTransportDefinition;
import org.wildfly.extension.messaging.activemq.RemoteTransportDefinition;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class TransportConfigOperationHandlers {
    private static final Map<String, String> CONNECTORS_KEYS_MAP = new HashMap<String, String>();
    private static final Map<String, String> ACCEPTOR_KEYS_MAP = new HashMap<String, String>();
    private static final Set<String> IN_VM_ALLOWABLE_KEYS;
    private static final String BATCH_DELAY = "batch-delay";
    private static final String HTTP_UPGRADE_ENABLED = "http-upgrade-enabled";
    private static final String KEY_STORE_PASSWORD = "key-store-password";
    private static final String KEY_STORE_PATH = "key-store-path";
    private static final String KEY_STORE_PROVIDER = "key-store-provider";
    private static final String KEY_STORE_TYPE = "key-store-type";
    private static final String TCP_RECEIVE_BUFFER_SIZE = "tcp-receive-buffer-size";
    private static final String TCP_SEND_BUFFER_SIZE = "tcp-send-buffer-size";
    private static final String TRUST_STORE_PASSWORD = "trust-store-password";
    private static final String TRUST_STORE_PATH = "trust-store-path";
    private static final String TRUST_STORE_PROVIDER = "trust-store-provider";
    private static final String TRUST_STORE_TYPE = "trust-store-type";
    private static final String ENABLED_PROTOCOLS = "enabled-protocols";
    private static final String ENABLED_CIPHER_SUITES = "enabled-cipher-suites";
    private static final String HOST = "host";
    private static final String PORT = "port";
    public static final String SSL_ENABLED = "ssl-enabled";
    public static final String USE_NIO = "use-nio";
    public static final String TCP_NO_DELAY = "tcp-no-delay";
    public static final String VERIFY_HOST = "verify-host";
    private static final String SOCKET_REF;

    static void processAcceptors(OperationContext context, Configuration configuration, ModelNode params, Set<String> bindings) throws OperationFailedException {
        Map<String, Object> extraParameters;
        Map<String, Object> parameters;
        ModelNode config;
        String acceptorName;
        HashMap<String, TransportConfiguration> acceptors = new HashMap<String, TransportConfiguration>();
        if (params.hasDefined("acceptor")) {
            for (Property property : params.get("acceptor").asPropertyList()) {
                acceptorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config, ACCEPTOR_KEYS_MAP);
                extraParameters = TransportConfigOperationHandlers.getExtraParameters(TransportConstants.ALLOWABLE_ACCEPTOR_KEYS, parameters);
                String clazz = config.get(CommonAttributes.FACTORY_CLASS.getName()).asString();
                ModelNode socketBinding = GenericTransportDefinition.SOCKET_BINDING.resolveModelAttribute(context, config);
                if (socketBinding.isDefined()) {
                    bindings.add(socketBinding.asString());
                    parameters.put(GenericTransportDefinition.SOCKET_BINDING.getName(), socketBinding.asString());
                }
                acceptors.put(acceptorName, new TransportConfiguration(clazz, parameters, acceptorName, extraParameters));
            }
        }
        if (params.hasDefined("remote-acceptor")) {
            for (Property property : params.get("remote-acceptor").asPropertyList()) {
                acceptorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config, ACCEPTOR_KEYS_MAP);
                extraParameters = TransportConfigOperationHandlers.getExtraParameters(TransportConstants.ALLOWABLE_ACCEPTOR_KEYS, parameters);
                String binding = config.get(RemoteTransportDefinition.SOCKET_BINDING.getName()).asString();
                bindings.add(binding);
                parameters.put(RemoteTransportDefinition.SOCKET_BINDING.getName(), binding);
                acceptors.put(acceptorName, new TransportConfiguration(NettyAcceptorFactory.class.getName(), parameters, acceptorName, extraParameters));
            }
        }
        if (params.hasDefined("in-vm-acceptor")) {
            for (Property property : params.get("in-vm-acceptor").asPropertyList()) {
                acceptorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config, ACCEPTOR_KEYS_MAP);
                extraParameters = TransportConfigOperationHandlers.getExtraParameters(IN_VM_ALLOWABLE_KEYS, parameters);
                parameters.put("serverId", InVMTransportDefinition.SERVER_ID.resolveModelAttribute(context, config).asInt());
                acceptors.put(acceptorName, new TransportConfiguration(InVMAcceptorFactory.class.getName(), parameters, acceptorName, extraParameters));
            }
        }
        if (params.hasDefined("http-acceptor")) {
            for (Property property : params.get("http-acceptor").asPropertyList()) {
                acceptorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config, ACCEPTOR_KEYS_MAP);
                extraParameters = TransportConfigOperationHandlers.getExtraParameters(TransportConstants.ALLOWABLE_ACCEPTOR_KEYS, parameters);
                parameters.put("httpUpgradeEnabled", true);
                acceptors.put(acceptorName, new TransportConfiguration(NettyAcceptorFactory.class.getName(), parameters, acceptorName, extraParameters));
            }
        }
        configuration.setAcceptorConfigurations(new HashSet(acceptors.values()));
    }

    private static Map<String, Object> getExtraParameters(Set<String> allowedKeys, Map<String, Object> parameters) {
        HashMap<String, Object> extraParameters = new HashMap<String, Object>();
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            if (allowedKeys.contains(parameter.getKey())) continue;
            extraParameters.put(parameter.getKey(), parameter.getValue());
        }
        for (String extraParam : extraParameters.keySet()) {
            parameters.remove(extraParam);
        }
        return extraParameters;
    }

    public static Map<String, Object> getParameters(OperationContext context, ModelNode config, Map<String, String> mapping) throws OperationFailedException {
        Map fromModel = CommonAttributes.PARAMS.unwrap((ExpressionResolver)context, config);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (Map.Entry entry : fromModel.entrySet()) {
            parameters.put(mapping.getOrDefault(entry.getKey(), (String)entry.getKey()), entry.getValue());
        }
        return parameters;
    }

    static Map<String, TransportConfiguration> processConnectors(OperationContext context, String configServerName, ModelNode params, Set<String> bindings) throws OperationFailedException {
        String binding;
        Map<String, Object> extraParameters;
        Map<String, Object> parameters;
        ModelNode config;
        String connectorName;
        HashMap<String, TransportConfiguration> connectors = new HashMap<String, TransportConfiguration>();
        if (params.hasDefined("connector")) {
            for (Property property : params.get("connector").asPropertyList()) {
                connectorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config, CONNECTORS_KEYS_MAP);
                extraParameters = TransportConfigOperationHandlers.getExtraParameters(TransportConstants.ALLOWABLE_CONNECTOR_KEYS, parameters);
                ModelNode socketBinding = GenericTransportDefinition.SOCKET_BINDING.resolveModelAttribute(context, config);
                if (socketBinding.isDefined()) {
                    bindings.add(socketBinding.asString());
                    parameters.put(GenericTransportDefinition.SOCKET_BINDING.getName(), socketBinding.asString());
                }
                String clazz = CommonAttributes.FACTORY_CLASS.resolveModelAttribute(context, config).asString();
                connectors.put(connectorName, new TransportConfiguration(clazz, parameters, connectorName, extraParameters));
            }
        }
        if (params.hasDefined("remote-connector")) {
            for (Property property : params.get("remote-connector").asPropertyList()) {
                connectorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config, CONNECTORS_KEYS_MAP);
                extraParameters = TransportConfigOperationHandlers.getExtraParameters(TransportConstants.ALLOWABLE_CONNECTOR_KEYS, parameters);
                binding = config.get(RemoteTransportDefinition.SOCKET_BINDING.getName()).asString();
                bindings.add(binding);
                parameters.put(RemoteTransportDefinition.SOCKET_BINDING.getName(), binding);
                connectors.put(connectorName, new TransportConfiguration(NettyConnectorFactory.class.getName(), parameters, connectorName, extraParameters));
            }
        }
        if (params.hasDefined("in-vm-connector")) {
            for (Property property : params.get("in-vm-connector").asPropertyList()) {
                connectorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config, CONNECTORS_KEYS_MAP);
                extraParameters = TransportConfigOperationHandlers.getExtraParameters(IN_VM_ALLOWABLE_KEYS, parameters);
                parameters.put(CONNECTORS_KEYS_MAP.get(InVMTransportDefinition.SERVER_ID.getName()), InVMTransportDefinition.SERVER_ID.resolveModelAttribute(context, config).asInt());
                connectors.put(connectorName, new TransportConfiguration(InVMConnectorFactory.class.getName(), parameters, connectorName, extraParameters));
            }
        }
        if (params.hasDefined("http-connector")) {
            for (Property property : params.get("http-connector").asPropertyList()) {
                connectorName = property.getName();
                config = property.getValue();
                parameters = TransportConfigOperationHandlers.getParameters(context, config, CONNECTORS_KEYS_MAP);
                extraParameters = TransportConfigOperationHandlers.getExtraParameters(TransportConstants.ALLOWABLE_CONNECTOR_KEYS, parameters);
                binding = HTTPConnectorDefinition.SOCKET_BINDING.resolveModelAttribute(context, config).asString();
                bindings.add(binding);
                parameters.put("httpUpgradeEnabled", true);
                parameters.put("httpUpgradeEndpoint", HTTPConnectorDefinition.ENDPOINT.resolveModelAttribute(context, config).asString());
                parameters.put(HTTPConnectorDefinition.SOCKET_BINDING.getName(), binding);
                ModelNode serverNameModelNode = HTTPConnectorDefinition.SERVER_NAME.resolveModelAttribute(context, config);
                String serverName = serverNameModelNode.isDefined() ? serverNameModelNode.asString() : configServerName;
                parameters.put("activemqServerName", serverName);
                connectors.put(connectorName, new TransportConfiguration(NettyConnectorFactory.class.getName(), parameters, connectorName, extraParameters));
            }
        }
        return connectors;
    }

    public static TransportConfiguration[] processConnectors(OperationContext context, Collection<String> names, Set<String> bindings) throws OperationFailedException {
        ArrayList<TransportConfiguration> connectors = new ArrayList<TransportConfiguration>();
        PathAddress subsystemAddress = context.getCurrentAddress().getParent();
        Resource subsystemResource = context.readResourceFromRoot(subsystemAddress, false);
        for (String connectorName : names) {
            String clazz;
            ModelNode socketBinding;
            Map<String, Object> parameters;
            ModelNode config;
            if (subsystemResource.hasChild(PathElement.pathElement((String)"connector", (String)connectorName))) {
                config = context.readResourceFromRoot(subsystemAddress.append(new PathElement[]{PathElement.pathElement((String)"connector", (String)connectorName)}), true).getModel();
                parameters = TransportConfigOperationHandlers.getParameters(context, config, CONNECTORS_KEYS_MAP);
                socketBinding = GenericTransportDefinition.SOCKET_BINDING.resolveModelAttribute(context, config);
                if (socketBinding.isDefined()) {
                    parameters.put(GenericTransportDefinition.SOCKET_BINDING.getName(), socketBinding.asString());
                    bindings.add(socketBinding.asString());
                }
                clazz = CommonAttributes.FACTORY_CLASS.resolveModelAttribute(context, config).asString();
                connectors.add(new TransportConfiguration(clazz, parameters, connectorName));
            }
            if (subsystemResource.hasChild(PathElement.pathElement((String)"remote-connector", (String)connectorName))) {
                config = context.readResourceFromRoot(subsystemAddress.append(new PathElement[]{PathElement.pathElement((String)"remote-connector", (String)connectorName)}), true).getModel();
                parameters = TransportConfigOperationHandlers.getParameters(context, config, CONNECTORS_KEYS_MAP);
                socketBinding = GenericTransportDefinition.SOCKET_BINDING.resolveModelAttribute(context, config);
                if (socketBinding.isDefined()) {
                    parameters.put(GenericTransportDefinition.SOCKET_BINDING.getName(), socketBinding.asString());
                    bindings.add(socketBinding.asString());
                }
                if (!config.hasDefined(CommonAttributes.FACTORY_CLASS.getName())) {
                    config.get(CommonAttributes.FACTORY_CLASS.getName()).set(NettyConnectorFactory.class.getName());
                }
                clazz = CommonAttributes.FACTORY_CLASS.resolveModelAttribute(context, config).asString();
                connectors.add(new TransportConfiguration(clazz, parameters, connectorName));
            }
            if (subsystemResource.hasChild(PathElement.pathElement((String)"in-vm-connector", (String)connectorName))) {
                config = context.readResourceFromRoot(subsystemAddress.append(new PathElement[]{PathElement.pathElement((String)"in-vm-connector", (String)connectorName)}), true).getModel();
                parameters = TransportConfigOperationHandlers.getParameters(context, config, CONNECTORS_KEYS_MAP);
                parameters.put(CONNECTORS_KEYS_MAP.get(InVMTransportDefinition.SERVER_ID.getName()), InVMTransportDefinition.SERVER_ID.resolveModelAttribute(context, config).asInt());
                connectors.add(new TransportConfiguration(InVMConnectorFactory.class.getName(), parameters, connectorName));
            }
            if (!subsystemResource.hasChild(PathElement.pathElement((String)"http-connector", (String)connectorName))) continue;
            config = context.readResourceFromRoot(subsystemAddress.append(new PathElement[]{PathElement.pathElement((String)"http-connector", (String)connectorName)}), true).getModel();
            parameters = TransportConfigOperationHandlers.getParameters(context, config, CONNECTORS_KEYS_MAP);
            String binding = HTTPConnectorDefinition.SOCKET_BINDING.resolveModelAttribute(context, config).asString();
            parameters.put("httpUpgradeEnabled", true);
            parameters.put("httpUpgradeEndpoint", HTTPConnectorDefinition.ENDPOINT.resolveModelAttribute(context, config).asString());
            parameters.put(HTTPConnectorDefinition.SOCKET_BINDING.getName(), binding);
            bindings.add(binding);
            ModelNode serverNameModelNode = HTTPConnectorDefinition.SERVER_NAME.resolveModelAttribute(context, config);
            if (serverNameModelNode.isDefined()) {
                parameters.put("activemqServerName", serverNameModelNode.asString());
            }
            connectors.add(new TransportConfiguration(NettyConnectorFactory.class.getName(), parameters, connectorName));
        }
        return connectors.toArray(new TransportConfiguration[connectors.size()]);
    }

    public static Map<String, Boolean> listOutBoundSocketBinding(OperationContext context, Collection<String> names) throws OperationFailedException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false);
        Set groups = root.getChildrenNames("socket-binding-group");
        for (String groupName : groups) {
            Resource socketBindingGroup = context.readResourceFromRoot(PathAddress.pathAddress((String)"socket-binding-group", (String)groupName));
            for (String name : names) {
                if (socketBindingGroup.getChildrenNames("socket-binding").contains(name)) {
                    result.put(name, Boolean.FALSE);
                    continue;
                }
                if (!socketBindingGroup.getChildrenNames("local-destination-outbound-socket-binding").contains(name) && !socketBindingGroup.getChildrenNames("remote-destination-outbound-socket-binding").contains(name)) continue;
                result.put(name, Boolean.TRUE);
            }
        }
        if (result.size() != names.size()) {
            for (String name : names) {
                if (result.containsKey(name)) continue;
                throw MessagingLogger.ROOT_LOGGER.noSocketBinding(name);
            }
        }
        return result;
    }

    public static void processConnectorBindings(Collection<TransportConfiguration> connectors, Map<String, Supplier<SocketBinding>> socketBindings, Map<String, Supplier<OutboundSocketBinding>> outboundSocketBindings) throws StartException {
        if (connectors != null) {
            for (TransportConfiguration tc : connectors) {
                int port;
                String host;
                Object socketRef = tc.getParams().remove(SOCKET_REF);
                if (socketRef == null) continue;
                String name = socketRef.toString();
                if (!outboundSocketBindings.containsKey(name)) {
                    SocketBinding socketBinding = socketBindings.get(name).get();
                    if (socketBinding == null) {
                        throw MessagingLogger.ROOT_LOGGER.failedToFindConnectorSocketBinding(tc.getName());
                    }
                    if (socketBinding.getClientMappings() != null && !socketBinding.getClientMappings().isEmpty()) {
                        ClientMapping clientMapping = (ClientMapping)socketBinding.getClientMappings().get(0);
                        host = NetworkUtils.canonize((String)clientMapping.getDestinationAddress());
                        port = clientMapping.getDestinationPort();
                        if (socketBinding.getClientMappings().size() > 1) {
                            MessagingLogger.ROOT_LOGGER.multipleClientMappingsFound(socketBinding.getName(), tc.getName(), host, port);
                        }
                    } else {
                        InetSocketAddress sa = socketBinding.getSocketAddress();
                        port = sa.getPort();
                        host = sa.getAddress().isLoopbackAddress() ? NetworkUtils.canonize((String)sa.getAddress().getHostName()) : NetworkUtils.canonize((String)sa.getAddress().getHostAddress());
                    }
                } else {
                    OutboundSocketBinding binding = outboundSocketBindings.get(name).get();
                    port = binding.getDestinationPort();
                    host = NetworkUtils.canonize((String)binding.getUnresolvedDestinationAddress());
                    if (binding.getSourceAddress() != null) {
                        tc.getParams().put("localAddress", NetworkUtils.canonize((String)binding.getSourceAddress().getHostAddress()));
                    }
                    if (binding.getSourcePort() != null) {
                        tc.getParams().put("localPort", binding.getAbsoluteSourcePort());
                    }
                }
                tc.getParams().put(HOST, host);
                tc.getParams().put(PORT, port);
            }
        }
    }

    static {
        SOCKET_REF = RemoteTransportDefinition.SOCKET_BINDING.getName();
        CONNECTORS_KEYS_MAP.put(InVMTransportDefinition.SERVER_ID.getName(), "serverId");
        CONNECTORS_KEYS_MAP.put("buffer-pooling", "bufferPooling");
        CONNECTORS_KEYS_MAP.put(SSL_ENABLED, "sslEnabled");
        CONNECTORS_KEYS_MAP.put("http-enabled", "httpEnabled");
        CONNECTORS_KEYS_MAP.put("http-client-idle-time", "httpClientIdleTime");
        CONNECTORS_KEYS_MAP.put("http-client-idle-scan-period", "httpClientIdleScanPeriod");
        CONNECTORS_KEYS_MAP.put("http-requires-session-id", "httpRequiresSessionId");
        CONNECTORS_KEYS_MAP.put(HTTP_UPGRADE_ENABLED, "httpUpgradeEnabled");
        CONNECTORS_KEYS_MAP.put("http-upgrade-endpoint", "httpUpgradeEndpoint");
        CONNECTORS_KEYS_MAP.put("use-servlet", "useServlet");
        CONNECTORS_KEYS_MAP.put("servlet-path", "servletPath");
        CONNECTORS_KEYS_MAP.put(USE_NIO, "useNio");
        CONNECTORS_KEYS_MAP.put("use-nio-global-worker-pool", "useNioGlobalWorkerPool");
        CONNECTORS_KEYS_MAP.put(HOST, HOST);
        CONNECTORS_KEYS_MAP.put(PORT, PORT);
        CONNECTORS_KEYS_MAP.put("local-address", "localAddress");
        CONNECTORS_KEYS_MAP.put("local-port", "localPort");
        CONNECTORS_KEYS_MAP.put(KEY_STORE_PROVIDER, "keyStoreProvider");
        CONNECTORS_KEYS_MAP.put(KEY_STORE_PATH, "keyStorePath");
        CONNECTORS_KEYS_MAP.put(KEY_STORE_PASSWORD, "keyStorePassword");
        CONNECTORS_KEYS_MAP.put(KEY_STORE_TYPE, "keyStoreType");
        CONNECTORS_KEYS_MAP.put(TRUST_STORE_PROVIDER, "trustStoreProvider");
        CONNECTORS_KEYS_MAP.put(TRUST_STORE_PATH, "trustStorePath");
        CONNECTORS_KEYS_MAP.put(TRUST_STORE_PASSWORD, "trustStorePassword");
        CONNECTORS_KEYS_MAP.put(TRUST_STORE_TYPE, "trustStoreType");
        CONNECTORS_KEYS_MAP.put(ENABLED_CIPHER_SUITES, "enabledCipherSuites");
        CONNECTORS_KEYS_MAP.put(ENABLED_PROTOCOLS, "enabledProtocols");
        CONNECTORS_KEYS_MAP.put(TCP_NO_DELAY, "tcpNoDelay");
        CONNECTORS_KEYS_MAP.put(TCP_SEND_BUFFER_SIZE, "tcpSendBufferSize");
        CONNECTORS_KEYS_MAP.put(TCP_RECEIVE_BUFFER_SIZE, "tcpReceiveBufferSize");
        CONNECTORS_KEYS_MAP.put("nio-remoting-threads", "nioRemotingThreads");
        CONNECTORS_KEYS_MAP.put("remoting-threads", "remotingThreads");
        CONNECTORS_KEYS_MAP.put(BATCH_DELAY, "batchDelay");
        CONNECTORS_KEYS_MAP.put("connect-timeout-millis", "connect-timeout-millis");
        CONNECTORS_KEYS_MAP.put("anycast-prefix", "anycastPrefix");
        CONNECTORS_KEYS_MAP.put("multicast-prefix", "multicastPrefix");
        CONNECTORS_KEYS_MAP.put(VERIFY_HOST, "verifyHost");
        ACCEPTOR_KEYS_MAP.put(InVMTransportDefinition.SERVER_ID.getName(), "serverId");
        ACCEPTOR_KEYS_MAP.put(BATCH_DELAY, "batchDelay");
        ACCEPTOR_KEYS_MAP.put("buffer-pooling", "bufferPooling");
        ACCEPTOR_KEYS_MAP.put("cluster-connection", "clusterConnection");
        ACCEPTOR_KEYS_MAP.put("connection-ttl", "connectionTtl");
        ACCEPTOR_KEYS_MAP.put("connections-allowed", "connectionsAllowed");
        ACCEPTOR_KEYS_MAP.put("direct-deliver", "directDeliver");
        ACCEPTOR_KEYS_MAP.put(ENABLED_CIPHER_SUITES, "enabledCipherSuites");
        ACCEPTOR_KEYS_MAP.put(ENABLED_PROTOCOLS, "enabledProtocols");
        ACCEPTOR_KEYS_MAP.put(HOST, HOST);
        ACCEPTOR_KEYS_MAP.put("http-response-time", "httpResponseTime");
        ACCEPTOR_KEYS_MAP.put("http-server-scan-period", "httpServerScanPeriod");
        ACCEPTOR_KEYS_MAP.put(HTTP_UPGRADE_ENABLED, "httpUpgradeEnabled");
        ACCEPTOR_KEYS_MAP.put(KEY_STORE_PASSWORD, "keyStorePassword");
        ACCEPTOR_KEYS_MAP.put(KEY_STORE_PATH, "keyStorePath");
        ACCEPTOR_KEYS_MAP.put(KEY_STORE_PROVIDER, "keyStoreProvider");
        ACCEPTOR_KEYS_MAP.put(KEY_STORE_TYPE, "keyStoreType");
        ACCEPTOR_KEYS_MAP.put("needs-client-auth", "needClientAuth");
        ACCEPTOR_KEYS_MAP.put("nio-remoting-threads", "nioRemotingThreads");
        ACCEPTOR_KEYS_MAP.put("remoting-threads", "remotingThreads");
        ACCEPTOR_KEYS_MAP.put(PORT, PORT);
        ACCEPTOR_KEYS_MAP.put("protocols", "protocols");
        ACCEPTOR_KEYS_MAP.put(SSL_ENABLED, "sslEnabled");
        ACCEPTOR_KEYS_MAP.put("stomp-enable-message-id", "stompEnableMessageId");
        ACCEPTOR_KEYS_MAP.put("stomp-min-large-message-size", "stompMinLargeMessageSize");
        ACCEPTOR_KEYS_MAP.put("stomp-consumer-credits", "stompConsumerCredits");
        ACCEPTOR_KEYS_MAP.put(TCP_NO_DELAY, "tcpNoDelay");
        ACCEPTOR_KEYS_MAP.put(TCP_RECEIVE_BUFFER_SIZE, "tcpReceiveBufferSize");
        ACCEPTOR_KEYS_MAP.put(TCP_SEND_BUFFER_SIZE, "tcpSendBufferSize");
        ACCEPTOR_KEYS_MAP.put(TRUST_STORE_PASSWORD, "trustStorePassword");
        ACCEPTOR_KEYS_MAP.put(TRUST_STORE_PATH, "trustStorePath");
        ACCEPTOR_KEYS_MAP.put(TRUST_STORE_PROVIDER, "trustStoreProvider");
        ACCEPTOR_KEYS_MAP.put(TRUST_STORE_TYPE, "trustStoreType");
        ACCEPTOR_KEYS_MAP.put("use-invm", "useInvm");
        ACCEPTOR_KEYS_MAP.put(USE_NIO, "useNio");
        ACCEPTOR_KEYS_MAP.put(VERIFY_HOST, "verifyHost");
        HashSet<String> allowable = new HashSet<String>(3);
        allowable.add("bufferPooling");
        allowable.add("connectionsAllowed");
        allowable.add("serverId");
        IN_VM_ALLOWABLE_KEYS = Collections.unmodifiableSet(allowable);
    }
}

