/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.broadcast;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.activemq.artemis.api.core.BroadcastEndpoint;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.group.Node;
import org.wildfly.extension.messaging.activemq.broadcast.BroadcastCommand;
import org.wildfly.extension.messaging.activemq.broadcast.BroadcastManager;
import org.wildfly.extension.messaging.activemq.broadcast.BroadcastReceiver;
import org.wildfly.extension.messaging.activemq.broadcast.BroadcastReceiverRegistrar;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class CommandDispatcherBroadcastEndpoint
implements BroadcastEndpoint {
    private final CommandDispatcherFactory factory;
    private final String name;
    private final BroadcastReceiverRegistrar registrar;
    private final Function<String, BroadcastManager> managerFactory;
    private final AtomicReference<Mode> mode = new AtomicReference<Mode>(Mode.CLOSED);
    private volatile BroadcastManager manager = null;
    private volatile Registration registration = null;
    private volatile CommandDispatcher<BroadcastReceiver> dispatcher;

    public CommandDispatcherBroadcastEndpoint(CommandDispatcherFactory factory, String name, BroadcastReceiverRegistrar registrar, Function<String, BroadcastManager> managerFactory) {
        this.factory = factory;
        this.name = name;
        this.registrar = registrar;
        this.managerFactory = managerFactory;
    }

    public void openClient() throws Exception {
        if (this.mode.compareAndSet(Mode.CLOSED, Mode.RECEIVER)) {
            this.manager = this.managerFactory.apply(this.name);
            this.registration = this.registrar.register(this.manager);
            this.open();
        }
    }

    public void openBroadcaster() throws Exception {
        if (this.mode.compareAndSet(Mode.CLOSED, Mode.BROADCASTER)) {
            this.open();
        }
    }

    private void open() throws Exception {
        this.dispatcher = this.factory.createCommandDispatcher((Object)this.name, (Object)this.registrar);
    }

    public void close(boolean isBroadcast) throws Exception {
        if (this.mode.getAndSet(Mode.CLOSED) != Mode.CLOSED) {
            if (this.dispatcher != null) {
                this.dispatcher.close();
            }
            if (this.registration != null) {
                this.registration.close();
            }
            if (this.manager != null) {
                this.manager.clear();
            }
        }
    }

    public void broadcast(byte[] data) throws Exception {
        if (this.mode.get() == Mode.BROADCASTER) {
            if (MessagingLogger.ROOT_LOGGER.isDebugEnabled()) {
                MessagingLogger.ROOT_LOGGER.debugf("Broadcasting to group %s: %s", (Object)this.name, (Object)Arrays.toString(data));
            }
            this.dispatcher.executeOnGroup((Command)new BroadcastCommand(data), new Node[0]);
        }
    }

    public byte[] receiveBroadcast() throws Exception {
        return this.mode.get() == Mode.RECEIVER ? this.manager.getBroadcast() : null;
    }

    public byte[] receiveBroadcast(long time, TimeUnit unit) throws Exception {
        return this.mode.get() == Mode.RECEIVER ? this.manager.getBroadcast(time, unit) : null;
    }

    private static enum Mode {
        BROADCASTER,
        RECEIVER,
        CLOSED;

    }
}

