/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager.transport.remote;

import jakarta.resource.spi.work.DistributableWork;
import jakarta.resource.spi.work.WorkException;
import java.io.Serializable;
import java.util.Arrays;
import org.jboss.jca.core.spi.workmanager.Address;
import org.jboss.jca.core.workmanager.ClassBundle;

public class ProtocolMessages {

    public static class RequestValues
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Request request;
        private final Serializable[] values;

        public RequestValues(Request request, Serializable ... values) {
            this.request = request;
            this.values = values;
        }

        public final Serializable[] getValues() {
            return this.values;
        }

        public final Request getRequest() {
            return this.request;
        }
    }

    public static class ResponseValues
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Response response;
        private final Serializable[] values;

        public ResponseValues(Response response, Serializable ... values) {
            this.response = response;
            this.values = values;
        }

        public final Response getResponse() {
            return this.response;
        }

        public final Serializable[] getValues() {
            return this.values;
        }
    }

    public static enum Response {
        OK_VOID(0, new Class[0]),
        OK_SERIALIZABLE(1, Serializable.class),
        WORK_EXCEPTION(1, WorkException.class),
        GENERIC_EXCEPTION(1, Throwable.class);

        private final int numberOfParameter;
        private final Class<?>[] typeOfParameters;

        private Response(int numberOfParameter, Class<?> ... typeOfParameters) {
            this.numberOfParameter = numberOfParameter;
            this.typeOfParameters = typeOfParameters;
        }

        public int getNumberOfParameter() {
            return this.numberOfParameter;
        }

        public Class<?>[] getTypeOfParameters() {
            return Arrays.copyOf(this.typeOfParameters, this.typeOfParameters.length);
        }
    }

    public static enum Request {
        JOIN(1, Serializable.class),
        LEAVE(1, Serializable.class),
        GET_WORKMANAGERS(0, new Class[0]),
        WORKMANAGER_ADD(2, Address.class, Serializable.class),
        WORKMANAGER_REMOVE(1, Address.class),
        UPDATE_SHORTRUNNING_FREE(2, Address.class, Long.class),
        UPDATE_LONGRUNNING_FREE(2, Address.class, Long.class),
        GET_SHORTRUNNING_FREE(1, Address.class),
        GET_LONGRUNNING_FREE(1, Address.class),
        GET_DISTRIBUTED_STATISTICS(1, Address.class),
        CLEAR_DISTRIBUTED_STATISTICS(1, Address.class),
        DELTA_DOWORK_ACCEPTED(1, Address.class),
        DELTA_DOWORK_REJECTED(1, Address.class),
        DELTA_STARTWORK_ACCEPTED(1, Address.class),
        DELTA_STARTWORK_REJECTED(1, Address.class),
        DELTA_SCHEDULEWORK_ACCEPTED(1, Address.class),
        DELTA_SCHEDULEWORK_REJECTED(1, Address.class),
        DELTA_WORK_SUCCESSFUL(1, Address.class),
        DELTA_WORK_FAILED(1, Address.class),
        PING(0, new Class[0]),
        DO_WORK(3, Address.class, ClassBundle.class, DistributableWork.class),
        SCHEDULE_WORK(3, Address.class, ClassBundle.class, DistributableWork.class),
        START_WORK(3, Address.class, ClassBundle.class, DistributableWork.class);

        private final int numberOfParameter;
        private final Class<?>[] typeOfParameters;

        private Request(int numberOfParameter, Class<?> ... typeOfParameters) {
            this.numberOfParameter = numberOfParameter;
            this.typeOfParameters = typeOfParameters;
        }

        public int getNumberOfParameter() {
            return this.numberOfParameter;
        }

        public Class<?>[] getTypeOfParameters() {
            return Arrays.copyOf(this.typeOfParameters, this.typeOfParameters.length);
        }
    }
}

