/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.AmqpSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.amqp.messaging.DeleteOnClose;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpTempDestinationTest
extends AmqpClientTestSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(AmqpTempDestinationTest.class);

    @Test(timeout=60000L)
    public void testCreateDynamicSenderToTopic() throws Exception {
        this.doTestCreateDynamicSender(true);
    }

    @Test(timeout=60000L)
    public void testCreateDynamicSenderToQueue() throws Exception {
        this.doTestCreateDynamicSender(false);
    }

    protected void doTestCreateDynamicSender(boolean topic) throws Exception {
        Target target = this.createDynamicTarget(topic);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(target);
        AmqpTempDestinationTest.assertNotNull((Object)sender);
        Target remoteTarget = (Target)((Sender)sender.getEndpoint()).getRemoteTarget();
        AmqpTempDestinationTest.assertTrue((boolean)remoteTarget.getDynamic());
        AmqpTempDestinationTest.assertTrue((boolean)remoteTarget.getDurable().equals((Object)TerminusDurability.NONE));
        AmqpTempDestinationTest.assertTrue((boolean)remoteTarget.getExpiryPolicy().equals((Object)TerminusExpiryPolicy.LINK_DETACH));
        Map dynamicNodeProperties = remoteTarget.getDynamicNodeProperties();
        AmqpTempDestinationTest.assertTrue((boolean)dynamicNodeProperties.containsKey(AmqpSupport.LIFETIME_POLICY));
        AmqpTempDestinationTest.assertEquals((Object)DeleteOnClose.getInstance(), dynamicNodeProperties.get(AmqpSupport.LIFETIME_POLICY));
        Queue queueView = this.getProxyToQueue(remoteTarget.getAddress());
        AmqpTempDestinationTest.assertNotNull((Object)queueView);
        connection.close();
    }

    @Test(timeout=60000L)
    public void testDynamicSenderLifetimeBoundToLinkTopic() throws Exception {
        this.doTestDynamicSenderLifetimeBoundToLinkQueue(true);
    }

    @Test(timeout=60000L)
    public void testDynamicSenderLifetimeBoundToLinkQueue() throws Exception {
        this.doTestDynamicSenderLifetimeBoundToLinkQueue(false);
    }

    protected void doTestDynamicSenderLifetimeBoundToLinkQueue(boolean topic) throws Exception {
        Target target = this.createDynamicTarget(topic);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(target);
        AmqpTempDestinationTest.assertNotNull((Object)sender);
        Target remoteTarget = (Target)((Sender)sender.getEndpoint()).getRemoteTarget();
        Queue queueView = this.getProxyToQueue(remoteTarget.getAddress());
        AmqpTempDestinationTest.assertNotNull((Object)queueView);
        sender.close();
        queueView = this.getProxyToQueue(remoteTarget.getAddress());
        AmqpTempDestinationTest.assertNull((Object)queueView);
        connection.close();
    }

    @Test(timeout=60000L)
    public void testCreateDynamicReceiverToTopic() throws Exception {
        this.doTestCreateDynamicSender(true);
    }

    @Test(timeout=60000L)
    public void testCreateDynamicReceiverToQueue() throws Exception {
        this.doTestCreateDynamicSender(false);
    }

    protected void doTestCreateDynamicReceiver(boolean topic) throws Exception {
        Source source = this.createDynamicSource(topic);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(source);
        AmqpTempDestinationTest.assertNotNull((Object)receiver);
        Source remoteSource = (Source)((Receiver)receiver.getEndpoint()).getRemoteSource();
        AmqpTempDestinationTest.assertTrue((boolean)remoteSource.getDynamic());
        AmqpTempDestinationTest.assertTrue((boolean)remoteSource.getDurable().equals((Object)TerminusDurability.NONE));
        AmqpTempDestinationTest.assertTrue((boolean)remoteSource.getExpiryPolicy().equals((Object)TerminusExpiryPolicy.LINK_DETACH));
        Map dynamicNodeProperties = remoteSource.getDynamicNodeProperties();
        AmqpTempDestinationTest.assertTrue((boolean)dynamicNodeProperties.containsKey(AmqpSupport.LIFETIME_POLICY));
        AmqpTempDestinationTest.assertEquals((Object)DeleteOnClose.getInstance(), dynamicNodeProperties.get(AmqpSupport.LIFETIME_POLICY));
        Queue queueView = this.getProxyToQueue(remoteSource.getAddress());
        AmqpTempDestinationTest.assertNotNull((Object)queueView);
        connection.close();
    }

    @Test(timeout=60000L)
    public void testDynamicReceiverLifetimeBoundToLinkTopic() throws Exception {
        this.doTestDynamicReceiverLifetimeBoundToLinkQueue(true);
    }

    @Test(timeout=60000L)
    public void testDynamicReceiverLifetimeBoundToLinkQueue() throws Exception {
        this.doTestDynamicReceiverLifetimeBoundToLinkQueue(false);
    }

    protected void doTestDynamicReceiverLifetimeBoundToLinkQueue(boolean topic) throws Exception {
        Source source = this.createDynamicSource(topic);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(source);
        AmqpTempDestinationTest.assertNotNull((Object)receiver);
        Source remoteSource = (Source)((Receiver)receiver.getEndpoint()).getRemoteSource();
        Queue queueView = this.getProxyToQueue(remoteSource.getAddress());
        AmqpTempDestinationTest.assertNotNull((Object)queueView);
        receiver.close();
        queueView = this.getProxyToQueue(remoteSource.getAddress());
        AmqpTempDestinationTest.assertNull((Object)queueView);
        connection.close();
    }

    @Test(timeout=60000L)
    public void TestCreateDynamicQueueSenderAndPublish() throws Exception {
        this.doTestCreateDynamicSenderAndPublish(false);
    }

    @Test(timeout=60000L)
    public void TestCreateDynamicTopicSenderAndPublish() throws Exception {
        this.doTestCreateDynamicSenderAndPublish(true);
    }

    protected void doTestCreateDynamicSenderAndPublish(boolean topic) throws Exception {
        Target target = this.createDynamicTarget(topic);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(target);
        AmqpTempDestinationTest.assertNotNull((Object)sender);
        Target remoteTarget = (Target)((Sender)sender.getEndpoint()).getRemoteTarget();
        Queue queueView = this.getProxyToQueue(remoteTarget.getAddress());
        AmqpTempDestinationTest.assertNotNull((Object)queueView);
        String address = sender.getSender().getRemoteTarget().getAddress();
        LOG.debug("New dynamic sender address -> {}", (Object)address);
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg-1");
        message.setText("Test-Message");
        AmqpReceiver receiver = session.createReceiver(address);
        receiver.flow(1);
        sender.send(message);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpTempDestinationTest.assertNotNull((String)"Should have read a message", (Object)received);
        received.accept();
        receiver.close();
        sender.close();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testCreateDynamicReceiverToTopicAndSend() throws Exception {
        this.doTestCreateDynamicSender(true);
    }

    @Test(timeout=60000L)
    public void testCreateDynamicReceiverToQueueAndSend() throws Exception {
        this.doTestCreateDynamicSender(false);
    }

    protected void doTestCreateDynamicReceiverAndSend(boolean topic) throws Exception {
        Source source = this.createDynamicSource(topic);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(source);
        AmqpTempDestinationTest.assertNotNull((Object)receiver);
        Source remoteSource = (Source)((Receiver)receiver.getEndpoint()).getRemoteSource();
        Queue queueView = this.getProxyToQueue(remoteSource.getAddress());
        AmqpTempDestinationTest.assertNotNull((Object)queueView);
        String address = receiver.getReceiver().getRemoteSource().getAddress();
        LOG.debug("New dynamic receiver address -> {}", (Object)address);
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg-1");
        message.setText("Test-Message");
        AmqpSender sender = session.createSender(address);
        sender.send(message);
        receiver.flow(1);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpTempDestinationTest.assertNotNull((String)"Should have read a message", (Object)received);
        received.accept();
        sender.close();
        receiver.close();
        connection.close();
    }
}

