/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.DestinationUtil;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.policy.JmsDefaultPrefetchPolicy;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSMessageConsumerTest
extends JMSClientTestSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(JMSMessageConsumerTest.class);

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,OPENWIRE,CORE";
    }

    @Test(timeout=30000L)
    public void testDeliveryModeAMQPProducerCoreConsumer() throws Exception {
        Connection connection = this.createConnection();
        Connection connection2 = this.createCoreConnection();
        this.testDeliveryMode(connection, connection2);
    }

    @Test(timeout=30000L)
    public void testDeliveryModeAMQPProducerAMQPConsumer() throws Exception {
        Connection connection = this.createConnection();
        Connection connection2 = this.createConnection();
        this.testDeliveryMode(connection, connection2);
    }

    @Test(timeout=30000L)
    public void testDeliveryModeCoreProducerAMQPConsumer() throws Exception {
        Connection connection = this.createCoreConnection();
        Connection connection2 = this.createConnection();
        this.testDeliveryMode(connection, connection2);
    }

    @Test(timeout=30000L)
    public void testDeliveryModeCoreProducerCoreConsumer() throws Exception {
        Connection connection = this.createCoreConnection();
        Connection connection2 = this.createCoreConnection();
        this.testDeliveryMode(connection, connection2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeliveryMode(Connection connection1, Connection connection2) throws JMSException {
        try {
            Session session1 = connection1.createSession(false, 1);
            Session session2 = connection2.createSession(false, 1);
            jakarta.jms.Queue queue1 = session1.createQueue(this.getQueueName());
            jakarta.jms.Queue queue2 = session2.createQueue(this.getQueueName());
            MessageConsumer consumer2 = session2.createConsumer((Destination)queue2);
            MessageProducer producer = session1.createProducer((Destination)queue1);
            producer.setDeliveryMode(2);
            connection1.start();
            TextMessage message = session1.createTextMessage();
            message.setText("hello");
            producer.send((Message)message);
            Message received = consumer2.receive(100L);
            JMSMessageConsumerTest.assertNotNull((String)"Should have received a message by now.", (Object)received);
            JMSMessageConsumerTest.assertTrue((String)"Should be an instance of TextMessage", (boolean)(received instanceof TextMessage));
            JMSMessageConsumerTest.assertEquals((long)2L, (long)received.getJMSDeliveryMode());
        }
        finally {
            connection1.close();
            connection2.close();
        }
    }

    @Test(timeout=30000L)
    public void testPriorityAMQPProducerCoreConsumer() throws Exception {
        Connection connection = this.createConnection();
        Connection connection2 = this.createCoreConnection();
        this.testPriority(connection, connection2);
    }

    @Test(timeout=30000L)
    public void testPriorityAMQPProducerAMQPConsumer() throws Exception {
        Connection connection = this.createConnection();
        Connection connection2 = this.createConnection();
        this.testPriority(connection, connection2);
    }

    @Test(timeout=30000L)
    public void testPriorityModeCoreProducerAMQPConsumer() throws Exception {
        Connection connection = this.createCoreConnection();
        Connection connection2 = this.createConnection();
        this.testPriority(connection, connection2);
    }

    @Test(timeout=30000L)
    public void testPriorityCoreProducerCoreConsumer() throws Exception {
        Connection connection = this.createCoreConnection();
        Connection connection2 = this.createCoreConnection();
        this.testPriority(connection, connection2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPriority(Connection connection1, Connection connection2) throws JMSException {
        try {
            Session session1 = connection1.createSession(false, 1);
            Session session2 = connection2.createSession(false, 1);
            jakarta.jms.Queue queue1 = session1.createQueue(this.getQueueName());
            jakarta.jms.Queue queue2 = session2.createQueue(this.getQueueName());
            MessageConsumer consumer2 = session2.createConsumer((Destination)queue2);
            MessageProducer producer = session1.createProducer((Destination)queue1);
            producer.setPriority(2);
            connection1.start();
            TextMessage message = session1.createTextMessage();
            message.setText("hello");
            producer.send((Message)message);
            Message received = consumer2.receive(100L);
            JMSMessageConsumerTest.assertNotNull((String)"Should have received a message by now.", (Object)received);
            JMSMessageConsumerTest.assertTrue((String)"Should be an instance of TextMessage", (boolean)(received instanceof TextMessage));
            JMSMessageConsumerTest.assertEquals((long)2L, (long)received.getJMSPriority());
        }
        finally {
            connection1.close();
            connection2.close();
        }
    }

    @Test(timeout=60000L)
    public void testSelectorOnTopic() throws Exception {
        this.doTestSelector(true);
    }

    @Test(timeout=60000L)
    public void testSelectorOnQueue() throws Exception {
        this.doTestSelector(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestSelector(boolean topic) throws Exception {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            Object destination = null;
            destination = topic ? session.createTopic(this.getTopicName()) : session.createQueue(this.getQueueName());
            MessageProducer producer = session.createProducer((Destination)destination);
            MessageConsumer messageConsumer = session.createConsumer((Destination)destination, "color = 'RED'");
            TextMessage message = session.createTextMessage();
            message.setText("msg:0");
            producer.send((Message)message);
            message = session.createTextMessage();
            message.setText("msg:1");
            message.setStringProperty("color", "RED");
            producer.send((Message)message);
            connection.start();
            TextMessage m = (TextMessage)messageConsumer.receive(5000L);
            JMSMessageConsumerTest.assertNotNull((Object)m);
            JMSMessageConsumerTest.assertEquals((Object)"msg:1", (Object)m.getText());
            JMSMessageConsumerTest.assertEquals((Object)m.getStringProperty("color"), (Object)"RED");
        }
    }

    @Test(timeout=60000L)
    public void testDurableSubscriptionWithConfigurationManagedQueueWithCore() throws Exception {
        this.testDurableSubscriptionWithConfigurationManagedQueue(() -> this.createCoreConnection(false));
    }

    @Test(timeout=60000L)
    public void testDurableSubscriptionWithConfigurationManagedQueueWithOpenWire() throws Exception {
        this.testDurableSubscriptionWithConfigurationManagedQueue(() -> this.createOpenWireConnection(false));
    }

    @Test(timeout=60000L)
    public void testDurableSubscriptionWithConfigurationManagedQueueWithAMQP() throws Exception {
        this.testDurableSubscriptionWithConfigurationManagedQueue(() -> JMSMessageConsumerTest.super.createConnection(false));
    }

    private void testDurableSubscriptionWithConfigurationManagedQueue(JMSClientTestSupport.ConnectionSupplier connectionSupplier) throws Exception {
        String clientId = "bar";
        String subName = "foo";
        String queueName = DestinationUtil.createQueueNameForSubscription((boolean)true, (String)"bar", (String)"foo").toString();
        this.server.stop();
        this.server.getConfiguration().addQueueConfiguration(new QueueConfiguration(queueName).setAddress("myTopic").setFilterString("color = 'BLUE'").setRoutingType(RoutingType.MULTICAST));
        this.server.getConfiguration().setAmqpUseCoreSubscriptionNaming(true);
        this.server.start();
        try (Connection connection = connectionSupplier.createConnection();){
            connection.setClientID("bar");
            Session session = connection.createSession(false, 1);
            Topic destination = session.createTopic("myTopic");
            TopicSubscriber messageConsumer = session.createDurableSubscriber(destination, "foo");
            messageConsumer.close();
            Queue queue = this.server.locateQueue(queueName);
            JMSMessageConsumerTest.assertNotNull((Object)queue);
            JMSMessageConsumerTest.assertNotNull((Object)queue.getFilter());
            JMSMessageConsumerTest.assertEquals((Object)"color = 'BLUE'", (Object)queue.getFilter().getFilterString().toString());
        }
    }

    @Test(timeout=30000L)
    public void testSelectorsWithJMSTypeOnTopic() throws Exception {
        this.doTestSelectorsWithJMSType(true);
    }

    @Test(timeout=30000L)
    public void testSelectorsWithJMSTypeOnQueue() throws Exception {
        this.doTestSelectorsWithJMSType(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestSelectorsWithJMSType(boolean topic) throws Exception {
        String type = "myJMSType";
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            Object destination = null;
            destination = topic ? session.createTopic(this.getTopicName()) : session.createQueue(this.getQueueName());
            MessageProducer producer = session.createProducer((Destination)destination);
            MessageConsumer consumer = session.createConsumer((Destination)destination, "JMSType = 'myJMSType'");
            TextMessage message1 = session.createTextMessage();
            message1.setText("text");
            producer.send((Message)message1, 1, 4, 0L);
            TextMessage message2 = session.createTextMessage();
            message2.setJMSType("myJMSType");
            message2.setText("text + type");
            producer.send((Message)message2, 1, 4, 0L);
            connection.start();
            Message msg = consumer.receive(2000L);
            JMSMessageConsumerTest.assertNotNull((Object)msg);
            JMSMessageConsumerTest.assertTrue((boolean)(msg instanceof TextMessage));
            JMSMessageConsumerTest.assertEquals((String)"Unexpected JMSType value", (Object)"myJMSType", (Object)msg.getJMSType());
            JMSMessageConsumerTest.assertEquals((String)"Unexpected message content", (Object)"text + type", (Object)((TextMessage)msg).getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testSelectorsWithJMSCorrelationID() throws Exception {
        String correlationID = UUID.randomUUID().toString();
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage message1 = session.createTextMessage();
            message1.setText("text");
            producer.send((Message)message1);
            TextMessage message2 = session.createTextMessage();
            message2.setJMSCorrelationID(correlationID);
            message2.setText("JMSCorrelationID");
            producer.send((Message)message2);
            QueueBrowser browser = session.createBrowser(queue);
            Enumeration enumeration = browser.getEnumeration();
            int count = 0;
            while (enumeration.hasMoreElements()) {
                Message m = (Message)enumeration.nextElement();
                JMSMessageConsumerTest.assertTrue((boolean)(m instanceof TextMessage));
                ++count;
            }
            JMSMessageConsumerTest.assertEquals((long)2L, (long)count);
            MessageConsumer consumer = session.createConsumer((Destination)queue, "JMSCorrelationID = '" + correlationID + "'");
            Message msg = consumer.receive(2000L);
            JMSMessageConsumerTest.assertNotNull((Object)msg);
            JMSMessageConsumerTest.assertTrue((boolean)(msg instanceof TextMessage));
            JMSMessageConsumerTest.assertEquals((String)"Unexpected JMSCorrelationID value", (Object)correlationID, (Object)msg.getJMSCorrelationID());
            JMSMessageConsumerTest.assertEquals((String)"Unexpected message content", (Object)"JMSCorrelationID", (Object)((TextMessage)msg).getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testSelectorsWithJMSPriority() throws Exception {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage message = session.createTextMessage();
            message.setText("hello");
            producer.send((Message)message, 2, 5, 0L);
            message = session.createTextMessage();
            message.setText("hello + 9");
            producer.send((Message)message, 2, 9, 0L);
            QueueBrowser browser = session.createBrowser(queue);
            Enumeration enumeration = browser.getEnumeration();
            int count = 0;
            while (enumeration.hasMoreElements()) {
                Message m = (Message)enumeration.nextElement();
                JMSMessageConsumerTest.assertTrue((boolean)(m instanceof TextMessage));
                ++count;
            }
            JMSMessageConsumerTest.assertEquals((long)2L, (long)count);
            MessageConsumer consumer = session.createConsumer((Destination)queue, "JMSPriority > 8");
            Message msg = consumer.receive(2000L);
            JMSMessageConsumerTest.assertNotNull((Object)msg);
            JMSMessageConsumerTest.assertTrue((boolean)(msg instanceof TextMessage));
            JMSMessageConsumerTest.assertEquals((Object)"hello + 9", (Object)((TextMessage)msg).getText());
        }
    }

    @Test(timeout=30000L)
    public void testSelectorsWithJMSXGroupIDOnTopic() throws Exception {
        this.doTestSelectorsWithJMSXGroupID(true);
    }

    @Test(timeout=30000L)
    public void testSelectorsWithJMSXGroupIDOnQueue() throws Exception {
        this.doTestSelectorsWithJMSXGroupID(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestSelectorsWithJMSXGroupID(boolean topic) throws Exception {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            Object destination = null;
            destination = topic ? session.createTopic(this.getTopicName()) : session.createQueue(this.getQueueName());
            MessageProducer producer = session.createProducer((Destination)destination);
            MessageConsumer consumer = session.createConsumer((Destination)destination, "JMSXGroupID = '1'");
            TextMessage message = session.createTextMessage();
            message.setText("group 1 - 1");
            message.setStringProperty("JMSXGroupID", "1");
            message.setIntProperty("JMSXGroupSeq", 1);
            producer.send((Message)message);
            message = session.createTextMessage();
            message.setText("group 2");
            message.setStringProperty("JMSXGroupID", "2");
            producer.send((Message)message);
            message = session.createTextMessage();
            message.setText("group 1 - 2");
            message.setStringProperty("JMSXGroupID", "1");
            message.setIntProperty("JMSXGroupSeq", -1);
            producer.send((Message)message);
            connection.start();
            Message msg = consumer.receive(2000L);
            JMSMessageConsumerTest.assertNotNull((Object)msg);
            JMSMessageConsumerTest.assertTrue((boolean)(msg instanceof TextMessage));
            JMSMessageConsumerTest.assertEquals((Object)"group 1 - 1", (Object)((TextMessage)msg).getText());
            msg = consumer.receive(2000L);
            JMSMessageConsumerTest.assertNotNull((Object)msg);
            JMSMessageConsumerTest.assertTrue((boolean)(msg instanceof TextMessage));
            JMSMessageConsumerTest.assertEquals((Object)"group 1 - 2", (Object)((TextMessage)msg).getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testSelectorsWithJMSDeliveryOnQueue() throws Exception {
        String selector = "JMSDeliveryMode = 'PERSISTENT'";
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue destination = session.createQueue(this.getQueueName());
            MessageProducer producer = session.createProducer((Destination)destination);
            MessageConsumer consumer = session.createConsumer((Destination)destination, selector);
            TextMessage message1 = session.createTextMessage();
            message1.setText("non-persistent");
            producer.send((Message)message1, 1, 4, 0L);
            TextMessage message2 = session.createTextMessage();
            message2.setText("persistent");
            producer.send((Message)message2, 2, 4, 0L);
            connection.start();
            Message msg = consumer.receive(2000L);
            JMSMessageConsumerTest.assertNotNull((Object)msg);
            JMSMessageConsumerTest.assertTrue((boolean)(msg instanceof TextMessage));
            JMSMessageConsumerTest.assertEquals((String)"Unexpected JMSDeliveryMode value", (long)2L, (long)msg.getJMSDeliveryMode());
            JMSMessageConsumerTest.assertEquals((String)"Unexpected message content", (Object)"persistent", (Object)((TextMessage)msg).getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testSelectorsWithJMSTimestampOnQueue() throws Exception {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue destination = session.createQueue(this.getQueueName());
            MessageProducer producer = session.createProducer((Destination)destination);
            TextMessage message1 = session.createTextMessage();
            message1.setText("filtered");
            producer.send((Message)message1, 2, 4, 0L);
            Thread.sleep(2L);
            TextMessage message2 = session.createTextMessage();
            message2.setText("expected");
            producer.send((Message)message2, 2, 4, 0L);
            MessageConsumer consumer = session.createConsumer((Destination)destination, "JMSTimestamp = " + message2.getJMSTimestamp());
            connection.start();
            Message msg = consumer.receive(2000L);
            JMSMessageConsumerTest.assertNotNull((Object)msg);
            JMSMessageConsumerTest.assertTrue((boolean)(msg instanceof TextMessage));
            JMSMessageConsumerTest.assertEquals((String)"Unexpected JMSTimestamp value", (long)message2.getJMSTimestamp(), (long)msg.getJMSTimestamp());
            JMSMessageConsumerTest.assertEquals((String)"Unexpected message content", (Object)"expected", (Object)((TextMessage)msg).getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testSelectorsWithJMSExpirationOnQueue() throws Exception {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue destination = session.createQueue(this.getQueueName());
            MessageProducer producer = session.createProducer((Destination)destination);
            TextMessage message1 = session.createTextMessage();
            message1.setText("filtered");
            producer.send((Message)message1, 2, 4, 0L);
            TextMessage message2 = session.createTextMessage();
            message2.setText("expected");
            producer.send((Message)message2, 2, 4, 60000L);
            MessageConsumer consumer = session.createConsumer((Destination)destination, "JMSExpiration = " + message2.getJMSExpiration());
            connection.start();
            Message msg = consumer.receive(2000L);
            JMSMessageConsumerTest.assertNotNull((Object)msg);
            JMSMessageConsumerTest.assertTrue((boolean)(msg instanceof TextMessage));
            JMSMessageConsumerTest.assertEquals((String)"Unexpected JMSExpiration value", (long)message2.getJMSExpiration(), (long)msg.getJMSExpiration());
            JMSMessageConsumerTest.assertEquals((String)"Unexpected message content", (Object)"expected", (Object)((TextMessage)msg).getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testJMSSelectorFiltersJMSMessageIDOnTopic() throws Exception {
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage message = session.createTextMessage();
            producer.send((Message)message);
            producer.send((Message)session.createTextMessage());
            connection.start();
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue, "JMSMessageID = '" + message.getJMSMessageID() + "'");
            TextMessage m = (TextMessage)messageConsumer.receive(5000L);
            JMSMessageConsumerTest.assertNotNull((Object)m);
            JMSMessageConsumerTest.assertEquals((Object)message.getJMSMessageID(), (Object)m.getJMSMessageID());
            JMSMessageConsumerTest.assertNull((Object)messageConsumer.receive(1000L));
        }
    }

    @Test(timeout=60000L)
    public void testZeroPrefetchWithTwoConsumers() throws Exception {
        JmsConnection connection = (JmsConnection)this.createConnection();
        ((JmsDefaultPrefetchPolicy)connection.getPrefetchPolicy()).setAll(0);
        connection.start();
        Session session = connection.createSession(false, 1);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("Msg1"));
        producer.send((Message)session.createTextMessage("Msg2"));
        MessageConsumer consumer1 = session.createConsumer((Destination)queue);
        MessageConsumer consumer2 = session.createConsumer((Destination)queue);
        TextMessage answer = (TextMessage)consumer1.receive(5000L);
        JMSMessageConsumerTest.assertNotNull((Object)answer);
        JMSMessageConsumerTest.assertEquals((String)"Should have received a message!", (Object)answer.getText(), (Object)"Msg1");
        answer = (TextMessage)consumer2.receive(5000L);
        JMSMessageConsumerTest.assertNotNull((Object)answer);
        JMSMessageConsumerTest.assertEquals((String)"Should have received a message!", (Object)answer.getText(), (Object)"Msg2");
        answer = (TextMessage)consumer2.receiveNoWait();
        JMSMessageConsumerTest.assertNull((String)"Should have not received a message!", (Object)answer);
    }

    @Test(timeout=30000L)
    public void testProduceAndConsumeLargeNumbersOfTopicMessagesClientAck() throws Exception {
        this.doTestProduceAndConsumeLargeNumbersOfMessages(true, 2);
    }

    @Test(timeout=30000L)
    public void testProduceAndConsumeLargeNumbersOfQueueMessagesClientAck() throws Exception {
        this.doTestProduceAndConsumeLargeNumbersOfMessages(false, 2);
    }

    @Test(timeout=30000L)
    public void testProduceAndConsumeLargeNumbersOfTopicMessagesAutoAck() throws Exception {
        this.doTestProduceAndConsumeLargeNumbersOfMessages(true, 1);
    }

    @Test(timeout=30000L)
    public void testProduceAndConsumeLargeNumbersOfQueueMessagesAutoAck() throws Exception {
        this.doTestProduceAndConsumeLargeNumbersOfMessages(false, 1);
    }

    public void doTestProduceAndConsumeLargeNumbersOfMessages(boolean topic, int ackMode) throws Exception {
        int MSG_COUNT = 1000;
        final CountDownLatch done = new CountDownLatch(1000);
        JmsConnection connection = (JmsConnection)this.createConnection();
        connection.setForceAsyncSend(true);
        connection.start();
        Session session = connection.createSession(false, ackMode);
        Object destination = topic ? session.createTopic(this.getTopicName()) : session.createQueue(this.getQueueName());
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                try {
                    message.acknowledge();
                    done.countDown();
                }
                catch (JMSException ex) {
                    LOG.debug("Caught exception.", (Throwable)ex);
                }
            }
        });
        MessageProducer producer = session.createProducer((Destination)destination);
        TextMessage textMessage = session.createTextMessage();
        textMessage.setText("messageText");
        for (int i = 0; i < 1000; ++i) {
            producer.send((Message)textMessage);
        }
        JMSMessageConsumerTest.assertTrue((String)"Did not receive all messages: 1000", (boolean)done.await(15L, TimeUnit.SECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testPrefetchedMessagesAreNotConsumedOnConsumerClose() throws Exception {
        int NUM_MESSAGES = 10;
        try (Connection connection = this.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
            MessageProducer producer = session.createProducer((Destination)queue);
            byte[] bytes = new byte[2048];
            new Random().nextBytes(bytes);
            for (int i = 0; i < 10; ++i) {
                TextMessage message = session.createTextMessage();
                message.setText("msg:" + i);
                producer.send((Message)message);
            }
            connection.close();
            Queue queueView = this.getProxyToQueue(this.getQueueName());
            Wait.assertEquals((long)10L, () -> ((Queue)queueView).getMessageCount());
            connection = this.createConnection();
            session = connection.createSession(false, 1);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            Thread.sleep(100L);
            consumer.close();
            connection.close();
            Wait.assertEquals((long)10L, () -> ((Queue)queueView).getMessageCount());
        }
    }

    @Test(timeout=60000L)
    public void testMessagesReceivedInParallel() throws Throwable {
        int numMessages = 50000;
        long time = System.currentTimeMillis();
        final ArrayList exceptions = new ArrayList();
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Connection connectionConsumer = null;
                try {
                    connectionConsumer = JMSMessageConsumerTest.this.createConnection();
                    connectionConsumer.start();
                    Session sessionConsumer = connectionConsumer.createSession(false, 1);
                    jakarta.jms.Queue queue = sessionConsumer.createQueue(JMSMessageConsumerTest.this.getQueueName());
                    MessageConsumer consumer = sessionConsumer.createConsumer((Destination)queue);
                    long n = 0L;
                    for (int count = 50000; count > 0; --count) {
                        try {
                            if (++n % 1000L == 0L) {
                                JMSMessageConsumerTest.this.instanceLog.debug((Object)("received " + n + " messages"));
                            }
                            Message m = consumer.receive(5000L);
                            Assert.assertNotNull((String)("Could not receive message count=" + count + " on consumer"), (Object)m);
                            continue;
                        }
                        catch (JMSException e) {
                            e.printStackTrace();
                            break;
                        }
                    }
                }
                catch (Throwable e) {
                    exceptions.add(e);
                    e.printStackTrace();
                }
                finally {
                    try {
                        connectionConsumer.close();
                    }
                    catch (Throwable sessionConsumer) {}
                }
            }
        });
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        t.start();
        MessageProducer p = session.createProducer((Destination)queue);
        p.setDeliveryMode(1);
        for (int i = 0; i < 50000; ++i) {
            BytesMessage message = session.createBytesMessage();
            message.writeUTF("Hello world!!!!" + i);
            message.setIntProperty("count", i);
            p.send((Message)message);
        }
        t.join();
        if (!exceptions.isEmpty()) {
            throw (Throwable)exceptions.get(0);
        }
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        connection.close();
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
        long taken = System.currentTimeMillis() - time;
        this.instanceLog.debug((Object)("Microbenchamrk ran in " + taken + " milliseconds, sending/receiving " + 50000));
        double messagesPerSecond = 50000.0 / (double)taken * 1000.0;
        this.instanceLog.debug((Object)((int)messagesPerSecond + " messages per second"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testClientAckMessages() throws Exception {
        int numMessages = 10;
        try (Connection connection = this.createConnection();){
            long time = System.currentTimeMillis();
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
            MessageProducer producer = session.createProducer((Destination)queue);
            byte[] bytes = new byte[2048];
            new Random().nextBytes(bytes);
            for (int i = 0; i < 10; ++i) {
                TextMessage message = session.createTextMessage();
                message.setText("msg:" + i);
                producer.send((Message)message);
            }
            connection.close();
            Queue queueView = this.getProxyToQueue(this.getQueueName());
            Wait.assertEquals((long)10L, () -> ((Queue)queueView).getMessageCount());
            connection = this.createConnection();
            session = connection.createSession(false, 2);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            for (int i = 0; i < 10; ++i) {
                Message msg = consumer.receive(5000L);
                Assert.assertNotNull((String)("" + i), (Object)msg);
                Assert.assertTrue((String)("" + msg), (boolean)(msg instanceof TextMessage));
                String text = ((TextMessage)msg).getText();
                Assert.assertEquals((Object)text, (Object)("msg:" + i));
                msg.acknowledge();
            }
            consumer.close();
            connection.close();
            Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testTimedOutWaitingForWriteLogOnConsumer() throws Throwable {
        String name = "exampleQueue1";
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoDeleteQueues(Boolean.valueOf(false)));
        int numMessages = 40;
        try (Connection connection = this.createConnection();){
            int i;
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue(name);
            MessageProducer producer = session.createProducer((Destination)queue);
            for (i = 0; i < 40; ++i) {
                TextMessage message = session.createTextMessage();
                message.setText("Message temporary");
                producer.send((Message)message);
            }
            producer.close();
            session.close();
            for (i = 0; i < 40; ++i) {
                session = connection.createSession(false, 1);
                queue = session.createQueue(name);
                MessageConsumer c = session.createConsumer((Destination)queue);
                Assert.assertNotNull((Object)c.receive(1000L));
                session.close();
            }
            session = connection.createSession(false, 1);
            queue = session.createQueue(name);
            MessageConsumer c = session.createConsumer((Destination)queue);
            for (int i2 = 0; i2 < 40; ++i2) {
                Assert.assertNull((Object)c.receive(1L));
            }
            producer.close();
            session.close();
        }
    }

    @Test
    public void testConcurrentSharedConsumerConnections() throws Exception {
        int concurrentConnections = 20;
        ExecutorService executorService = Executors.newFixedThreadPool(20);
        AtomicBoolean failedToSubscribe = new AtomicBoolean(false);
        for (int i = 1; i < 20; ++i) {
            executorService.submit(() -> {
                try (Connection connection = this.createConnection();){
                    connection.start();
                    Session session = connection.createSession();
                    Topic topic = session.createTopic("topics.foo");
                    session.createSharedConsumer(topic, "MY_SUB");
                    Thread.sleep(100L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    failedToSubscribe.set(true);
                }
            });
        }
        executorService.shutdown();
        executorService.awaitTermination(30L, TimeUnit.SECONDS);
        JMSMessageConsumerTest.assertFalse((boolean)failedToSubscribe.get());
    }

    @Test(timeout=30000L)
    public void testBrokerRestartAMQPProducerAMQPConsumer() throws Exception {
        Connection connection = this.createFailoverConnection();
        Connection connection2 = this.createFailoverConnection();
        this.testBrokerRestart(connection, connection2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBrokerRestart(Connection connection1, Connection connection2) throws Exception {
        try {
            Session session1 = connection1.createSession(false, 1);
            Session session2 = connection2.createSession(false, 1);
            jakarta.jms.Queue queue1 = session1.createQueue(this.getQueueName());
            jakarta.jms.Queue queue2 = session2.createQueue(this.getQueueName());
            MessageConsumer consumer2 = session2.createConsumer((Destination)queue2);
            MessageProducer producer = session1.createProducer((Destination)queue1);
            producer.setDeliveryMode(2);
            connection1.start();
            TextMessage message = session1.createTextMessage();
            message.setText("hello");
            producer.send((Message)message);
            Message received = consumer2.receive(100L);
            JMSMessageConsumerTest.assertNotNull((String)"Should have received a message by now.", (Object)received);
            JMSMessageConsumerTest.assertTrue((String)"Should be an instance of TextMessage", (boolean)(received instanceof TextMessage));
            JMSMessageConsumerTest.assertEquals((long)2L, (long)received.getJMSDeliveryMode());
            this.server.stop();
            Wait.waitFor(() -> !this.server.isStarted(), (long)1000L);
            this.server.start();
            TextMessage message2 = session1.createTextMessage();
            message2.setText("hello");
            producer.send((Message)message2);
            Message received2 = consumer2.receive(100L);
            JMSMessageConsumerTest.assertNotNull((String)"Should have received a message by now.", (Object)received2);
            JMSMessageConsumerTest.assertTrue((String)"Should be an instance of TextMessage", (boolean)(received2 instanceof TextMessage));
            JMSMessageConsumerTest.assertEquals((long)2L, (long)received2.getJMSDeliveryMode());
        }
        finally {
            connection1.close();
            connection2.close();
        }
    }
}

