/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DeliveryOrderTest
extends ActiveMQTestBase {
    public final SimpleString addressA = new SimpleString("addressA");
    public final SimpleString queueA = new SimpleString("queueA");
    public final SimpleString queueB = new SimpleString("queueB");
    public final SimpleString queueC = new SimpleString("queueC");
    private ServerLocator locator;
    private ActiveMQServer server;
    private ClientSessionFactory cf;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createInVMNonHALocator();
        this.server = this.createServer(false);
        this.server.start();
        this.cf = this.createSessionFactory(this.locator);
    }

    @Test
    public void testSendDeliveryOrderOnCommit() throws Exception {
        ClientSession sendSession = this.cf.createSession(false, false, true);
        ClientProducer cp = sendSession.createProducer(this.addressA);
        int numMessages = 1000;
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage cm = sendSession.createMessage(false);
            cm.getBodyBuffer().writeInt(i);
            cp.send((Message)cm);
            if (i % 10 == 0) {
                sendSession.commit();
            }
            sendSession.commit();
        }
        ClientConsumer c = sendSession.createConsumer(this.queueA);
        sendSession.start();
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage cm = c.receive(5000L);
            Assert.assertNotNull((Object)cm);
            Assert.assertEquals((long)i, (long)cm.getBodyBuffer().readInt());
        }
        sendSession.close();
    }

    @Test
    public void testReceiveDeliveryOrderOnRollback() throws Exception {
        ClientMessage cm;
        int i;
        ClientSession sendSession = this.cf.createSession(false, true, false);
        ClientProducer cp = sendSession.createProducer(this.addressA);
        int numMessages = 1000;
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        for (int i2 = 0; i2 < numMessages; ++i2) {
            ClientMessage cm2 = sendSession.createMessage(false);
            cm2.getBodyBuffer().writeInt(i2);
            cp.send((Message)cm2);
        }
        ClientConsumer c = sendSession.createConsumer(this.queueA);
        sendSession.start();
        for (i = 0; i < numMessages; ++i) {
            cm = c.receive(5000L);
            Assert.assertNotNull((Object)cm);
            cm.acknowledge();
            Assert.assertEquals((long)i, (long)cm.getBodyBuffer().readInt());
        }
        sendSession.rollback();
        for (i = 0; i < numMessages; ++i) {
            cm = c.receive(5000L);
            Assert.assertNotNull((Object)cm);
            cm.acknowledge();
            Assert.assertEquals((long)i, (long)cm.getBodyBuffer().readInt());
        }
        sendSession.close();
    }

    @Test
    public void testMultipleConsumersMessageOrder() throws Exception {
        ClientSession sendSession = this.cf.createSession(false, true, true);
        ClientSession recSession = this.cf.createSession(false, true, true);
        sendSession.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setDurable(Boolean.valueOf(false)));
        int numReceivers = 100;
        AtomicInteger count = new AtomicInteger(0);
        int numMessage = 10000;
        ClientConsumer[] clientConsumers = new ClientConsumer[numReceivers];
        Receiver[] receivers = new Receiver[numReceivers];
        CountDownLatch latch = new CountDownLatch(numMessage);
        for (int i = 0; i < numReceivers; ++i) {
            clientConsumers[i] = recSession.createConsumer(this.queueA);
            receivers[i] = new Receiver(latch);
            clientConsumers[i].setMessageHandler((MessageHandler)receivers[i]);
        }
        recSession.start();
        ClientProducer clientProducer = sendSession.createProducer(this.addressA);
        for (int i = 0; i < numMessage; ++i) {
            ClientMessage cm = sendSession.createMessage(false);
            cm.getBodyBuffer().writeInt(count.getAndIncrement());
            clientProducer.send((Message)cm);
        }
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        for (Receiver receiver : receivers) {
            Assert.assertFalse((String)("" + receiver.lastMessage), (boolean)receiver.failed);
        }
        sendSession.close();
        recSession.close();
    }

    class Receiver
    implements MessageHandler {
        final CountDownLatch latch;
        int lastMessage = -1;
        boolean failed = false;

        Receiver(CountDownLatch latch) {
            this.latch = latch;
        }

        public void onMessage(ClientMessage message) {
            int i = message.getBodyBuffer().readInt();
            try {
                message.acknowledge();
            }
            catch (ActiveMQException e) {
                e.printStackTrace();
            }
            if (i <= this.lastMessage) {
                this.failed = true;
            }
            this.lastMessage = i;
            this.latch.countDown();
        }
    }
}

