/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.io.InputStream;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.client.LargeMessageTest;
import org.apache.activemq.artemis.tests.integration.largemessage.LargeMessageTestBase;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class LargeMessageAvoidLargeMessagesTest
extends LargeMessageTest {
    public LargeMessageAvoidLargeMessagesTest(StoreConfiguration.StoreType storeType) {
        super(storeType);
        this.isCompressedTest = true;
    }

    @Override
    protected void validateLargeMessageComplete(ActiveMQServer server) throws Exception {
    }

    @Override
    protected boolean isNetty() {
        return false;
    }

    protected ServerLocator createFactory(boolean isNetty) throws Exception {
        return super.createFactory(isNetty).setMinLargeMessageSize(10240).setCompressLargeMessage(true);
    }

    @Test
    public void testSimpleSendOnAvoid() throws Exception {
        ActiveMQServer server = this.createServer(true, this.isNetty());
        server.start();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        session.createQueue(new QueueConfiguration(this.ADDRESS));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        int minLargeSize = this.locator.getMinLargeMessageSize();
        LargeMessageTestBase.TestLargeMessageInputStream input = new LargeMessageTestBase.TestLargeMessageInputStream(minLargeSize);
        ClientMessage clientFile = session.createMessage(true);
        clientFile.setBodyInputStream((InputStream)input.clone());
        producer.send((Message)clientFile);
        session.start();
        this.validateNoFilesOnLargeDir();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        ClientMessage msg1 = consumer.receive(1000L);
        Assert.assertNotNull((Object)msg1);
        for (int i = 0; i < input.getSize(); ++i) {
            byte b = msg1.getBodyBuffer().readByte();
            Assert.assertEquals((String)"incorrect char ", (long)input.getChar(i), (long)b);
        }
        msg1.acknowledge();
        consumer.close();
        session.close();
    }

    @Test
    public void testSendRegularAfterCompression() throws Exception {
        ActiveMQServer server = this.createServer(true, this.isNetty());
        server.start();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        session.createQueue(new QueueConfiguration(this.ADDRESS).setAddress(this.ADDRESS).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        int minLargeSize = this.locator.getMinLargeMessageSize();
        LargeMessageTestBase.TestLargeMessageInputStream input = new LargeMessageTestBase.TestLargeMessageInputStream(minLargeSize);
        LargeMessageAvoidLargeMessagesTest.adjustLargeCompression(true, input, 1024);
        int num = 1;
        for (int i = 0; i < num; ++i) {
            ClientMessage clientFile = session.createMessage(true);
            clientFile.setBodyInputStream((InputStream)input.clone());
            producer.send((Message)clientFile);
        }
        session.start();
        this.validateNoFilesOnLargeDir();
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        for (int j = 0; j < num; ++j) {
            ClientMessage msg1 = consumer.receive(1000L);
            Assert.assertNotNull((Object)msg1);
            for (int i = 0; i < input.getSize(); ++i) {
                byte b = msg1.getBodyBuffer().readByte();
                Assert.assertEquals((String)"incorrect char ", (long)input.getChar(i), (long)b);
            }
            msg1.acknowledge();
        }
        session.commit();
        consumer.close();
        session.close();
    }

    @Test
    public void testSendLargeAfterUnableToSendRegular() throws Exception {
        ActiveMQServer server = this.createServer(true, this.isNetty());
        server.start();
        this.locator.setMinLargeMessageSize(5120);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, false, false));
        session.createQueue(new QueueConfiguration(this.ADDRESS).setAddress(this.ADDRESS).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        int minLargeSize = this.locator.getMinLargeMessageSize();
        LargeMessageTestBase.TestLargeMessageInputStream input = new LargeMessageTestBase.TestLargeMessageInputStream(minLargeSize);
        input.setSize(80 * minLargeSize);
        LargeMessageAvoidLargeMessagesTest.adjustLargeCompression(false, input, 40 * minLargeSize);
        int num = 10;
        for (int i = 0; i < num; ++i) {
            ClientMessage clientFile = session.createMessage(true);
            clientFile.setBodyInputStream((InputStream)input.clone());
            producer.send((Message)clientFile);
        }
        session.commit();
        session.start();
        this.validateNoFilesOnLargeDir(server.getConfiguration().getLargeMessagesDirectory(), num);
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        for (int j = 0; j < num; ++j) {
            ClientMessage msg1 = consumer.receive(1000L);
            Assert.assertNotNull((Object)msg1);
            for (int i = 0; i < input.getSize(); ++i) {
                byte b = msg1.getBodyBuffer().readByte();
                Assert.assertEquals((String)"incorrect char", (long)input.getChar(i), (long)b);
            }
            msg1.acknowledge();
        }
        session.commit();
        consumer.close();
        session.close();
    }

    @Test
    public void testMixedCompressionSendReceive() throws Exception {
        ActiveMQServer server = this.createServer(true, this.isNetty());
        server.start();
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(sf.createSession(false, false, false));
        session.createQueue(new QueueConfiguration(this.ADDRESS).setAddress(this.ADDRESS).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        int minLargeSize = this.locator.getMinLargeMessageSize();
        LargeMessageTestBase.TestLargeMessageInputStream regularInput = new LargeMessageTestBase.TestLargeMessageInputStream(minLargeSize);
        LargeMessageAvoidLargeMessagesTest.adjustLargeCompression(true, regularInput, 1024);
        LargeMessageTestBase.TestLargeMessageInputStream largeInput = new LargeMessageTestBase.TestLargeMessageInputStream(minLargeSize);
        largeInput.setSize(100 * minLargeSize);
        LargeMessageAvoidLargeMessagesTest.adjustLargeCompression(false, largeInput, 50 * minLargeSize);
        int num = 6;
        for (int i = 0; i < num; ++i) {
            ClientMessage clientFile = session.createMessage(true);
            if (i % 2 == 0) {
                clientFile.setBodyInputStream((InputStream)regularInput.clone());
            } else {
                clientFile.setBodyInputStream((InputStream)largeInput.clone());
            }
            producer.send((Message)clientFile);
        }
        session.commit();
        session.start();
        this.validateNoFilesOnLargeDir(server.getConfiguration().getLargeMessagesDirectory(), num / 2);
        ClientConsumer consumer = session.createConsumer(this.ADDRESS);
        for (int j = 0; j < num; ++j) {
            byte b;
            int i;
            ClientMessage msg1 = consumer.receive(1000L);
            Assert.assertNotNull((Object)msg1);
            if (j % 2 == 0) {
                for (i = 0; i < regularInput.getSize(); ++i) {
                    b = msg1.getBodyBuffer().readByte();
                    Assert.assertEquals((String)"incorrect char ", (long)regularInput.getChar(i), (long)b);
                }
            } else {
                for (i = 0; i < largeInput.getSize(); ++i) {
                    b = msg1.getBodyBuffer().readByte();
                    Assert.assertEquals((String)"incorrect char ", (long)largeInput.getChar(i), (long)b);
                }
            }
            msg1.acknowledge();
        }
        session.commit();
        consumer.close();
        session.close();
    }

    @Override
    @Test
    public void testDLALargeMessage() throws Exception {
        int i;
        int messageSize = 358400;
        ClientSession session = null;
        ActiveMQServer server = this.createServer(true, this.isNetty());
        server.start();
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(this.locator));
        session = this.addClientSession(sf.createSession(false, false, false));
        session.createQueue(new QueueConfiguration(this.ADDRESS));
        session.createQueue(new QueueConfiguration(this.ADDRESS.concat("-2")).setAddress(this.ADDRESS));
        SimpleString ADDRESS_DLA = this.ADDRESS.concat("-dla");
        AddressSettings addressSettings = new AddressSettings().setDeadLetterAddress(ADDRESS_DLA).setMaxDeliveryAttempts(1);
        server.getAddressSettingsRepository().addMatch("*", (Object)addressSettings);
        session.createQueue(new QueueConfiguration(ADDRESS_DLA));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage clientFile = this.createLargeClientMessageStreaming(session, 358400L, true);
        producer.send((Message)clientFile);
        session.commit();
        session.start();
        ClientConsumer consumer = session.createConsumer(ADDRESS_DLA);
        ClientConsumer consumerRollback = session.createConsumer(this.ADDRESS);
        ClientMessage msg1 = consumerRollback.receive(1000L);
        Assert.assertNotNull((Object)msg1);
        msg1.acknowledge();
        session.rollback();
        consumerRollback.close();
        msg1 = consumer.receive(10000L);
        Assert.assertNotNull((Object)msg1);
        for (i = 0; i < 358400; ++i) {
            Assert.assertEquals((long)ActiveMQTestBase.getSamplebyte((long)i), (long)msg1.getBodyBuffer().readByte());
        }
        session.close();
        server.stop();
        server = this.createServer(true, this.isNetty());
        server.start();
        sf = this.createSessionFactory(this.locator);
        session = sf.createSession(false, false, false);
        session.start();
        consumer = session.createConsumer(ADDRESS_DLA);
        msg1 = consumer.receive(10000L);
        Assert.assertNotNull((Object)msg1);
        for (i = 0; i < 358400; ++i) {
            Assert.assertEquals((long)ActiveMQTestBase.getSamplebyte((long)i), (long)msg1.getBodyBuffer().readByte());
        }
        msg1.acknowledge();
        session.commit();
        this.validateNoFilesOnLargeDir(server.getConfiguration().getLargeMessagesDirectory(), 0);
        consumer = session.createConsumer(this.ADDRESS.concat("-2"));
        msg1 = consumer.receive(10000L);
        Assert.assertNotNull((Object)msg1);
        for (i = 0; i < 358400; ++i) {
            Assert.assertEquals((long)ActiveMQTestBase.getSamplebyte((long)i), (long)msg1.getBodyBuffer().readByte());
        }
        msg1.acknowledge();
        session.commit();
        session.close();
        this.validateNoFilesOnLargeDir();
    }

    @Override
    @Test
    public void testSendServerMessage() throws Exception {
    }
}

