/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReceiveImmediateTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private final SimpleString QUEUE = new SimpleString("ReceiveImmediateTest.queue");
    private final SimpleString ADDRESS = new SimpleString("ReceiveImmediateTest.address");
    private ServerLocator locator;
    private ClientSessionFactory sf;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        Configuration config = this.createDefaultInVMConfig();
        this.server = this.createServer(false, config);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
    }

    @Test
    public void testConsumerReceiveImmediateWithNoMessages() throws Exception {
        this.doConsumerReceiveImmediateWithNoMessages(false);
    }

    @Test
    public void testConsumerReceiveImmediate() throws Exception {
        this.doConsumerReceiveImmediate(false);
    }

    @Test
    public void testBrowserReceiveImmediateWithNoMessages() throws Exception {
        this.doConsumerReceiveImmediateWithNoMessages(true);
    }

    @Test
    public void testBrowserReceiveImmediate() throws Exception {
        this.doConsumerReceiveImmediate(true);
    }

    @Test
    public void testConsumerReceiveImmediateWithSessionStop() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnAcknowledge(true).setAckBatchSize(0);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.QUEUE).setAddress(this.ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientConsumer consumer = session.createConsumer(this.QUEUE, null, false);
        session.start();
        session.stop();
        Assert.assertNull((Object)consumer.receiveImmediate());
        session.start();
        long start = System.currentTimeMillis();
        ClientMessage msg = consumer.receive(2000L);
        long end = System.currentTimeMillis();
        Assert.assertNull((Object)msg);
        Assert.assertTrue((String)("waited only " + (end - start)), (end - start >= 2000L ? 1 : 0) != 0);
        consumer.close();
        session.close();
    }

    @Test
    public void testReceivedImmediateFollowedByReceive() throws Exception {
        this.locator.setBlockOnNonDurableSend(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.QUEUE).setAddress(this.ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage message = session.createMessage(false);
        producer.send((Message)message);
        ClientConsumer consumer = session.createConsumer(this.QUEUE, null, false);
        session.start();
        ClientMessage received = consumer.receiveImmediate();
        ReceiveImmediateTest.assertNotNull((Object)received);
        received.acknowledge();
        received = consumer.receive(1L);
        ReceiveImmediateTest.assertNull((Object)received);
        session.close();
    }

    @Test
    public void testReceivedImmediateFollowedByAsyncConsume() throws Exception {
        this.locator.setBlockOnNonDurableSend(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.QUEUE).setAddress(this.ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        ClientMessage message = session.createMessage(false);
        producer.send((Message)message);
        ClientConsumer consumer = session.createConsumer(this.QUEUE, null, false);
        session.start();
        ClientMessage received = consumer.receiveImmediate();
        ReceiveImmediateTest.assertNotNull((Object)received);
        received.acknowledge();
        final AtomicBoolean receivedAsync = new AtomicBoolean(false);
        consumer.setMessageHandler(new MessageHandler(){

            public void onMessage(ClientMessage message) {
                receivedAsync.set(true);
            }
        });
        Thread.sleep(1000L);
        ReceiveImmediateTest.assertFalse((boolean)receivedAsync.get());
        session.close();
    }

    private void doConsumerReceiveImmediateWithNoMessages(boolean browser) throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnAcknowledge(true).setAckBatchSize(0);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, true, false);
        session.createQueue(new QueueConfiguration(this.QUEUE).setAddress(this.ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientConsumer consumer = session.createConsumer(this.QUEUE, null, browser);
        session.start();
        ClientMessage message = consumer.receiveImmediate();
        Assert.assertNull((Object)message);
        session.close();
    }

    private void doConsumerReceiveImmediate(boolean browser) throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnAcknowledge(true).setAckBatchSize(0);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.QUEUE).setAddress(this.ADDRESS).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.ADDRESS);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE, null, browser);
        session.start();
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = consumer.receiveImmediate();
            Assert.assertNotNull((String)("did not receive message " + i), (Object)message2);
            Assert.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
            if (browser) continue;
            message2.acknowledge();
        }
        Assert.assertEquals((long)0L, (long)((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()).getDeliveringCount());
        Assert.assertNull((Object)consumer.receiveImmediate());
        Assert.assertEquals((long)0L, (long)((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()).getDeliveringCount());
        int messagesOnServer = browser ? 100 : 0;
        Assert.assertEquals((long)messagesOnServer, (long)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()));
        consumer.close();
        session.close();
    }
}

