/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.LastValueQueue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SessionCreateAndDeleteQueueTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private final SimpleString address = new SimpleString("address");
    private final SimpleString queueName = new SimpleString("queue");
    private ServerLocator locator;

    @Test
    public void testDurableFalse() throws Exception {
        ClientSession session = this.createSessionFactory(this.locator).createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.queueName).setAddress(this.address).setDurable(Boolean.valueOf(false)));
        Binding binding = this.server.getPostOffice().getBinding(this.queueName);
        Queue q = (Queue)binding.getBindable();
        Assert.assertFalse((boolean)q.isDurable());
        session.close();
    }

    @Test
    public void testDurableTrue() throws Exception {
        ClientSession session = this.createSessionFactory(this.locator).createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.queueName).setAddress(this.address));
        Binding binding = this.server.getPostOffice().getBinding(this.queueName);
        Queue q = (Queue)binding.getBindable();
        Assert.assertTrue((boolean)q.isDurable());
        session.close();
    }

    @Test
    public void testTemporaryFalse() throws Exception {
        ClientSession session = this.createSessionFactory(this.locator).createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.queueName).setAddress(this.address).setDurable(Boolean.valueOf(false)));
        Binding binding = this.server.getPostOffice().getBinding(this.queueName);
        Queue q = (Queue)binding.getBindable();
        Assert.assertFalse((boolean)q.isTemporary());
        session.close();
    }

    @Test
    public void testTemporaryTrue() throws Exception {
        ClientSession session = this.createSessionFactory(this.locator).createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.queueName).setAddress(this.address).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        Binding binding = this.server.getPostOffice().getBinding(this.queueName);
        Queue q = (Queue)binding.getBindable();
        Assert.assertTrue((boolean)q.isTemporary());
        session.close();
    }

    @Test
    public void testcreateWithFilter() throws Exception {
        ClientSession session = this.createSessionFactory(this.locator).createSession(false, true, true);
        SimpleString filterString = new SimpleString("x=y");
        session.createQueue(new QueueConfiguration(this.queueName).setAddress(this.address).setFilterString(filterString).setDurable(Boolean.valueOf(false)));
        Binding binding = this.server.getPostOffice().getBinding(this.queueName);
        Queue q = (Queue)binding.getBindable();
        Assert.assertEquals((Object)q.getFilter().getFilterString(), (Object)filterString);
        session.close();
    }

    @Test
    public void testAddressSettingUSed() throws Exception {
        this.server.getAddressSettingsRepository().addMatch(this.address.toString(), (Object)new AddressSettings().setDefaultLastValueQueue(true));
        ClientSession session = this.createSessionFactory(this.locator).createSession(false, true, true);
        SimpleString filterString = new SimpleString("x=y");
        session.createQueue(new QueueConfiguration(this.queueName).setAddress(this.address).setFilterString(filterString).setDurable(Boolean.valueOf(false)));
        Binding binding = this.server.getPostOffice().getBinding(this.queueName);
        Assert.assertTrue((boolean)(binding.getBindable() instanceof LastValueQueue));
        session.close();
    }

    @Test
    public void testDeleteQueue() throws Exception {
        ClientSession session = this.createSessionFactory(this.locator).createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.queueName).setAddress(this.address).setDurable(Boolean.valueOf(false)));
        Binding binding = this.server.getPostOffice().getBinding(this.queueName);
        Assert.assertNotNull((Object)binding);
        session.deleteQueue(this.queueName);
        binding = this.server.getPostOffice().getBinding(this.queueName);
        Assert.assertNull((Object)binding);
        session.close();
    }

    @Test
    public void testDeleteQueueNotExist() throws Exception {
        ClientSession session = this.createSessionFactory(this.locator).createSession(false, true, true);
        try {
            session.deleteQueue(this.queueName);
            Assert.fail((String)"should throw exception");
        }
        catch (ActiveMQNonExistentQueueException activeMQNonExistentQueueException) {
        }
        catch (ActiveMQException e) {
            SessionCreateAndDeleteQueueTest.fail((String)("Invalid Exception type:" + e.getType()));
        }
        session.close();
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
    }
}

