/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.bridge;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnector;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.InVMNodeManagerServer;
import org.apache.activemq.artemis.utils.RetryRule;
import org.junit.After;
import org.junit.Rule;

public abstract class BridgeTestBase
extends ActiveMQTestBase {
    @Rule
    public RetryRule retryRule = new RetryRule(2);

    @After
    public void tearDown() throws Exception {
        InVMConnector.failOnCreateConnection = false;
        super.tearDown();
    }

    protected ActiveMQServer createActiveMQServer(int id, boolean netty, Map<String, Object> params) throws Exception {
        return this.createActiveMQServer(id, params, netty, null);
    }

    protected ActiveMQServer createActiveMQServer(int id, Map<String, Object> params, boolean netty, NodeManager nodeManager) throws Exception {
        TransportConfiguration tc = new TransportConfiguration();
        if (netty) {
            params.put("port", 61616 + id);
            tc = new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params);
        } else {
            params.put("serverId", id);
            tc = new TransportConfiguration(INVM_ACCEPTOR_FACTORY, params);
        }
        ConfigurationImpl serviceConf = this.createBasicConfig().setJournalType(BridgeTestBase.getDefaultJournalType()).setBindingsDirectory(this.getBindingsDir(id, false)).setJournalMinFiles(2).setJournalDirectory(this.getJournalDir(id, false)).setPagingDirectory(this.getPageDir(id, false)).setLargeMessagesDirectory(this.getLargeMessagesDir(id, false)).setJournalFileSize(102400).addAcceptorConfiguration(tc).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreMasterPolicyConfiguration());
        Object server = nodeManager == null ? ActiveMQServers.newActiveMQServer((Configuration)serviceConf, (boolean)true) : new InVMNodeManagerServer((Configuration)serviceConf, nodeManager);
        return this.addServer((ActiveMQServer)server);
    }

    protected ActiveMQServer createBackupActiveMQServer(int id, Map<String, Object> params, boolean netty, int liveId, NodeManager nodeManager) throws Exception {
        TransportConfiguration tc = new TransportConfiguration();
        if (netty) {
            params.put("port", 61616 + id);
            tc = new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params);
        } else {
            params.put("serverId", id);
            tc = new TransportConfiguration(INVM_ACCEPTOR_FACTORY, params);
        }
        ConfigurationImpl serviceConf = this.createBasicConfig().setJournalType(BridgeTestBase.getDefaultJournalType()).setBindingsDirectory(this.getBindingsDir(liveId, false)).setJournalMinFiles(2).setJournalDirectory(this.getJournalDir(liveId, false)).setPagingDirectory(this.getPageDir(liveId, false)).setLargeMessagesDirectory(this.getLargeMessagesDir(liveId, false)).setJournalFileSize(102400).addAcceptorConfiguration(tc).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreSlavePolicyConfiguration());
        Object server = nodeManager == null ? ActiveMQServers.newActiveMQServer((Configuration)serviceConf, (boolean)true) : new InVMNodeManagerServer((Configuration)serviceConf, nodeManager);
        return this.addServer((ActiveMQServer)server);
    }

    protected void waitForServerStart(ActiveMQServer server) throws Exception {
        if (!server.waitForActivation(5000L, TimeUnit.MILLISECONDS)) {
            throw new IllegalStateException("Timed out waiting for server starting = " + server);
        }
    }
}

