/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.FailoverEventListener;
import org.apache.activemq.artemis.api.core.client.FailoverEventType;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.persistence.impl.journal.DescribeJournal;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.files.FileMoveManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.util.BackupSyncDelay;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.UUID;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BackupSyncJournalTest
extends FailoverTestBase {
    private static final Logger logger = Logger.getLogger(BackupSyncJournalTest.class);
    protected static final int BACKUP_WAIT_TIME = 60;
    private ServerLocatorInternal locator;
    protected ClientSessionFactoryInternal sessionFactory;
    protected ClientSession session;
    protected ClientProducer producer;
    private BackupSyncDelay syncDelay;
    private final int defaultNMsgs = 20;
    private int n_msgs = 20;
    protected final FailoverWaiter failoverWaiter = new FailoverWaiter();

    protected void setNumberOfMessages(int nmsg) {
        this.n_msgs = nmsg;
    }

    protected int getNumberOfMessages() {
        return this.n_msgs;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.startBackupServer = false;
        super.setUp();
        this.setNumberOfMessages(20);
        this.locator = (ServerLocatorInternal)this.getServerLocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(15).setRetryInterval(200L);
        this.sessionFactory = this.createSessionFactoryAndWaitForTopology((ServerLocator)this.locator, 1);
        this.sessionFactory.addFailoverListener((FailoverEventListener)this.failoverWaiter);
        this.syncDelay = new BackupSyncDelay(this.backupServer, this.liveServer);
    }

    @Test
    public void testNodeID() throws Exception {
        this.startBackupFinishSyncing();
        BackupSyncJournalTest.assertTrue((String)"must be running", (boolean)this.backupServer.isStarted());
        BackupSyncJournalTest.assertEquals((String)"backup and live should have the same nodeID", (Object)this.liveServer.getServer().getNodeID(), (Object)this.backupServer.getServer().getNodeID());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReserveFileIdValuesOnBackup() throws Exception {
        void var12_17;
        int totalRounds = 5;
        this.createProducerSendSomeMessages();
        JournalImpl messageJournal = BackupSyncJournalTest.getMessageJournalFromServer(this.liveServer);
        for (int i = 0; i < 5; ++i) {
            messageJournal.forceMoveNextFile();
            this.sendMessages(this.session, this.producer, this.n_msgs);
        }
        Queue queue = this.liveServer.getServer().locateQueue(ADDRESS);
        PagingStore store = queue.getPageSubscription().getPagingStore();
        if (store.isPaging()) {
            store.forceAnotherPage();
        }
        this.backupServer.start();
        BackupSyncJournalTest.waitForRemoteBackup((ClientSessionFactory)this.sessionFactory, (int)60, (boolean)false, (ActiveMQServer)this.backupServer.getServer());
        JournalImpl backupMsgJournal = BackupSyncJournalTest.getMessageJournalFromServer(this.backupServer);
        this.sendMessages(this.session, this.producer, this.n_msgs);
        if (store.isPaging()) {
            store.forceAnotherPage();
        }
        this.syncDelay.deliverUpToDateMsg();
        BackupSyncJournalTest.waitForRemoteBackup((ClientSessionFactory)this.sessionFactory, (int)60, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
        this.sendMessages(this.session, this.producer, this.n_msgs);
        if (store.isPaging()) {
            store.forceAnotherPage();
        }
        Set<Pair<Long, Integer>> liveIds = this.getFileIds(messageJournal);
        int size = messageJournal.getFileSize();
        PagingStore ps = this.liveServer.getServer().getPagingManager().getPageStore(ADDRESS);
        if (ps.getPageSizeBytes() == 1024) {
            BackupSyncJournalTest.assertTrue((String)"isStarted", (boolean)ps.isStarted());
            BackupSyncJournalTest.assertFalse((String)"start paging should return false, because we expect paging to be running", (boolean)ps.startPaging());
        }
        this.finishSyncAndFailover();
        BackupSyncJournalTest.assertEquals((String)"file sizes must be the same", (long)size, (long)backupMsgJournal.getFileSize());
        Set<Pair<Long, Integer>> backupIds = this.getFileIds(backupMsgJournal);
        int total = 0;
        for (Pair<Long, Integer> pair : liveIds) {
            total += ((Integer)pair.getB()).intValue();
        }
        int totalBackup = 0;
        for (Pair<Long, Integer> pair : backupIds) {
            totalBackup += ((Integer)pair.getB()).intValue();
        }
        BackupSyncJournalTest.assertEquals((String)"number of records must match ", (long)total, (long)totalBackup);
        boolean bl = false;
        while (var12_17 < 8) {
            this.receiveMsgsInRange(0, this.n_msgs);
            ++var12_17;
        }
        this.assertNoMoreMessages();
    }

    protected void assertNoMoreMessages() throws ActiveMQException {
        this.session.start();
        ClientConsumer consumer = this.session.createConsumer(ADDRESS);
        ClientMessage msg = consumer.receiveImmediate();
        BackupSyncJournalTest.assertNull((String)("there should be no more messages to receive! " + msg), (Object)msg);
        consumer.close();
        this.session.commit();
    }

    protected void startBackupFinishSyncing() throws Exception {
        this.syncDelay.deliverUpToDateMsg();
        this.backupServer.start();
        BackupSyncJournalTest.waitForRemoteBackup((ClientSessionFactory)this.sessionFactory, (int)60, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
    }

    @Test
    public void testReplicationDuringSync() throws Exception {
        try {
            this.createProducerSendSomeMessages();
            this.backupServer.start();
            BackupSyncJournalTest.waitForRemoteBackup((ClientSessionFactory)this.sessionFactory, (int)60, (boolean)false, (ActiveMQServer)this.backupServer.getServer());
            this.sendMessages(this.session, this.producer, this.n_msgs);
            this.session.commit();
            this.receiveMsgsInRange(0, this.n_msgs);
            this.finishSyncAndFailover();
            this.receiveMsgsInRange(0, this.n_msgs);
            this.assertNoMoreMessages();
        }
        catch (AssertionError error) {
            this.printJournal(this.liveServer);
            this.printJournal(this.backupServer);
            throw error;
        }
    }

    void printJournal(TestableServer server) {
        try {
            System.out.println("\n\n BINDINGS JOURNAL\n\n");
            Configuration config = server.getServer().getConfiguration();
            DescribeJournal.describeBindingsJournal((File)config.getBindingsLocation());
            System.out.println("\n\n MESSAGES JOURNAL\n\n");
            DescribeJournal.describeMessagesJournal((File)config.getJournalLocation());
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
    }

    protected void finishSyncAndFailover() throws Exception {
        this.syncDelay.deliverUpToDateMsg();
        BackupSyncJournalTest.waitForRemoteBackup((ClientSessionFactory)this.sessionFactory, (int)60, (boolean)true, (ActiveMQServer)this.backupServer.getServer());
        BackupSyncJournalTest.assertFalse((String)"should not be initialized", (boolean)this.backupServer.getServer().isActive());
        this.crash(this.session);
        BackupSyncJournalTest.assertTrue((String)"backup initialized", (boolean)this.backupServer.getServer().waitForActivation(5L, TimeUnit.SECONDS));
        this.assertNodeIdWasSaved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertNodeIdWasSaved() throws Exception {
        BackupSyncJournalTest.assertTrue((String)"backup initialized", (boolean)this.backupServer.getServer().waitForActivation(5L, TimeUnit.SECONDS));
        String journalDirectory = this.backupConfig.getJournalDirectory();
        File serverLockFile = new File(journalDirectory, "server.lock");
        BackupSyncJournalTest.assertTrue((String)("server.lock must exist!\n " + serverLockFile), (boolean)serverLockFile.exists());
        try (RandomAccessFile raFile = new RandomAccessFile(serverLockFile, "r");){
            FileChannel channel = raFile.getChannel();
            int size = 16;
            ByteBuffer id = ByteBuffer.allocateDirect(16);
            int read = channel.read(id, 3L);
            BackupSyncJournalTest.assertEquals((String)"tried to read 16 bytes", (long)16L, (long)read);
            byte[] bytes = new byte[16];
            id.position(0);
            id.get(bytes);
            UUID uuid = new UUID(1, bytes);
            SimpleString storedNodeId = new SimpleString(uuid.toString());
            BackupSyncJournalTest.assertEquals((String)"nodeId must match", (Object)this.backupServer.getServer().getNodeID(), (Object)storedNodeId);
        }
    }

    @Test
    public void testMessageSyncSimple() throws Exception {
        this.createProducerSendSomeMessages();
        this.startBackupCrashLive();
        this.receiveMsgsInRange(0, this.n_msgs);
        this.assertNoMoreMessages();
    }

    @Test
    public void testFailBack() throws Exception {
        this.createProducerSendSomeMessages();
        this.startBackupCrashLive();
        this.receiveMsgsInRange(0, this.n_msgs);
        this.assertNoMoreMessages();
        this.sendMessages(this.session, this.producer, this.n_msgs);
        this.receiveMsgsInRange(0, this.n_msgs);
        this.assertNoMoreMessages();
        this.sendMessages(this.session, this.producer, 2 * this.n_msgs);
        BackupSyncJournalTest.assertFalse((String)"must NOT be a backup", (boolean)this.liveServer.getServer().getHAPolicy().isBackup());
        this.adaptLiveConfigForReplicatedFailBack(this.liveServer);
        FileMoveManager liveMoveManager = new FileMoveManager(this.liveServer.getServer().getConfiguration().getJournalLocation(), -1, new String[0]);
        this.liveServer.getServer().lockActivation();
        try {
            this.liveServer.start();
            BackupSyncJournalTest.assertTrue((String)"must have become a backup", (boolean)this.liveServer.getServer().getHAPolicy().isBackup());
            Assert.assertEquals((long)0L, (long)liveMoveManager.getNumberOfFolders());
        }
        finally {
            this.liveServer.getServer().unlockActivation();
        }
        this.waitForServerToStart(this.liveServer.getServer());
        this.liveServer.getServer().waitForActivation(10L, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)liveMoveManager.getNumberOfFolders());
        BackupSyncJournalTest.assertTrue((String)"must be active now", (!this.liveServer.getServer().getHAPolicy().isBackup() ? (byte)1 : 0) != 0);
        BackupSyncJournalTest.assertTrue((String)"Fail-back must initialize live!", (boolean)this.liveServer.getServer().waitForActivation(15L, TimeUnit.SECONDS));
        BackupSyncJournalTest.assertFalse((String)"must be LIVE!", (boolean)this.liveServer.getServer().getHAPolicy().isBackup());
        int i = 0;
        while (!this.backupServer.isStarted() && i++ < 100) {
            Thread.sleep(100L);
        }
        BackupSyncJournalTest.assertTrue((boolean)this.backupServer.getServer().isStarted());
        BackupSyncJournalTest.assertTrue((boolean)this.liveServer.getServer().isStarted());
        this.receiveMsgsInRange(0, 2 * this.n_msgs);
        this.assertNoMoreMessages();
    }

    @Test
    public void testMessageSync() throws Exception {
        this.createProducerSendSomeMessages();
        this.receiveMsgsInRange(0, this.n_msgs / 2);
        this.startBackupCrashLive();
        this.receiveMsgsInRange(this.n_msgs / 2, this.n_msgs);
        this.assertNoMoreMessages();
    }

    @Test
    public void testRemoveAllMessageWithPurgeOnNoConsumers() throws Exception {
        boolean purgeOnNoConsumers = true;
        this.createProducerSendSomeMessages();
        this.liveServer.getServer().locateQueue(ADDRESS).setPurgeOnNoConsumers(true);
        BackupSyncJournalTest.assertEquals((long)this.n_msgs, (long)((QueueControl)this.liveServer.getServer().getManagementService().getResource("queue." + ADDRESS.toString())).removeAllMessages());
        this.startBackupCrashLive();
        this.assertNoMoreMessages();
    }

    @Test
    public void testReceiveAllMessagesWithPurgeOnNoConsumers() throws Exception {
        boolean purgeOnNoConsumers = true;
        this.createProducerSendSomeMessages();
        this.liveServer.getServer().locateQueue(ADDRESS).setPurgeOnNoConsumers(true);
        this.receiveMsgsInRange(0, this.n_msgs);
        this.startBackupCrashLive();
        this.assertNoMoreMessages();
    }

    private void startBackupCrashLive() throws Exception {
        BackupSyncJournalTest.assertFalse((String)"backup is started?", (boolean)this.backupServer.isStarted());
        this.liveServer.removeInterceptor(this.syncDelay);
        this.backupServer.start();
        this.waitForBackup(this.sessionFactory, 60);
        this.failoverWaiter.reset();
        this.crash(this.session);
        this.backupServer.getServer().waitForActivation(5L, TimeUnit.SECONDS);
        BackupSyncJournalTest.assertTrue((String)"Session didn't failover, the maxRetryAttempts and retryInterval may be too small", (boolean)this.failoverWaiter.waitFailoverComplete());
    }

    protected void createProducerSendSomeMessages() throws ActiveMQException {
        this.session = this.addClientSession(this.sessionFactory.createSession(true, true));
        this.session.createQueue(new QueueConfiguration(ADDRESS));
        if (this.producer != null) {
            this.producer.close();
        }
        this.producer = this.addClientProducer(this.session.createProducer(ADDRESS));
        this.sendMessages(this.session, this.producer, this.n_msgs);
        this.session.commit();
    }

    protected void receiveMsgsInRange(int start, int end) throws ActiveMQException {
        this.session.start();
        ClientConsumer consumer = this.addClientConsumer(this.session.createConsumer(ADDRESS));
        this.receiveMessages(consumer, start, end, true);
        consumer.close();
        this.session.commit();
    }

    private Set<Pair<Long, Integer>> getFileIds(JournalImpl journal) {
        HashSet<Pair<Long, Integer>> results = new HashSet<Pair<Long, Integer>>();
        for (JournalFile jf : journal.getDataFiles()) {
            results.add(this.getPair(jf));
        }
        results.add(this.getPair(journal.getCurrentFile()));
        return results;
    }

    private Pair<Long, Integer> getPair(JournalFile jf) {
        return new Pair((Object)jf.getFileID(), (Object)jf.getPosCount());
    }

    static JournalImpl getMessageJournalFromServer(TestableServer server) {
        JournalStorageManager sm = (JournalStorageManager)server.getServer().getStorageManager();
        return (JournalImpl)sm.getMessageJournal();
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createReplicatedConfigs();
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }

    private class FailoverWaiter
    implements FailoverEventListener {
        private final ReusableLatch latch = new ReusableLatch(1);

        FailoverWaiter() {
        }

        public void reset() {
            this.latch.setCount(0);
        }

        public void failoverEvent(FailoverEventType eventType) {
            if (eventType == FailoverEventType.FAILOVER_COMPLETED) {
                this.latch.countDown();
            }
        }

        public boolean waitFailoverComplete() throws InterruptedException {
            return this.latch.await(10L, TimeUnit.SECONDS);
        }
    }
}

