/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.federation;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.FederationConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationAddressPolicyConfiguration;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.integration.federation.FederatedQueueTest;
import org.apache.activemq.artemis.tests.integration.federation.FederatedTestBase;
import org.apache.activemq.artemis.tests.integration.federation.FederatedTestUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RetryRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class FederatedAddressTest
extends FederatedTestBase {
    @Rule
    public RetryRule retryRule = new RetryRule(2);

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    protected ConnectionFactory getCF(int i) throws Exception {
        return new ActiveMQConnectionFactory("vm://" + i);
    }

    @Test
    public void testDownstreamFederatedAddressReplication() throws Exception {
        String address = this.getName();
        FederationConfiguration federationConfiguration = FederatedTestUtil.createAddressDownstreamFederationConfiguration("server1", address, this.getServer(0).getConfiguration().getTransportConfigurations(new String[]{"server0"})[0]);
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration);
        this.getServer(0).getFederationManager().deploy();
        FederationConfiguration federationConfiguration2 = FederatedTestUtil.createAddressDownstreamFederationConfiguration("server0", address, this.getServer(1).getConfiguration().getTransportConfigurations(new String[]{"server1"})[0]);
        this.getServer(1).getConfiguration().getFederationConfigurations().add(federationConfiguration2);
        this.getServer(1).getFederationManager().deploy();
        this.testFederatedAddressReplication(address);
    }

    @Test
    public void testDownstreamFederatedAddressReplicationRef() throws Exception {
        String address = this.getName();
        FederationConfiguration federationConfiguration = FederatedTestUtil.createAddressDownstreamFederationConfiguration("server1", address, "server0");
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration);
        this.getServer(0).getFederationManager().deploy();
        FederationConfiguration federationConfiguration2 = FederatedTestUtil.createAddressDownstreamFederationConfiguration("server0", address, "server1");
        this.getServer(1).getConfiguration().getFederationConfigurations().add(federationConfiguration2);
        this.getServer(1).getFederationManager().deploy();
        this.testFederatedAddressReplication(address);
    }

    @Test
    public void testDownstreamFederatedAddressReplicationRefOneWay() throws Exception {
        String address = this.getName();
        FederationConfiguration federationConfiguration2 = FederatedTestUtil.createAddressDownstreamFederationConfiguration("server0", address, "server1");
        this.getServer(1).getConfiguration().getFederationConfigurations().add(federationConfiguration2);
        this.getServer(1).getFederationManager().deploy();
        this.testFederatedAddressReplication(address);
    }

    @Test
    public void testUpstreamFederatedAddressReplication() throws Exception {
        String address = this.getName();
        FederationConfiguration federationConfiguration = FederatedTestUtil.createAddressUpstreamFederationConfiguration("server1", address);
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration);
        this.getServer(0).getFederationManager().deploy();
        FederationConfiguration federationConfiguration2 = FederatedTestUtil.createAddressUpstreamFederationConfiguration("server0", address);
        this.getServer(1).getConfiguration().getFederationConfigurations().add(federationConfiguration2);
        this.getServer(1).getFederationManager().deploy();
        this.testFederatedAddressReplication(address);
    }

    @Test
    public void testDownstreamFederatedAddressReplicationRefOneWayTransformer() throws Exception {
        String address = this.getName();
        FederationConfiguration federationConfiguration2 = FederatedTestUtil.createAddressDownstreamFederationConfiguration("server0", address, "server1");
        FederatedTestUtil.addAddressTransformerConfiguration(federationConfiguration2, address);
        this.getServer(1).getConfiguration().getFederationConfigurations().add(federationConfiguration2);
        this.getServer(1).getFederationManager().deploy();
        this.verifyTransformer(address);
    }

    private void verifyTransformer(String address) throws Exception {
        ConnectionFactory cf1 = this.getCF(1);
        ConnectionFactory cf0 = this.getCF(0);
        try (Connection connection1 = cf1.createConnection();
             Connection connection0 = cf0.createConnection();){
            connection1.start();
            connection0.start();
            Session session1 = connection1.createSession();
            Topic topic1 = session1.createTopic(address);
            MessageProducer producer1 = session1.createProducer((Destination)topic1);
            Session session0 = connection0.createSession();
            Topic topic0 = session0.createTopic(address);
            MessageConsumer consumer0 = session0.createConsumer((Destination)topic0);
            FederatedAddressTest.assertTrue((boolean)Wait.waitFor(() -> this.getServer(1).getPostOffice().getBindingsForAddress(SimpleString.toSimpleString((String)address)).getBindings().size() == 1));
            producer1.send((Message)session1.createTextMessage("hello"));
            Message message = consumer0.receive(1000L);
            FederatedAddressTest.assertNotNull((Object)message);
            FederatedAddressTest.assertEquals((Object)message.getBooleanProperty(FederatedQueueTest.TestTransformer.TEST_PROPERTY), (Object)true);
        }
    }

    @Test
    public void testUpstreamFederatedAddressReplicationOneWay() throws Exception {
        String address = this.getName();
        FederationConfiguration federationConfiguration = FederatedTestUtil.createAddressUpstreamFederationConfiguration("server1", address);
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration);
        this.getServer(0).getFederationManager().deploy();
        this.testFederatedAddressReplication(address);
    }

    @Test
    public void testUpstreamFederatedAddressReplicationOneWayTransformer() throws Exception {
        String address = this.getName();
        FederationConfiguration federationConfiguration = FederatedTestUtil.createAddressUpstreamFederationConfiguration("server1", address);
        FederatedTestUtil.addAddressTransformerConfiguration(federationConfiguration, address);
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration);
        this.getServer(0).getFederationManager().deploy();
        this.verifyTransformer(address);
    }

    @Test
    public void testDownstreamDivertAddressFirstAndDivertFirstDestroyDivert() throws Exception {
        this.testFederatedAddressDivert(true, true, true, true);
    }

    @Test
    public void testDownstreamDivertAddressFirstAndDivertFirstDestroyQueue() throws Exception {
        this.testFederatedAddressDivert(true, true, true, false);
    }

    @Test
    public void testDownstreamDivertAddressSecondDivertFirstDestroyDivert() throws Exception {
        this.testFederatedAddressDivert(true, false, true, true);
    }

    @Test
    public void testDownstreamDivertAddressSecondDivertFirstDestroyQueue() throws Exception {
        this.testFederatedAddressDivert(true, false, true, false);
    }

    @Test
    public void testDownstreamDivertAddressFirstDivertSecondDestroyDivert() throws Exception {
        this.testFederatedAddressDivert(true, true, false, true);
    }

    @Test
    public void testDownstreamDivertAddressFirstDivertSecondDestroyQueue() throws Exception {
        this.testFederatedAddressDivert(true, true, false, false);
    }

    @Test
    public void testDownstreamDivertAddressAndDivertSecondDestroyDivert() throws Exception {
        this.testFederatedAddressDivert(true, false, false, true);
    }

    @Test
    public void testDownstreamDivertAddressAndDivertSecondDestroyQueue() throws Exception {
        this.testFederatedAddressDivert(true, false, false, false);
    }

    @Test
    public void testUpstreamDivertAddressAndDivertFirstDestroyDivert() throws Exception {
        this.testFederatedAddressDivert(false, true, true, true);
    }

    @Test
    public void testUpstreamDivertAddressAndDivertFirstDestroyQueue() throws Exception {
        this.testFederatedAddressDivert(false, true, true, false);
    }

    @Test
    public void testUpstreamDivertAddressSecondDivertFirstDestroyDivert() throws Exception {
        this.testFederatedAddressDivert(false, false, true, true);
    }

    @Test
    public void testUpstreamDivertAddressSecondDivertFirstDestroyQueue() throws Exception {
        this.testFederatedAddressDivert(false, false, true, false);
    }

    @Test
    public void testUpstreamDivertAddressFirstDivertSecondDestroyDivert() throws Exception {
        this.testFederatedAddressDivert(false, true, false, true);
    }

    @Test
    public void testUpstreamDivertAddressFirstDivertSecondDestroyQueue() throws Exception {
        this.testFederatedAddressDivert(false, true, false, false);
    }

    @Test
    public void testUpstreamsDivertAddressAndDivertSecondDestroyDivert() throws Exception {
        this.testFederatedAddressDivert(false, false, false, true);
    }

    @Test
    public void testUpstreamDivertAddressAndDivertSecondDestroyQueue() throws Exception {
        this.testFederatedAddressDivert(false, false, false, false);
    }

    protected void testFederatedAddressDivert(boolean downstream, boolean addressFirst, boolean divertBeforeConsumer, boolean destroyDivert) throws Exception {
        int deployServer;
        FederationConfiguration federationConfiguration;
        String address = this.getName();
        String address2 = "fedOneWayDivertTest";
        if (addressFirst) {
            this.getServer(0).addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)address), RoutingType.MULTICAST));
        }
        if (downstream) {
            federationConfiguration = FederatedTestUtil.createAddressDownstreamFederationConfiguration("server0", address, this.getServer(1).getConfiguration().getTransportConfigurations(new String[]{"server1"})[0]);
            deployServer = 1;
        } else {
            federationConfiguration = FederatedTestUtil.createAddressUpstreamFederationConfiguration("server1", address);
            deployServer = 0;
        }
        FederationAddressPolicyConfiguration policy = (FederationAddressPolicyConfiguration)federationConfiguration.getFederationPolicyMap().get("AddressPolicy" + address);
        policy.setEnableDivertBindings(Boolean.valueOf(true));
        this.getServer(deployServer).getConfiguration().getFederationConfigurations().add(federationConfiguration);
        this.getServer(deployServer).getFederationManager().deploy();
        ConnectionFactory cf1 = this.getCF(1);
        ConnectionFactory cf0 = this.getCF(0);
        try (Connection connection1 = cf1.createConnection();
             Connection connection0 = cf0.createConnection();){
            connection1.start();
            connection0.start();
            Session session1 = connection1.createSession();
            Topic topic1 = session1.createTopic(address);
            MessageProducer producer1 = session1.createProducer((Destination)topic1);
            if (divertBeforeConsumer) {
                this.getServer(0).deployDivert(new DivertConfiguration().setName(address + ":" + address2).setAddress(address).setExclusive(true).setForwardingAddress(address2).setRoutingType(ComponentConfigurationRoutingType.ANYCAST));
            }
            Session session0 = connection0.createSession();
            Queue queue0 = session0.createQueue(address2);
            MessageConsumer consumer0 = session0.createConsumer((Destination)queue0);
            if (!addressFirst) {
                this.getServer(0).addAddressInfo(new AddressInfo(SimpleString.toSimpleString((String)address), RoutingType.MULTICAST));
            }
            if (!divertBeforeConsumer) {
                this.getServer(0).deployDivert(new DivertConfiguration().setName(address + ":" + address2).setAddress(address).setExclusive(true).setForwardingAddress(address2).setRoutingType(ComponentConfigurationRoutingType.ANYCAST));
            }
            FederatedAddressTest.assertTrue((boolean)Wait.waitFor(() -> this.getServer(1).getPostOffice().getBindingsForAddress(SimpleString.toSimpleString((String)address)).getBindings().size() == 1, (long)1000L, (long)100L));
            QueueBinding remoteQueueBinding = (QueueBinding)this.getServer(1).getPostOffice().getBindingsForAddress(SimpleString.toSimpleString((String)address)).getBindings().iterator().next();
            Wait.assertEquals((int)1, () -> remoteQueueBinding.getQueue().getConsumerCount());
            producer1.send((Message)session1.createTextMessage("hello"));
            FederatedAddressTest.assertNotNull((Object)consumer0.receive(1000L));
            if (destroyDivert) {
                this.getServer(0).destroyDivert(SimpleString.toSimpleString((String)(address + ":" + address2)));
            } else {
                this.getServer(0).destroyQueue(SimpleString.toSimpleString((String)address2), null, false);
            }
            FederatedAddressTest.assertTrue((boolean)Wait.waitFor(() -> remoteQueueBinding.getQueue().getConsumerCount() == 0, (long)2000L, (long)100L));
        }
    }

    private void testFederatedAddressReplication(String address) throws Exception {
        ConnectionFactory cf1 = this.getCF(1);
        ConnectionFactory cf0 = this.getCF(0);
        try (Connection connection1 = cf1.createConnection();
             Connection connection0 = cf0.createConnection();){
            connection1.start();
            connection0.start();
            Session session1 = connection1.createSession();
            Topic topic1 = session1.createTopic(address);
            MessageProducer producer = session1.createProducer((Destination)topic1);
            producer.send((Message)session1.createTextMessage("hello"));
            Session session0 = connection0.createSession();
            Topic topic0 = session0.createTopic(address);
            MessageConsumer consumer0 = session0.createConsumer((Destination)topic0);
            FederatedAddressTest.assertTrue((boolean)Wait.waitFor(() -> this.getServer(1).getPostOffice().getBindingsForAddress(SimpleString.toSimpleString((String)address)).getBindings().size() == 1, (long)2000L, (long)100L));
            producer.send((Message)session1.createTextMessage("hello"));
            FederatedAddressTest.assertNotNull((Object)consumer0.receive(1000L));
            producer.send((Message)session1.createTextMessage("hello"));
            FederatedAddressTest.assertNotNull((Object)consumer0.receive(1000L));
            MessageConsumer consumer1 = session1.createConsumer((Destination)topic1);
            producer.send((Message)session1.createTextMessage("hello"));
            FederatedAddressTest.assertNotNull((Object)consumer1.receive(1000L));
            FederatedAddressTest.assertNotNull((Object)consumer0.receive(1000L));
            consumer1.close();
            producer.send((Message)session1.createTextMessage("hello"));
            FederatedAddressTest.assertNotNull((Object)consumer0.receive(1000L));
            producer.send(this.createTextMessage(session1, "groupA"));
            FederatedAddressTest.assertNotNull((Object)consumer0.receive(1000L));
            consumer1 = session1.createConsumer((Destination)topic1);
            producer.send(this.createTextMessage(session1, "groupA"));
            FederatedAddressTest.assertNotNull((Object)consumer1.receive(1000L));
            FederatedAddressTest.assertNotNull((Object)consumer0.receive(1000L));
        }
    }

    @Test
    public void testFederatedAddressDeployAfterQueuesExist() throws Exception {
        String address = this.getName();
        ConnectionFactory cf1 = this.getCF(1);
        ConnectionFactory cf0 = this.getCF(0);
        try (Connection connection1 = cf1.createConnection();
             Connection connection0 = cf0.createConnection();){
            connection1.start();
            connection0.start();
            Session session1 = connection1.createSession();
            Topic topic1 = session1.createTopic(address);
            MessageProducer producer = session1.createProducer((Destination)topic1);
            producer.send((Message)session1.createTextMessage("hello"));
            Session session0 = connection0.createSession();
            Topic topic0 = session0.createTopic(address);
            MessageConsumer consumer0 = session0.createConsumer((Destination)topic0);
            producer.send((Message)session1.createTextMessage("hello"));
            FederatedAddressTest.assertNull((Object)consumer0.receive(100L));
            FederationConfiguration federationConfiguration = FederatedTestUtil.createAddressUpstreamFederationConfiguration("server1", address);
            this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration);
            this.getServer(0).getFederationManager().deploy();
            Wait.waitFor(() -> this.getServer(1).getPostOffice().getBindingsForAddress(SimpleString.toSimpleString((String)address)).getBindings().size() == 1, (long)2000L, (long)100L);
            producer.send((Message)session1.createTextMessage("hello"));
            FederatedAddressTest.assertNotNull((Object)consumer0.receive(1000L));
        }
    }

    @Test
    public void testFederatedAddressRemoteBrokerRestart() throws Exception {
        String address = this.getName();
        FederationConfiguration federationConfiguration = FederatedTestUtil.createAddressUpstreamFederationConfiguration("server1", address);
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration);
        this.getServer(0).getFederationManager().deploy();
        ConnectionFactory cf1 = this.getCF(1);
        ConnectionFactory cf0 = this.getCF(0);
        try (Connection connection1 = cf1.createConnection();
             Connection connection0 = cf0.createConnection();){
            connection1.start();
            connection0.start();
            Session session1 = connection1.createSession();
            Topic topic1 = session1.createTopic(address);
            MessageProducer producer = session1.createProducer((Destination)topic1);
            producer.send((Message)session1.createTextMessage("hello"));
            Session session0 = connection0.createSession();
            Topic topic0 = session0.createTopic(address);
            MessageConsumer consumer0 = session0.createConsumer((Destination)topic0);
            Wait.waitFor(() -> this.getServer(1).getPostOffice().getBindingsForAddress(SimpleString.toSimpleString((String)address)).getBindings().size() == 1);
            producer.send((Message)session1.createTextMessage("hello"));
            FederatedAddressTest.assertNotNull((Object)consumer0.receive(10000L));
            producer.send((Message)session1.createTextMessage("hello"));
            FederatedAddressTest.assertNotNull((Object)consumer0.receive(1000L));
            connection1.close();
            this.getServer(1).stop();
            Wait.waitFor(() -> !this.getServer(1).isStarted());
            FederatedAddressTest.assertNull((Object)consumer0.receive(100L));
            this.getServer(1).start();
            Wait.waitFor(() -> this.getServer(1).isActive());
            Connection c1 = cf1.createConnection();
            c1.start();
            Wait.waitFor(() -> this.getServer(1).isStarted());
            session1 = c1.createSession();
            topic1 = session1.createTopic(address);
            producer = session1.createProducer((Destination)topic1);
            Wait.waitFor(() -> this.getServer(1).getPostOffice().getBindingsForAddress(SimpleString.toSimpleString((String)address)).getBindings().size() == 1);
            producer.send((Message)session1.createTextMessage("hello"));
            FederatedAddressTest.assertNotNull((Object)consumer0.receive(1000L));
        }
    }

    @Test
    public void testFederatedAddressLocalBrokerRestart() throws Exception {
        String address = this.getName();
        FederationConfiguration federationConfiguration = FederatedTestUtil.createAddressUpstreamFederationConfiguration("server1", address);
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration);
        this.getServer(0).getFederationManager().deploy();
        ConnectionFactory cf1 = this.getCF(1);
        ConnectionFactory cf0 = this.getCF(0);
        try (Connection connection1 = cf1.createConnection();
             Connection connection0 = cf0.createConnection();){
            connection1.start();
            connection0.start();
            Session session1 = connection1.createSession();
            Topic topic1 = session1.createTopic(address);
            MessageProducer producer = session1.createProducer((Destination)topic1);
            producer.send((Message)session1.createTextMessage("hello"));
            Session session0 = connection0.createSession();
            Topic topic0 = session0.createTopic(address);
            MessageConsumer consumer0 = session0.createConsumer((Destination)topic0);
            Wait.waitFor(() -> this.getServer(1).getPostOffice().getBindingsForAddress(SimpleString.toSimpleString((String)address)).getBindings().size() == 1);
            producer.send((Message)session1.createTextMessage("hello"));
            FederatedAddressTest.assertNotNull((Object)consumer0.receive(10000L));
            producer.send((Message)session1.createTextMessage("hello"));
            FederatedAddressTest.assertNotNull((Object)consumer0.receive(1000L));
            connection0.close();
            this.getServer(0).stop();
            Wait.waitFor(() -> !this.getServer(0).isStarted());
            producer.send((Message)session1.createTextMessage("hello"));
            this.getServer(0).start();
            Wait.waitFor(() -> this.getServer(0).isActive());
            Connection newConnection = this.getCF(0).createConnection();
            newConnection.start();
            session0 = newConnection.createSession();
            topic0 = session0.createTopic(address);
            consumer0 = session0.createConsumer((Destination)topic0);
            Wait.waitFor(() -> this.getServer(1).getPostOffice().getBindingsForAddress(SimpleString.toSimpleString((String)address)).getBindings().size() == 1);
            producer.send((Message)session1.createTextMessage("hello"));
            FederatedAddressTest.assertNotNull((Object)consumer0.receive(1000L));
            newConnection.close();
        }
    }

    @Test
    public void testFederatedAddressChainOfBrokers() throws Exception {
        String address = this.getName();
        FederationConfiguration federationConfiguration0 = FederatedTestUtil.createAddressUpstreamFederationConfiguration("server1", address, 2);
        this.getServer(0).getConfiguration().getFederationConfigurations().add(federationConfiguration0);
        this.getServer(0).getFederationManager().deploy();
        FederationConfiguration federationConfiguration1 = FederatedTestUtil.createAddressUpstreamFederationConfiguration("server2", address, 2);
        this.getServer(1).getConfiguration().getFederationConfigurations().add(federationConfiguration1);
        this.getServer(1).getFederationManager().deploy();
        ConnectionFactory cf2 = this.getCF(2);
        ConnectionFactory cf0 = this.getCF(0);
        try (Connection connection2 = cf2.createConnection();
             Connection connection0 = cf0.createConnection();){
            connection0.start();
            Session session0 = connection0.createSession();
            Topic topic0 = session0.createTopic(address);
            connection2.start();
            Session session2 = connection2.createSession();
            Topic topic2 = session2.createTopic(address);
            MessageProducer producer2 = session2.createProducer((Destination)topic2);
            MessageConsumer consumer0 = session0.createConsumer((Destination)topic0);
            FederatedAddressTest.assertTrue((boolean)Wait.waitFor(() -> this.getServer(1).getPostOffice().getBindingsForAddress(SimpleString.toSimpleString((String)address)).getBindings().size() == 1));
            FederatedAddressTest.assertTrue((boolean)Wait.waitFor(() -> this.getServer(2).getPostOffice().getBindingsForAddress(SimpleString.toSimpleString((String)address)).getBindings().size() == 1));
            producer2.send((Message)session2.createTextMessage("hello"));
            FederatedAddressTest.assertNotNull((Object)consumer0.receive(1000L));
        }
    }

    private Message createTextMessage(Session session1, String group) throws JMSException {
        TextMessage message = session1.createTextMessage("hello");
        message.setStringProperty("JMSXGroupID", group);
        return message;
    }

    public static class TestTransformer
    implements Transformer {
        static String TEST_PROPERTY = "transformed";

        public org.apache.activemq.artemis.api.core.Message transform(org.apache.activemq.artemis.api.core.Message message) {
            message.putBooleanProperty(TEST_PROPERTY, true);
            return message;
        }
    }
}

