/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.integration.jms.serializables.TestClass1;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ActiveMQConnectionFactoryTest
extends ActiveMQTestBase {
    private final String groupAddress = ActiveMQConnectionFactoryTest.getUDPDiscoveryAddress();
    private final int groupPort = ActiveMQConnectionFactoryTest.getUDPDiscoveryPort();
    private ActiveMQServer liveService;
    private TransportConfiguration liveTC;

    @Test
    public void testDefaultConstructor() throws Exception {
        ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[0]);
        this.assertFactoryParams(cf, null, null, null, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, ActiveMQClient.DEFAULT_CONNECTION_TTL, 30000L, 30000L, 102400, 0x100000, -1, -1, -1, false, true, false, false, false, ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME, 0x100000, 0x100000, 10000L, true, 5, -1, 2000L, ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, 0);
        Connection conn = null;
        try {
            conn = cf.createConnection();
            conn.createSession(false, 1);
            Assert.fail((String)"Should throw exception");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        if (conn != null) {
            conn.close();
        }
        this.testSettersThrowException(cf);
    }

    @Test
    public void testDefaultConstructorAndSetConnectorPairs() throws Exception {
        ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{this.liveTC});
        this.assertFactoryParams(cf, new TransportConfiguration[]{this.liveTC}, null, null, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, ActiveMQClient.DEFAULT_CONNECTION_TTL, 30000L, 30000L, 102400, 0x100000, -1, -1, -1, false, true, false, false, false, ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME, 0x100000, 0x100000, 10000L, true, 5, -1, 2000L, ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, 0);
        Connection conn = cf.createConnection();
        conn.createSession(false, 1);
        this.testSettersThrowException(cf);
        conn.close();
    }

    @Test
    public void testDiscoveryConstructor() throws Exception {
        DiscoveryGroupConfiguration groupConfiguration = new DiscoveryGroupConfiguration().setBroadcastEndpointFactory((BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(this.groupAddress).setGroupPort(this.groupPort));
        ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((DiscoveryGroupConfiguration)groupConfiguration, (JMSFactoryType)JMSFactoryType.CF);
        this.assertFactoryParams(cf, null, groupConfiguration, null, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, ActiveMQClient.DEFAULT_CONNECTION_TTL, 30000L, 30000L, 102400, 0x100000, -1, -1, -1, false, true, false, false, false, ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME, 0x100000, 0x100000, 10000L, true, 5, -1, 2000L, ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, 0);
        Connection conn = cf.createConnection();
        conn.createSession(false, 1);
        this.testSettersThrowException(cf);
        conn.close();
    }

    @Test
    public void testStaticConnectorListConstructor() throws Exception {
        ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{this.liveTC});
        this.assertFactoryParams(cf, new TransportConfiguration[]{this.liveTC}, null, null, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, ActiveMQClient.DEFAULT_CONNECTION_TTL, 30000L, 30000L, 102400, 0x100000, -1, -1, -1, false, true, false, false, false, ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME, 0x100000, 0x100000, 10000L, true, 5, -1, 2000L, ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, 0);
        Connection conn = cf.createConnection();
        conn.createSession(false, 1);
        this.testSettersThrowException(cf);
        conn.close();
    }

    @Test
    public void testStaticConnectorLiveConstructor() throws Exception {
        ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{this.liveTC});
        this.assertFactoryParams(cf, new TransportConfiguration[]{this.liveTC}, null, null, ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, ActiveMQClient.DEFAULT_CONNECTION_TTL, 30000L, 30000L, 102400, 0x100000, -1, -1, -1, false, true, false, false, false, ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME, 0x100000, 0x100000, 10000L, true, 5, -1, 2000L, ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, 0);
        Connection conn = cf.createConnection();
        conn.createSession(false, 1);
        this.testSettersThrowException(cf);
        cf.close();
        conn.close();
    }

    @Test
    public void testGettersAndSetters() {
        ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{this.liveTC});
        long clientFailureCheckPeriod = RandomUtil.randomPositiveLong();
        long connectionTTL = RandomUtil.randomPositiveLong();
        long callTimeout = RandomUtil.randomPositiveLong();
        int minLargeMessageSize = RandomUtil.randomPositiveInt();
        int consumerWindowSize = RandomUtil.randomPositiveInt();
        int consumerMaxRate = RandomUtil.randomPositiveInt();
        int confirmationWindowSize = RandomUtil.randomPositiveInt();
        int producerMaxRate = RandomUtil.randomPositiveInt();
        boolean blockOnAcknowledge = RandomUtil.randomBoolean();
        boolean blockOnDurableSend = RandomUtil.randomBoolean();
        boolean blockOnNonDurableSend = RandomUtil.randomBoolean();
        boolean autoGroup = RandomUtil.randomBoolean();
        boolean preAcknowledge = RandomUtil.randomBoolean();
        String loadBalancingPolicyClassName = RandomUtil.randomString();
        boolean useGlobalPools = RandomUtil.randomBoolean();
        int scheduledThreadPoolMaxSize = RandomUtil.randomPositiveInt();
        int threadPoolMaxSize = RandomUtil.randomPositiveInt();
        long retryInterval = RandomUtil.randomPositiveLong();
        double retryIntervalMultiplier = RandomUtil.randomDouble();
        int reconnectAttempts = RandomUtil.randomPositiveInt();
        cf.setClientFailureCheckPeriod(clientFailureCheckPeriod);
        cf.setConnectionTTL(connectionTTL);
        cf.setCallTimeout(callTimeout);
        cf.setMinLargeMessageSize(minLargeMessageSize);
        cf.setConsumerWindowSize(consumerWindowSize);
        cf.setConsumerMaxRate(consumerMaxRate);
        cf.setConfirmationWindowSize(confirmationWindowSize);
        cf.setProducerMaxRate(producerMaxRate);
        cf.setBlockOnAcknowledge(blockOnAcknowledge);
        cf.setBlockOnDurableSend(blockOnDurableSend);
        cf.setBlockOnNonDurableSend(blockOnNonDurableSend);
        cf.setAutoGroup(autoGroup);
        cf.setPreAcknowledge(preAcknowledge);
        cf.setConnectionLoadBalancingPolicyClassName(loadBalancingPolicyClassName);
        cf.setUseGlobalPools(useGlobalPools);
        cf.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
        cf.setThreadPoolMaxSize(threadPoolMaxSize);
        cf.setRetryInterval(retryInterval);
        cf.setRetryIntervalMultiplier(retryIntervalMultiplier);
        cf.setReconnectAttempts(reconnectAttempts);
        Assert.assertEquals((long)clientFailureCheckPeriod, (long)cf.getClientFailureCheckPeriod());
        Assert.assertEquals((long)connectionTTL, (long)cf.getConnectionTTL());
        Assert.assertEquals((long)callTimeout, (long)cf.getCallTimeout());
        Assert.assertEquals((long)minLargeMessageSize, (long)cf.getMinLargeMessageSize());
        Assert.assertEquals((long)consumerWindowSize, (long)cf.getConsumerWindowSize());
        Assert.assertEquals((long)consumerMaxRate, (long)cf.getConsumerMaxRate());
        Assert.assertEquals((long)confirmationWindowSize, (long)cf.getConfirmationWindowSize());
        Assert.assertEquals((long)producerMaxRate, (long)cf.getProducerMaxRate());
        Assert.assertEquals((Object)blockOnAcknowledge, (Object)cf.isBlockOnAcknowledge());
        Assert.assertEquals((Object)blockOnDurableSend, (Object)cf.isBlockOnDurableSend());
        Assert.assertEquals((Object)blockOnNonDurableSend, (Object)cf.isBlockOnNonDurableSend());
        Assert.assertEquals((Object)autoGroup, (Object)cf.isAutoGroup());
        Assert.assertEquals((Object)preAcknowledge, (Object)cf.isPreAcknowledge());
        Assert.assertEquals((Object)loadBalancingPolicyClassName, (Object)cf.getConnectionLoadBalancingPolicyClassName());
        Assert.assertEquals((Object)useGlobalPools, (Object)cf.isUseGlobalPools());
        Assert.assertEquals((long)scheduledThreadPoolMaxSize, (long)cf.getScheduledThreadPoolMaxSize());
        Assert.assertEquals((long)threadPoolMaxSize, (long)cf.getThreadPoolMaxSize());
        Assert.assertEquals((long)retryInterval, (long)cf.getRetryInterval());
        Assert.assertEquals((double)retryIntervalMultiplier, (double)cf.getRetryIntervalMultiplier(), (double)1.0E-4);
        Assert.assertEquals((long)reconnectAttempts, (long)cf.getReconnectAttempts());
        cf.close();
    }

    @Test
    public void testDeserializationOptions() throws Exception {
        this.testDeserializationOptions(false, false);
    }

    @Test
    public void testDeserializationOptionsJndi() throws Exception {
        this.testDeserializationOptions(true, false);
    }

    @Test
    public void testDeserializationOptionsBrowser() throws Exception {
        this.testDeserializationOptions(false, true);
    }

    @Test
    public void testDeserializationOptionsJndiBrowser() throws Exception {
        this.testDeserializationOptions(true, true);
    }

    private void testDeserializationOptions(boolean useJndi, boolean useBrowser) throws Exception {
        String qname = "SerialTestQueue";
        SimpleString qaddr = new SimpleString(qname);
        this.liveService.createQueue(new QueueConfiguration(qaddr).setRoutingType(RoutingType.ANYCAST));
        String blackList = null;
        String whiteList = null;
        Object obj = this.receiveObjectMessage(blackList, whiteList, qname, new TestClass1(), useJndi, useBrowser);
        ActiveMQConnectionFactoryTest.assertTrue((String)("Object is " + obj), (boolean)(obj instanceof TestClass1));
        blackList = "java.lang";
        whiteList = "some.other.package1";
        obj = this.receiveObjectMessage(blackList, whiteList, qname, new TestClass1(), useJndi, useBrowser);
        ActiveMQConnectionFactoryTest.assertTrue((String)("Object is " + obj), (boolean)(obj instanceof JMSException));
        obj = this.receiveObjectMessage(blackList, whiteList, qname, (Serializable)((Object)new String("hello")), useJndi, useBrowser);
        ActiveMQConnectionFactoryTest.assertTrue((String)"java.lang.String always trusted ", (boolean)"hello".equals(obj));
        blackList = "org.apache.activemq.artemis.tests.integration.jms.serializables";
        whiteList = "org.apache.activemq.artemis.tests.integration.jms.serializables";
        obj = this.receiveObjectMessage(blackList, whiteList, qname, new TestClass1(), useJndi, useBrowser);
        ActiveMQConnectionFactoryTest.assertTrue((String)("Object is " + obj), (boolean)(obj instanceof JMSException));
        blackList = "org.apache.activemq.artemis";
        whiteList = "org.apache.activemq.artemis.tests.integration.jms.serializables";
        obj = this.receiveObjectMessage(blackList, whiteList, qname, new TestClass1(), useJndi, useBrowser);
        ActiveMQConnectionFactoryTest.assertTrue((String)("Object is " + obj), (boolean)(obj instanceof JMSException));
        blackList = "some.other.package";
        whiteList = "org.apache.activemq.artemis.tests.integration.jms.serializables";
        obj = this.receiveObjectMessage(blackList, whiteList, qname, new TestClass1(), useJndi, useBrowser);
        ActiveMQConnectionFactoryTest.assertTrue((String)("Object is " + obj), (boolean)(obj instanceof TestClass1));
        blackList = "some.other.package";
        whiteList = "org.apache.activemq.artemis.tests.integration.jms";
        obj = this.receiveObjectMessage(blackList, whiteList, qname, new TestClass1(), useJndi, useBrowser);
        ActiveMQConnectionFactoryTest.assertTrue((String)("Object is " + obj), (boolean)(obj instanceof TestClass1));
        blackList = "some.other.package";
        whiteList = "org.apache.activemq.artemis.tests.integration.jms.serializables.pkg1";
        obj = this.receiveObjectMessage(blackList, whiteList, qname, new TestClass1(), useJndi, useBrowser);
        ActiveMQConnectionFactoryTest.assertTrue((String)("Object is " + obj), (boolean)(obj instanceof JMSException));
        blackList = "org.apache.activemq.artemis.tests.integration.jms.serializables";
        whiteList = "*";
        obj = this.receiveObjectMessage(blackList, whiteList, qname, new TestClass1(), useJndi, useBrowser);
        ActiveMQConnectionFactoryTest.assertTrue((String)("Object is " + obj), (boolean)(obj instanceof JMSException));
        blackList = "some.other.package";
        whiteList = "*";
        obj = this.receiveObjectMessage(blackList, whiteList, qname, new TestClass1(), useJndi, useBrowser);
        ActiveMQConnectionFactoryTest.assertTrue((String)("Object is " + obj), (boolean)(obj instanceof TestClass1));
        blackList = "*";
        whiteList = "*";
        obj = this.receiveObjectMessage(blackList, whiteList, qname, new TestClass1(), useJndi, useBrowser);
        ActiveMQConnectionFactoryTest.assertTrue((String)("Object is " + obj), (boolean)(obj instanceof JMSException));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSystemPropertyBlackWhiteListDefault() throws Exception {
        System.setProperty("org.apache.activemq.artemis.jms.deserialization.blacklist", "*");
        System.setProperty("org.apache.activemq.artemis.jms.deserialization.whitelist", "some.other.package");
        String qname = "SerialTestQueue";
        SimpleString qaddr = new SimpleString(qname);
        this.liveService.createQueue(new QueueConfiguration(qaddr).setRoutingType(RoutingType.ANYCAST));
        try {
            String blackList = null;
            String whiteList = null;
            Object obj = this.receiveObjectMessage(blackList, whiteList, qname, new TestClass1(), false, false);
            ActiveMQConnectionFactoryTest.assertTrue((String)("Object is " + obj), (boolean)(obj instanceof JMSException));
            obj = this.receiveObjectMessage(blackList, whiteList, qname, (Serializable)((Object)new String("hello")), false, false);
            ActiveMQConnectionFactoryTest.assertTrue((String)("java.lang.String always trusted " + obj), (boolean)"hello".equals(obj));
            blackList = "some.other.package";
            whiteList = "org.apache.activemq.artemis.tests.integration";
            obj = this.receiveObjectMessage(blackList, whiteList, qname, new TestClass1(), false, false);
            ActiveMQConnectionFactoryTest.assertTrue((String)("Object is " + obj), (boolean)(obj instanceof TestClass1));
            obj = this.receiveObjectMessage(blackList, whiteList, qname, (Serializable)((Object)new String("hello")), false, false);
            ActiveMQConnectionFactoryTest.assertTrue((String)("java.lang.String always trusted " + obj), (boolean)"hello".equals(obj));
        }
        finally {
            System.clearProperty("org.apache.activemq.artemis.jms.deserialization.blacklist");
            System.clearProperty("org.apache.activemq.artemis.jms.deserialization.whitelist");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object receiveObjectMessage(String blackList, String whiteList, String qname, Serializable obj, boolean useJndi, boolean useBrowser) throws Exception {
        this.sendObjectMessage(qname, obj);
        StringBuilder query = new StringBuilder("");
        if (blackList != null) {
            query.append("?");
            query.append("deserializationBlackList=");
            query.append(blackList);
            if (whiteList != null) {
                query.append("&");
                query.append("deserializationWhiteList=");
                query.append(whiteList);
            }
        } else if (whiteList != null) {
            query.append("?deserializationWhiteList=");
            query.append(whiteList);
        }
        ActiveMQConnectionFactory factory = null;
        if (useJndi) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
            props.put("connectionFactory.VmConnectionFactory", "vm://0" + query);
            InitialContext ctx = new InitialContext(props);
            factory = (ActiveMQConnectionFactory)ctx.lookup("VmConnectionFactory");
        } else {
            factory = new ActiveMQConnectionFactory("vm://0" + query);
        }
        try (Connection connection = factory.createConnection();){
            ObjectMessage objMessage;
            connection.start();
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(qname);
            Serializable result = null;
            if (useBrowser) {
                QueueBrowser browser = session.createBrowser(queue);
                objMessage = (ObjectMessage)browser.getEnumeration().nextElement();
                MessageConsumer consumer = session.createConsumer((Destination)queue);
                consumer.receive(5000L);
                result = objMessage.getObject();
            } else {
                MessageConsumer consumer = session.createConsumer((Destination)queue);
                objMessage = (ObjectMessage)consumer.receive(5000L);
                ActiveMQConnectionFactoryTest.assertNotNull((Object)objMessage);
                result = objMessage.getObject();
            }
            Serializable serializable = result;
            return serializable;
        }
        catch (Exception e) {
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendObjectMessage(String qname, Serializable obj) throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://0");
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            Queue q = session.createQueue(qname);
            MessageProducer producer = session.createProducer((Destination)q);
            ObjectMessage objMessage = session.createObjectMessage();
            objMessage.setObject(obj);
            producer.send((Message)objMessage);
        }
    }

    private void testSettersThrowException(ActiveMQConnectionFactory cf) {
        String clientID = RandomUtil.randomString();
        long clientFailureCheckPeriod = RandomUtil.randomPositiveLong();
        long connectionTTL = RandomUtil.randomPositiveLong();
        long callTimeout = RandomUtil.randomPositiveLong();
        int minLargeMessageSize = RandomUtil.randomPositiveInt();
        int consumerWindowSize = RandomUtil.randomPositiveInt();
        int consumerMaxRate = RandomUtil.randomPositiveInt();
        int confirmationWindowSize = RandomUtil.randomPositiveInt();
        int producerMaxRate = RandomUtil.randomPositiveInt();
        boolean blockOnAcknowledge = RandomUtil.randomBoolean();
        boolean blockOnDurableSend = RandomUtil.randomBoolean();
        boolean blockOnNonDurableSend = RandomUtil.randomBoolean();
        boolean autoGroup = RandomUtil.randomBoolean();
        boolean preAcknowledge = RandomUtil.randomBoolean();
        String loadBalancingPolicyClassName = RandomUtil.randomString();
        int dupsOKBatchSize = RandomUtil.randomPositiveInt();
        int transactionBatchSize = RandomUtil.randomPositiveInt();
        boolean useGlobalPools = RandomUtil.randomBoolean();
        int scheduledThreadPoolMaxSize = RandomUtil.randomPositiveInt();
        int threadPoolMaxSize = RandomUtil.randomPositiveInt();
        long retryInterval = RandomUtil.randomPositiveLong();
        double retryIntervalMultiplier = RandomUtil.randomDouble();
        int reconnectAttempts = RandomUtil.randomPositiveInt();
        boolean enableSharedClientID = true;
        try {
            cf.setClientID(clientID);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setClientFailureCheckPeriod(clientFailureCheckPeriod);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setConnectionTTL(connectionTTL);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setCallTimeout(callTimeout);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setMinLargeMessageSize(minLargeMessageSize);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setConsumerWindowSize(consumerWindowSize);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setConsumerMaxRate(consumerMaxRate);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setConfirmationWindowSize(confirmationWindowSize);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setProducerMaxRate(producerMaxRate);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setBlockOnAcknowledge(blockOnAcknowledge);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setBlockOnDurableSend(blockOnDurableSend);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setBlockOnNonDurableSend(blockOnNonDurableSend);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setAutoGroup(autoGroup);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setPreAcknowledge(preAcknowledge);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setConnectionLoadBalancingPolicyClassName(loadBalancingPolicyClassName);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setDupsOKBatchSize(dupsOKBatchSize);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setTransactionBatchSize(transactionBatchSize);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setUseGlobalPools(useGlobalPools);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setThreadPoolMaxSize(threadPoolMaxSize);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setRetryInterval(retryInterval);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setRetryIntervalMultiplier(retryIntervalMultiplier);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            cf.setReconnectAttempts(reconnectAttempts);
            Assert.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        cf.getStaticConnectors();
        cf.getClientID();
        cf.getClientFailureCheckPeriod();
        cf.getConnectionTTL();
        cf.getCallTimeout();
        cf.getMinLargeMessageSize();
        cf.getConsumerWindowSize();
        cf.getConsumerMaxRate();
        cf.getConfirmationWindowSize();
        cf.getProducerMaxRate();
        cf.isBlockOnAcknowledge();
        cf.isBlockOnDurableSend();
        cf.isBlockOnNonDurableSend();
        cf.isAutoGroup();
        cf.isPreAcknowledge();
        cf.getConnectionLoadBalancingPolicyClassName();
        cf.getDupsOKBatchSize();
        cf.getTransactionBatchSize();
        cf.isUseGlobalPools();
        cf.getScheduledThreadPoolMaxSize();
        cf.getThreadPoolMaxSize();
        cf.getRetryInterval();
        cf.getRetryIntervalMultiplier();
        cf.getReconnectAttempts();
        cf.close();
    }

    private void assertFactoryParams(ActiveMQConnectionFactory cf, TransportConfiguration[] staticConnectors, DiscoveryGroupConfiguration discoveryGroupConfiguration, String clientID, long clientFailureCheckPeriod, long connectionTTL, long callTimeout, long callFailoverTimeout, int minLargeMessageSize, int consumerWindowSize, int consumerMaxRate, int confirmationWindowSize, int producerMaxRate, boolean blockOnAcknowledge, boolean blockOnDurableSend, boolean blockOnNonDurableSend, boolean autoGroup, boolean preAcknowledge, String loadBalancingPolicyClassName, int dupsOKBatchSize, int transactionBatchSize, long initialWaitTimeout, boolean useGlobalPools, int scheduledThreadPoolMaxSize, int threadPoolMaxSize, long retryInterval, double retryIntervalMultiplier, int reconnectAttempts) {
        TransportConfiguration[] cfStaticConnectors = cf.getStaticConnectors();
        if (staticConnectors == null) {
            Assert.assertNull((Object)staticConnectors);
        } else {
            Assert.assertEquals((long)staticConnectors.length, (long)cfStaticConnectors.length);
            for (int i = 0; i < staticConnectors.length; ++i) {
                Assert.assertEquals((Object)staticConnectors[i], (Object)cfStaticConnectors[i]);
            }
        }
        Assert.assertEquals((Object)cf.getClientID(), (Object)clientID);
        Assert.assertEquals((long)cf.getClientFailureCheckPeriod(), (long)clientFailureCheckPeriod);
        Assert.assertEquals((long)cf.getConnectionTTL(), (long)connectionTTL);
        Assert.assertEquals((long)cf.getCallTimeout(), (long)callTimeout);
        Assert.assertEquals((long)cf.getCallFailoverTimeout(), (long)callFailoverTimeout);
        Assert.assertEquals((long)cf.getMinLargeMessageSize(), (long)minLargeMessageSize);
        Assert.assertEquals((long)cf.getConsumerWindowSize(), (long)consumerWindowSize);
        Assert.assertEquals((long)cf.getConsumerMaxRate(), (long)consumerMaxRate);
        Assert.assertEquals((long)cf.getConfirmationWindowSize(), (long)confirmationWindowSize);
        Assert.assertEquals((long)cf.getProducerMaxRate(), (long)producerMaxRate);
        Assert.assertEquals((Object)cf.isBlockOnAcknowledge(), (Object)blockOnAcknowledge);
        Assert.assertEquals((Object)cf.isBlockOnDurableSend(), (Object)blockOnDurableSend);
        Assert.assertEquals((Object)cf.isBlockOnNonDurableSend(), (Object)blockOnNonDurableSend);
        Assert.assertEquals((Object)cf.isAutoGroup(), (Object)autoGroup);
        Assert.assertEquals((Object)cf.isPreAcknowledge(), (Object)preAcknowledge);
        Assert.assertEquals((Object)cf.getConnectionLoadBalancingPolicyClassName(), (Object)loadBalancingPolicyClassName);
        Assert.assertEquals((long)cf.getDupsOKBatchSize(), (long)dupsOKBatchSize);
        Assert.assertEquals((long)cf.getTransactionBatchSize(), (long)transactionBatchSize);
        Assert.assertEquals((Object)cf.isUseGlobalPools(), (Object)useGlobalPools);
        Assert.assertEquals((long)cf.getScheduledThreadPoolMaxSize(), (long)scheduledThreadPoolMaxSize);
        Assert.assertEquals((long)cf.getThreadPoolMaxSize(), (long)threadPoolMaxSize);
        Assert.assertEquals((long)cf.getRetryInterval(), (long)retryInterval);
        Assert.assertEquals((double)cf.getRetryIntervalMultiplier(), (double)retryIntervalMultiplier, (double)1.0E-5);
        Assert.assertEquals((long)cf.getReconnectAttempts(), (long)reconnectAttempts);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.startServer();
    }

    private void startServer() throws Exception {
        this.liveTC = new TransportConfiguration(INVM_CONNECTOR_FACTORY);
        HashMap<String, TransportConfiguration> connectors = new HashMap<String, TransportConfiguration>();
        connectors.put(this.liveTC.getName(), this.liveTC);
        ArrayList<String> connectorNames = new ArrayList<String>();
        connectorNames.add(this.liveTC.getName());
        ConfigurationImpl liveConf = this.createBasicConfig().addAcceptorConfiguration(new TransportConfiguration(INVM_ACCEPTOR_FACTORY)).setConnectorConfigurations(connectors).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreMasterPolicyConfiguration());
        long broadcastPeriod = 250L;
        String bcGroupName = "bc1";
        int localBindPort = 5432;
        BroadcastGroupConfiguration bcConfig1 = new BroadcastGroupConfiguration().setName("bc1").setBroadcastPeriod(250L).setConnectorInfos(connectorNames).setEndpointFactory((BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(this.groupAddress).setGroupPort(this.groupPort).setLocalBindPort(5432));
        ArrayList<BroadcastGroupConfiguration> bcConfigs1 = new ArrayList<BroadcastGroupConfiguration>();
        bcConfigs1.add(bcConfig1);
        liveConf.setBroadcastGroupConfigurations(bcConfigs1);
        this.liveService = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)liveConf, (boolean)false));
        this.liveService.start();
    }
}

