/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.integration.management.SecurityManagementTestBase;
import org.junit.Test;

public class SecurityManagementWithDefaultConfigurationTest
extends SecurityManagementTestBase {
    @Test
    public void testSendManagementMessageWithDefaultClusterAdminUser() throws Exception {
        this.doSendManagementMessage(ActiveMQDefaultConfiguration.getDefaultClusterUser(), ActiveMQDefaultConfiguration.getDefaultClusterPassword(), true);
    }

    @Test
    public void testSendManagementMessageWithGuest() throws Exception {
        this.doSendManagementMessage("guest", "guest", false);
    }

    @Test
    public void testSendManagementMessageWithoutUserCredentials() throws Exception {
        this.doSendManagementMessage(null, null, false);
    }

    @Override
    protected ActiveMQServer setupAndStartActiveMQServer() throws Exception {
        Configuration config = this.createDefaultInVMConfig().setClusterPassword(ActiveMQDefaultConfiguration.getDefaultClusterPassword()).setSecurityEnabled(true);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        return server;
    }
}

