/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.Map;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Assert;
import org.junit.Test;

public class ProducerAutoCreateQueueTest
extends BasicOpenWireTest {
    @Override
    protected void extraServerConfig(Configuration serverConfig) {
        serverConfig.setAddressQueueScanPeriod(100L);
        String match = "#";
        Map asMap = serverConfig.getAddressesSettings();
        ((AddressSettings)asMap.get(match)).setAutoCreateAddresses(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProducerBlockWontGetTimeout() throws Exception {
        try (Connection connection = null;){
            connection = this.factory.createConnection("admin", "password");
            Session session = connection.createSession(false, 1);
            Queue trash = session.createQueue("trash");
            MessageProducer producer = session.createProducer((Destination)trash);
            producer.send((Message)session.createTextMessage("foo"));
            Assert.assertNotNull((Object)this.server.getPostOffice().getBinding(new SimpleString("trash")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoCreateSendToTopic() throws Exception {
        try (Connection connection = null;){
            connection = this.factory.createConnection("admin", "password");
            Session session = connection.createSession(false, 1);
            Topic trash = session.createTopic("trash");
            MessageProducer producer = session.createProducer((Destination)trash);
            producer.send((Message)session.createTextMessage("foo"));
        }
        Wait.assertTrue(() -> this.server.getAddressInfo(new SimpleString("trash")) != null);
        Wait.assertEquals((long)0L, () -> ((ActiveMQServer)this.server).getTotalMessageCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoCreateSendToQueue() throws Exception {
        try (Connection connection = null;){
            connection = this.factory.createConnection("admin", "password");
            Session session = connection.createSession(false, 1);
            Queue trash = session.createQueue("trash");
            MessageProducer producer = session.createProducer((Destination)trash);
            producer.send((Message)session.createTextMessage("foo"));
        }
        Wait.assertTrue(() -> this.server.getAddressInfo(new SimpleString("trash")) != null);
        Wait.assertTrue(() -> this.server.locateQueue(new SimpleString("trash")) != null);
        Wait.assertEquals((long)1L, () -> ((ActiveMQServer)this.server).getTotalMessageCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoDelete() throws Exception {
        try (Connection connection = null;){
            connection = this.factory.createConnection("admin", "password");
            Session session = connection.createSession(false, 1);
            Queue trash = session.createQueue("trash");
            MessageProducer producer = session.createProducer((Destination)trash);
            producer.send((Message)session.createTextMessage("foo"));
            Assert.assertNotNull((Object)this.server.locateQueue(new SimpleString("trash")));
            MessageConsumer consumer = session.createConsumer((Destination)trash);
            connection.start();
            ProducerAutoCreateQueueTest.assertNotNull((Object)consumer.receive(1000L));
        }
        SimpleString queueName = SimpleString.toSimpleString((String)"trash");
        Wait.assertTrue(() -> this.server.locateQueue(queueName) == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoDeleteNegative() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("trash", (Object)new AddressSettings().setAutoDeleteQueues(Boolean.valueOf(false)).setAutoDeleteAddresses(Boolean.valueOf(false)));
        try (Connection connection = null;){
            connection = this.factory.createConnection("admin", "password");
            Session session = connection.createSession(false, 1);
            Queue trash = session.createQueue("trash");
            MessageProducer producer = session.createProducer((Destination)trash);
            producer.send((Message)session.createTextMessage("foo"));
            Assert.assertNotNull((Object)this.server.locateQueue(new SimpleString("trash")));
            MessageConsumer consumer = session.createConsumer((Destination)trash);
            connection.start();
            ProducerAutoCreateQueueTest.assertNotNull((Object)consumer.receive(1000L));
        }
        Wait.assertTrue(() -> this.server.locateQueue(new SimpleString("trash")) != null);
        Wait.assertTrue(() -> this.server.getAddressInfo(new SimpleString("trash")) != null);
    }
}

