/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.paging.impl.PagingManagerImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AnonymousProducerPageTest
extends ActiveMQTestBase {
    protected final String protocol;
    protected static final String NETTY_ACCEPTOR = "netty-acceptor";
    ActiveMQServer server;

    @Parameterized.Parameters(name="protocol={0}")
    public static Collection getParams() {
        return Arrays.asList({"AMQP"}, {"CORE"}, {"OPENWIRE"});
    }

    public AnonymousProducerPageTest(String protocol) {
        this.protocol = protocol;
    }

    @Before
    public void createServer() throws Exception {
        int port = 5672;
        this.server = this.addServer(this.createServer(true, true));
        this.server.getConfiguration().getAddressesSettings().clear();
        this.server.getConfiguration().addAddressesSetting("#", new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE));
        this.server.getConfiguration().getAcceptorConfigurations().clear();
        this.server.getConfiguration().getAcceptorConfigurations().add(this.addAcceptorConfiguration(this.server, port));
        this.server.getConfiguration().setName(this.getName());
        this.server.getConfiguration().setJournalDirectory(this.server.getConfiguration().getJournalDirectory() + port);
        this.server.getConfiguration().setBindingsDirectory(this.server.getConfiguration().getBindingsDirectory() + port);
        this.server.getConfiguration().setPagingDirectory(this.server.getConfiguration().getPagingDirectory() + port);
        this.server.getConfiguration().setLargeMessagesDirectory(this.server.getConfiguration().getLargeMessagesDirectory());
        this.server.getConfiguration().setJMXManagementEnabled(true);
        this.server.getConfiguration().setMessageExpiryScanPeriod(100L);
        this.server.start();
    }

    protected TransportConfiguration addAcceptorConfiguration(ActiveMQServer server, int port) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("port", String.valueOf(port));
        params.put("protocols", this.getConfiguredProtocols());
        HashMap<String, Object> amqpParams = new HashMap<String, Object>();
        this.configureAMQPAcceptorParameters(amqpParams);
        TransportConfiguration tc = new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params, NETTY_ACCEPTOR, amqpParams);
        this.configureAMQPAcceptorParameters(tc);
        return tc;
    }

    protected void configureAMQPAcceptorParameters(Map<String, Object> params) {
    }

    protected void configureAMQPAcceptorParameters(TransportConfiguration tc) {
    }

    protected String getConfiguredProtocols() {
        return "AMQP,OPENWIRE,CORE";
    }

    @Test(timeout=60000L)
    public void testNotBlockOnGlobalMaxSizeWithAnonymousProduce() throws Exception {
        int MSG_SIZE = 1000;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            builder.append('0');
        }
        String data = builder.toString();
        int MSG_COUNT = 3000;
        this.server.getPagingManager().addSize((int)((PagingManagerImpl)this.server.getPagingManager()).getMaxSize());
        this.server.getPagingManager().addSize(100000);
        this.server.getAddressSettingsRepository().addMatch("blockedQueue", (Object)new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK));
        ConnectionFactory factory = CFUtil.createConnectionFactory(this.protocol, "tcp://localhost:5672");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(true, 0);
        MessageProducer producer = session.createProducer(null);
        producer.setDeliveryMode(2);
        Queue jmsQueue = session.createQueue(this.getName());
        for (int i = 0; i < 3000; ++i) {
            TextMessage message = session.createTextMessage(data);
            producer.send((Destination)jmsQueue, (Message)message);
        }
        session.commit();
        if (this.protocol.equals("AMQP")) {
            this.validatePolicyMismatch(session, producer);
        }
        connection.close();
    }

    private void validatePolicyMismatch(Session session, MessageProducer producer) throws JMSException {
        AssertionLoggerHandler.startCapture();
        try {
            producer.send((Destination)session.createQueue("blockedQueue"), session.createMessage());
            session.commit();
            Assert.assertTrue((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ111004"}));
            AssertionLoggerHandler.clear();
            producer.send((Destination)session.createQueue(this.getName()), session.createMessage());
            session.commit();
            Assert.assertFalse((String)"The warning should be printed only once", (boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ111004"}));
        }
        finally {
            AssertionLoggerHandler.stopCapture();
        }
    }
}

