/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.ra;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ResourceAdapter;
import java.util.HashSet;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactoryImpl;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionManager;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.service.extensions.ServiceUtils;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.integration.ra.ActiveMQRATestBase;
import org.apache.activemq.artemis.tests.integration.ra.DummyTransaction;
import org.apache.activemq.artemis.tests.integration.ra.DummyTransactionManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OutgoingConnectionJTATest
extends ActiveMQRATestBase {
    protected ActiveMQResourceAdapter resourceAdapter;
    protected ActiveMQRAConnectionFactory qraConnectionFactory;
    protected ActiveMQRAManagedConnectionFactory mcf;
    ActiveMQRAConnectionManager qraConnectionManager = new ActiveMQRAConnectionManager();

    @Override
    public boolean useSecurity() {
        return true;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.useDummyTransactionManager();
        super.setUp();
        ((ActiveMQJAASSecurityManager)this.server.getSecurityManager()).getConfiguration().addUser("testuser", "testpassword");
        ((ActiveMQJAASSecurityManager)this.server.getSecurityManager()).getConfiguration().addUser("guest", "guest");
        ((ActiveMQJAASSecurityManager)this.server.getSecurityManager()).getConfiguration().setDefaultUser("guest");
        ((ActiveMQJAASSecurityManager)this.server.getSecurityManager()).getConfiguration().addRole("testuser", "arole");
        ((ActiveMQJAASSecurityManager)this.server.getSecurityManager()).getConfiguration().addRole("guest", "arole");
        Role role = new Role("arole", true, true, true, true, true, true, true, true, true, true);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        this.server.getSecurityRepository().addMatch("mdbQueue", roles);
        this.resourceAdapter = new ActiveMQResourceAdapter();
        this.resourceAdapter.setEntries("[\"java://jmsXA\"]");
        this.resourceAdapter.setConnectorClassName(InVMConnectorFactory.class.getName());
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        this.resourceAdapter.start((BootstrapContext)ctx);
        this.mcf = new ActiveMQRAManagedConnectionFactory();
        this.mcf.setResourceAdapter((ResourceAdapter)this.resourceAdapter);
        this.qraConnectionFactory = new ActiveMQRAConnectionFactoryImpl(this.mcf, (ConnectionManager)this.qraConnectionManager);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        ((DummyTransactionManager)ServiceUtils.getTransactionManager()).tx = null;
        if (this.resourceAdapter != null) {
            this.resourceAdapter.stop();
        }
        this.qraConnectionManager.stop();
        super.tearDown();
    }

    @Test
    public void testSimpleMessageSendAndReceiveTransacted() throws Exception {
        this.setDummyTX();
        this.setupDLQ(10);
        this.resourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        this.resourceAdapter.start((BootstrapContext)ctx);
        ActiveMQRAManagedConnectionFactory mcf = new ActiveMQRAManagedConnectionFactory();
        mcf.setResourceAdapter((ResourceAdapter)this.resourceAdapter);
        ActiveMQRAConnectionFactoryImpl qraConnectionFactory = new ActiveMQRAConnectionFactoryImpl(mcf, (ConnectionManager)this.qraConnectionManager);
        QueueConnection queueConnection = qraConnectionFactory.createQueueConnection();
        Session s = queueConnection.createSession(true, 1);
        Queue q = ActiveMQJMSClient.createQueue((String)"mdbQueue");
        MessageProducer mp = s.createProducer((Destination)q);
        MessageConsumer consumer = s.createConsumer((Destination)q);
        TextMessage message = s.createTextMessage("test");
        mp.send((Message)message);
        s.commit();
        queueConnection.start();
        TextMessage textMessage = (TextMessage)consumer.receive(1000L);
        OutgoingConnectionJTATest.assertNotNull((Object)textMessage);
        OutgoingConnectionJTATest.assertEquals((Object)textMessage.getText(), (Object)"test");
        s.rollback();
        textMessage = (TextMessage)consumer.receive(1000L);
        OutgoingConnectionJTATest.assertNotNull((Object)textMessage);
        OutgoingConnectionJTATest.assertEquals((Object)textMessage.getText(), (Object)"test");
        s.commit();
    }

    public void testQueuSessionAckMode(boolean inTx) throws Exception {
        block14: {
            Session s;
            QueueConnection queueConnection;
            block13: {
                if (inTx) {
                    this.setDummyTX();
                }
                queueConnection = this.qraConnectionFactory.createQueueConnection();
                s = queueConnection.createSession(false, 1);
                if (inTx) {
                    OutgoingConnectionJTATest.assertEquals((long)0L, (long)s.getAcknowledgeMode());
                } else {
                    OutgoingConnectionJTATest.assertEquals((long)1L, (long)s.getAcknowledgeMode());
                }
                s.close();
                s = queueConnection.createSession(false, 3);
                if (inTx) {
                    OutgoingConnectionJTATest.assertEquals((long)0L, (long)s.getAcknowledgeMode());
                } else {
                    OutgoingConnectionJTATest.assertEquals((long)3L, (long)s.getAcknowledgeMode());
                }
                s.close();
                try {
                    s = queueConnection.createSession(false, 0);
                    if (inTx) {
                        OutgoingConnectionJTATest.assertEquals((long)s.getAcknowledgeMode(), (long)0L);
                    } else {
                        OutgoingConnectionJTATest.fail((String)"didn't get expected exception creating session with SESSION_TRANSACTED mode ");
                    }
                    s.close();
                }
                catch (JMSException e) {
                    if (!inTx) break block13;
                    OutgoingConnectionJTATest.fail((String)("shouldn't throw exception " + (Object)((Object)e)));
                }
            }
            try {
                s = queueConnection.createSession(false, 2);
                if (inTx) {
                    OutgoingConnectionJTATest.assertEquals((long)s.getAcknowledgeMode(), (long)0L);
                } else {
                    OutgoingConnectionJTATest.fail((String)"didn't get expected exception creating session with CLIENT_ACKNOWLEDGE mode");
                }
            }
            catch (JMSException e) {
                if (!inTx) break block14;
                OutgoingConnectionJTATest.fail((String)("shouldn't throw exception " + (Object)((Object)e)));
            }
        }
    }

    @Test
    public void testSimpleSendNoXAJMSContext() throws Exception {
        Queue q = ActiveMQJMSClient.createQueue((String)"mdbQueue");
        try (ClientSessionFactory sf = this.locator.createSessionFactory();
             ClientSession session = sf.createSession();
             ClientConsumer consVerify = session.createConsumer("mdbQueue");
             JMSContext jmsctx = this.qraConnectionFactory.createContext();){
            session.start();
            JMSProducer producer = jmsctx.createProducer();
            producer.setProperty("strvalue", "hello");
            TextMessage msgsend = jmsctx.createTextMessage("hello");
            producer.send((Destination)q, (Message)msgsend);
            ClientMessage msg = consVerify.receive(1000L);
            OutgoingConnectionJTATest.assertNotNull((Object)msg);
            OutgoingConnectionJTATest.assertEquals((Object)"hello", (Object)msg.getStringProperty("strvalue"));
        }
    }

    @Test
    public void testQueueSessionAckModeJTA() throws Exception {
        this.testQueuSessionAckMode(true);
    }

    @Test
    public void testSessionAckModeNoJTA() throws Exception {
        this.testQueuSessionAckMode(false);
    }

    @Test
    public void testSimpleMessageSendAndReceive() throws Exception {
        QueueConnection queueConnection = this.qraConnectionFactory.createQueueConnection();
        Session s = queueConnection.createSession(false, 1);
        Queue q = ActiveMQJMSClient.createQueue((String)"mdbQueue");
        MessageProducer mp = s.createProducer((Destination)q);
        MessageConsumer consumer = s.createConsumer((Destination)q);
        TextMessage message = s.createTextMessage("test");
        mp.send((Message)message);
        queueConnection.start();
        TextMessage textMessage = (TextMessage)consumer.receive(1000L);
        OutgoingConnectionJTATest.assertNotNull((Object)textMessage);
        OutgoingConnectionJTATest.assertEquals((Object)textMessage.getText(), (Object)"test");
    }

    @Test
    public void testSimpleSendNoXAJMS1() throws Exception {
        Queue q = ActiveMQJMSClient.createQueue((String)"mdbQueue");
        try (ClientSessionFactory sf = this.locator.createSessionFactory();
             ClientSession session = sf.createSession();
             ClientConsumer consVerify = session.createConsumer("mdbQueue");
             Connection conn = this.qraConnectionFactory.createConnection();){
            Session jmsSess = conn.createSession(false, 1);
            session.start();
            MessageProducer producer = jmsSess.createProducer((Destination)q);
            TextMessage msgsend = jmsSess.createTextMessage("hello");
            msgsend.setStringProperty("strvalue", "hello");
            producer.send((Message)msgsend);
            ClientMessage msg = consVerify.receive(1000L);
            OutgoingConnectionJTATest.assertNotNull((Object)msg);
            OutgoingConnectionJTATest.assertEquals((Object)"hello", (Object)msg.getStringProperty("strvalue"));
        }
    }

    private void setDummyTX() {
        ((DummyTransactionManager)ServiceUtils.getTransactionManager()).tx = new DummyTransaction();
    }
}

