/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.security;

import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SecurityPerAcceptorTest
extends ActiveMQTestBase {
    private ServerLocator locator;
    private final boolean invm;
    private final String acceptorUrl;

    @Parameterized.Parameters(name="invm={0}")
    public static Collection<Object[]> data() {
        List<Object[]> list = Arrays.asList({true}, {false});
        return list;
    }

    public SecurityPerAcceptorTest(boolean invm) {
        this.invm = invm;
        this.acceptorUrl = invm ? "vm://1?securityDomain=PropertiesLogin" : "tcp://127.0.0.1:61616?securityDomain=PropertiesLogin";
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.invm ? this.createInVMLocator(1) : this.createNettyNonHALocator();
    }

    @Test
    public void testJAASSecurityManagerAuthentication() throws Exception {
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager();
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true).addAcceptorConfiguration("acceptor", this.acceptorUrl), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        try {
            ClientSession session = cf.createSession("first", "secret", false, true, true, false, 0);
            session.close();
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
            Assert.fail((String)"should not throw exception");
        }
    }

    @Test
    public void testJAASSecurityManagerAuthorizationNegative() throws Exception {
        ClientProducer producer;
        SimpleString ADDRESS = new SimpleString("address");
        SimpleString DURABLE_QUEUE = new SimpleString("durableQueue");
        SimpleString NON_DURABLE_QUEUE = new SimpleString("nonDurableQueue");
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager();
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().addAcceptorConfiguration("acceptor", this.acceptorUrl).setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("programmers", false, false, false, false, false, false, false, false, false, false));
        server.getConfiguration().putSecurityRoles("#", roles);
        server.start();
        server.addAddressInfo(new AddressInfo(ADDRESS, RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(DURABLE_QUEUE).setAddress(ADDRESS).setRoutingType(RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(NON_DURABLE_QUEUE).setAddress(ADDRESS).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(cf.createSession("first", "secret", false, true, true, false, 0));
        try {
            session.createQueue(new QueueConfiguration(DURABLE_QUEUE).setAddress(ADDRESS));
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            SecurityPerAcceptorTest.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='CREATE_DURABLE_QUEUE' for queue durableQueue on address address"));
        }
        try {
            session.deleteQueue(DURABLE_QUEUE);
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            SecurityPerAcceptorTest.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='DELETE_DURABLE_QUEUE' for queue durableQueue on address address"));
        }
        try {
            session.createQueue(new QueueConfiguration(NON_DURABLE_QUEUE).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            SecurityPerAcceptorTest.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='CREATE_NON_DURABLE_QUEUE' for queue nonDurableQueue on address address"));
        }
        try {
            session.deleteQueue(NON_DURABLE_QUEUE);
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            SecurityPerAcceptorTest.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='DELETE_NON_DURABLE_QUEUE' for queue nonDurableQueue on address address"));
        }
        try {
            producer = session.createProducer(ADDRESS);
            producer.send((Message)session.createMessage(true));
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            SecurityPerAcceptorTest.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='SEND' on address address"));
        }
        try {
            ClientConsumer consumer = session.createConsumer(DURABLE_QUEUE);
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            SecurityPerAcceptorTest.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='CONSUME' for queue durableQueue on address address"));
        }
        try {
            producer = session.createProducer(server.getConfiguration().getManagementAddress());
            producer.send((Message)session.createMessage(true));
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            SecurityPerAcceptorTest.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='MANAGE' on address activemq.management"));
        }
        try {
            ClientConsumer browser = session.createConsumer(DURABLE_QUEUE, true);
            Assert.fail((String)"should throw exception here");
        }
        catch (ActiveMQException e) {
            SecurityPerAcceptorTest.assertTrue((boolean)e.getMessage().contains("User: first does not have permission='BROWSE' for queue durableQueue on address address"));
        }
    }

    @Test
    public void testJAASSecurityManagerAuthorizationPositive() throws Exception {
        ClientProducer producer;
        SimpleString ADDRESS = new SimpleString("address");
        SimpleString DURABLE_QUEUE = new SimpleString("durableQueue");
        SimpleString NON_DURABLE_QUEUE = new SimpleString("nonDurableQueue");
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager();
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true).addAcceptorConfiguration("acceptor", this.acceptorUrl), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("programmers", true, true, true, true, true, true, true, true, true, true));
        server.getConfiguration().putSecurityRoles("#", roles);
        server.start();
        ClientSessionFactory cf = this.createSessionFactory(this.locator);
        ClientSession session = this.addClientSession(cf.createSession("first", "secret", false, true, true, false, 0));
        try {
            session.createQueue(new QueueConfiguration(DURABLE_QUEUE).setAddress(ADDRESS));
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
        try {
            session.deleteQueue(DURABLE_QUEUE);
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
        try {
            session.createQueue(new QueueConfiguration(NON_DURABLE_QUEUE).setAddress(ADDRESS).setDurable(Boolean.valueOf(false)));
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
        try {
            session.deleteQueue(NON_DURABLE_QUEUE);
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
        session.createQueue(new QueueConfiguration(DURABLE_QUEUE).setAddress(ADDRESS));
        try {
            producer = session.createProducer(ADDRESS);
            producer.send((Message)session.createMessage(true));
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
        try {
            session.createConsumer(DURABLE_QUEUE);
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
        try {
            producer = session.createProducer(server.getConfiguration().getManagementAddress());
            producer.send((Message)session.createMessage(true));
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
        try {
            session.createConsumer(DURABLE_QUEUE, true);
        }
        catch (ActiveMQException e) {
            Assert.fail((String)"should not throw exception here");
        }
    }

    static {
        URL resource;
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = SecurityPerAcceptorTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }
}

