/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.SingleServerTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Test;

public class TempQueueNamespaceTest
extends SingleServerTestBase {
    @Test
    public void testTempQueueNamespace() throws Exception {
        String TEMP_QUEUE_NAMESPACE = "temp";
        this.server.getConfiguration().setTemporaryQueueNamespace("temp");
        this.server.getAddressSettingsRepository().addMatch("temp.#", (Object)new AddressSettings().setDefaultRingSize(10L));
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        TempQueueNamespaceTest.assertEquals((long)10L, (long)this.server.locateQueue(queue).getQueueConfiguration().getRingSize());
        this.session.close();
    }

    @Test
    public void testTempQueueNamespaceNegative() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        this.session.createQueue(new QueueConfiguration(queue).setAddress(address).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        TempQueueNamespaceTest.assertNotEquals((long)10L, (long)this.server.locateQueue(queue).getQueueConfiguration().getRingSize());
        this.session.close();
    }
}

