/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.paging.impl;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.message.impl.CoreMessagePersister;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.cursor.PageCursorProvider;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageCursorProviderImpl;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.paging.impl.PageTransactionInfoImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreImpl;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.core.server.files.FileStoreMonitor;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessagePersister;
import org.apache.activemq.artemis.spi.core.protocol.MessagePersister;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.fakes.FakeSequentialFileFactory;
import org.apache.activemq.artemis.tests.unit.util.FakePagingManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PagingStoreImplTest
extends ActiveMQTestBase {
    private static final Logger log = Logger.getLogger(PagingStoreImplTest.class);
    private static final SimpleString destinationTestName;
    private final ReentrantReadWriteLock.ReadLock lock = new ReentrantReadWriteLock().readLock();
    protected ExecutorService executor;

    @Test
    public void testAddAndRemoveMessages() {
        long id1 = RandomUtil.randomLong();
        long id2 = RandomUtil.randomLong();
        PageTransactionInfoImpl trans = new PageTransactionInfoImpl(id2);
        trans.setRecordID(id1);
        int nr1 = RandomUtil.randomPositiveInt() % 98 + 2;
        for (int i = 0; i < nr1; ++i) {
            trans.increment(1, 0);
        }
        Assert.assertEquals((long)nr1, (long)trans.getNumberOfMessages());
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)trans.getEncodeSize());
        trans.encode(buffer);
        PageTransactionInfoImpl trans2 = new PageTransactionInfoImpl(id1);
        trans2.decode(buffer);
        Assert.assertEquals((long)id2, (long)trans2.getTransactionID());
        Assert.assertEquals((long)nr1, (long)trans2.getNumberOfMessages());
    }

    @Test
    public void testDoubleStart() throws Exception {
        FakeSequentialFileFactory factory = new FakeSequentialFileFactory();
        PagingStoreImpl storeImpl = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), (SequentialFileFactory)factory, (PagingStoreFactory)new FakeStoreFactory(factory), destinationTestName, new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE), this.getExecutorFactory().getExecutor(), true);
        storeImpl.start();
        storeImpl.start();
        storeImpl.stop();
    }

    @Test
    public void testPageWithNIO() throws Exception {
        ActiveMQTestBase.recreateDirectory((String)this.getTestDir());
        this.testConcurrentPaging(new NIOSequentialFileFactory(new File(this.getTestDir()), 1).setDatasync(false), 1);
    }

    @Test
    public void testStore() throws Exception {
        FakeSequentialFileFactory factory = new FakeSequentialFileFactory();
        FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
        AddressSettings addressSettings = new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        PagingStoreImpl storeImpl = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), (SequentialFileFactory)factory, (PagingStoreFactory)storeFactory, destinationTestName, addressSettings, this.getExecutorFactory().getExecutor(), true);
        storeImpl.start();
        Assert.assertEquals((long)0L, (long)storeImpl.getNumberOfPages());
        storeImpl.startPaging();
        Assert.assertEquals((long)1L, (long)storeImpl.getNumberOfPages());
        ArrayList<ActiveMQBuffer> buffers = new ArrayList<ActiveMQBuffer>();
        ActiveMQBuffer buffer = this.createRandomBuffer(0L, 10);
        buffers.add(buffer);
        SimpleString destination = new SimpleString("test");
        CoreMessage msg = this.createMessage(1L, (PagingStore)storeImpl, destination, buffer);
        Assert.assertTrue((boolean)storeImpl.isPaging());
        RoutingContextImpl ctx = new RoutingContextImpl(null);
        Assert.assertTrue((boolean)storeImpl.page((Message)msg, ctx.getTransaction(), ctx.getContextListing(storeImpl.getStoreName()), this.lock));
        Assert.assertEquals((long)1L, (long)storeImpl.getNumberOfPages());
        storeImpl.sync();
        storeImpl = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), (SequentialFileFactory)factory, (PagingStoreFactory)storeFactory, destinationTestName, addressSettings, this.getExecutorFactory().getExecutor(), true);
        storeImpl.start();
        Assert.assertEquals((long)1L, (long)storeImpl.getNumberOfPages());
        storeImpl.stop();
    }

    @Test
    public void testDepageOnCurrentPage() throws Exception {
        FakeSequentialFileFactory factory = new FakeSequentialFileFactory();
        SimpleString destination = new SimpleString("test");
        FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
        PagingStoreImpl storeImpl = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), (SequentialFileFactory)factory, (PagingStoreFactory)storeFactory, destinationTestName, new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE), this.getExecutorFactory().getExecutor(), true);
        storeImpl.start();
        Assert.assertEquals((long)0L, (long)storeImpl.getNumberOfPages());
        storeImpl.startPaging();
        ArrayList<ActiveMQBuffer> buffers = new ArrayList<ActiveMQBuffer>();
        int numMessages = 10;
        for (int i = 0; i < numMessages; ++i) {
            ActiveMQBuffer buffer = this.createRandomBuffer((long)i + 1L, 10);
            buffers.add(buffer);
            CoreMessage msg = this.createMessage(i, (PagingStore)storeImpl, destination, buffer);
            RoutingContextImpl ctx = new RoutingContextImpl(null);
            Assert.assertTrue((boolean)storeImpl.page((Message)msg, ctx.getTransaction(), ctx.getContextListing(storeImpl.getStoreName()), this.lock));
        }
        Assert.assertEquals((long)1L, (long)storeImpl.getNumberOfPages());
        storeImpl.sync();
        Page page = storeImpl.depage();
        page.open();
        List msg = page.read((StorageManager)new NullStorageManager());
        Assert.assertEquals((long)numMessages, (long)msg.size());
        Assert.assertEquals((long)1L, (long)storeImpl.getNumberOfPages());
        page.close(false);
        page = storeImpl.depage();
        Assert.assertNull((Object)page);
        Assert.assertEquals((long)0L, (long)storeImpl.getNumberOfPages());
        for (int i = 0; i < numMessages; ++i) {
            ActiveMQBuffer horn1 = (ActiveMQBuffer)buffers.get(i);
            ActiveMQBuffer horn2 = ((PagedMessage)msg.get(i)).getMessage().toCore().getBodyBuffer();
            horn1.resetReaderIndex();
            horn2.resetReaderIndex();
            for (int j = 0; j < horn1.writerIndex(); ++j) {
                Assert.assertEquals((long)horn1.readByte(), (long)horn2.readByte());
            }
        }
    }

    @Test
    public void testDepageMultiplePages() throws Exception {
        FakeSequentialFileFactory factory = new FakeSequentialFileFactory();
        SimpleString destination = new SimpleString("test");
        FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
        PagingStoreImpl store = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), (SequentialFileFactory)factory, (PagingStoreFactory)storeFactory, destinationTestName, new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE), this.getExecutorFactory().getExecutor(), true);
        store.start();
        Assert.assertEquals((long)0L, (long)store.getNumberOfPages());
        store.startPaging();
        Assert.assertEquals((long)1L, (long)store.getNumberOfPages());
        ArrayList<ActiveMQBuffer> buffers = new ArrayList<ActiveMQBuffer>();
        for (int i = 0; i < 10; ++i) {
            ActiveMQBuffer buffer = this.createRandomBuffer((long)i + 1L, 10);
            buffers.add(buffer);
            if (i == 5) {
                store.forceAnotherPage();
            }
            CoreMessage msg = this.createMessage(i, (PagingStore)store, destination, buffer);
            RoutingContextImpl ctx = new RoutingContextImpl(null);
            Assert.assertTrue((boolean)store.page((Message)msg, ctx.getTransaction(), ctx.getContextListing(store.getStoreName()), this.lock));
        }
        Assert.assertEquals((long)2L, (long)store.getNumberOfPages());
        store.sync();
        int sequence = 0;
        for (int pageNr = 0; pageNr < 2; ++pageNr) {
            Page page = store.depage();
            log.debug((Object)("numberOfPages = " + store.getNumberOfPages()));
            page.open();
            List msg = page.read((StorageManager)new NullStorageManager());
            page.close(false, false);
            Assert.assertEquals((long)5L, (long)msg.size());
            for (int i = 0; i < 5; ++i) {
                Assert.assertEquals((long)sequence++, (long)((PagedMessage)msg.get(i)).getMessage().getMessageID());
                ActiveMQTestBase.assertEqualsBuffers((int)18, (ActiveMQBuffer)((ActiveMQBuffer)buffers.get(pageNr * 5 + i)), (ActiveMQBuffer)((PagedMessage)msg.get(i)).getMessage().toCore().getBodyBuffer());
            }
        }
        Assert.assertEquals((long)1L, (long)store.getNumberOfPages());
        Assert.assertTrue((boolean)store.isPaging());
        CoreMessage msg = this.createMessage(1L, (PagingStore)store, destination, (ActiveMQBuffer)buffers.get(0));
        RoutingContextImpl ctx = new RoutingContextImpl(null);
        Assert.assertTrue((boolean)store.page((Message)msg, ctx.getTransaction(), ctx.getContextListing(store.getStoreName()), this.lock));
        Page newPage = store.depage();
        newPage.open();
        Assert.assertEquals((long)1L, (long)newPage.read((StorageManager)new NullStorageManager()).size());
        newPage.delete(null);
        Assert.assertEquals((long)1L, (long)store.getNumberOfPages());
        Assert.assertTrue((boolean)store.isPaging());
        Assert.assertNull((Object)store.depage());
        Assert.assertFalse((boolean)store.isPaging());
        RoutingContextImpl ctx2 = new RoutingContextImpl(null);
        Assert.assertFalse((boolean)store.page((Message)msg, ctx2.getTransaction(), ctx2.getContextListing(store.getStoreName()), this.lock));
        store.startPaging();
        ctx2 = new RoutingContextImpl(null);
        Assert.assertTrue((boolean)store.page((Message)msg, ctx2.getTransaction(), ctx2.getContextListing(store.getStoreName()), this.lock));
        Page page = store.depage();
        page.open();
        List msgs = page.read((StorageManager)new NullStorageManager());
        Assert.assertEquals((long)1L, (long)msgs.size());
        Assert.assertEquals((long)1L, (long)((PagedMessage)msgs.get(0)).getMessage().getMessageID());
        ActiveMQTestBase.assertEqualsBuffers((int)18, (ActiveMQBuffer)((ActiveMQBuffer)buffers.get(0)), (ActiveMQBuffer)((PagedMessage)msgs.get(0)).getMessage().toCore().getBodyBuffer());
        Assert.assertEquals((long)1L, (long)store.getNumberOfPages());
        Assert.assertTrue((boolean)store.isPaging());
        Assert.assertNull((Object)store.depage());
        Assert.assertEquals((long)0L, (long)store.getNumberOfPages());
        page.open();
        page.close(false);
    }

    @Test
    public void testConcurrentDepage() throws Exception {
        FakeSequentialFileFactory factory = new FakeSequentialFileFactory(1, false);
        this.testConcurrentPaging(factory, 10);
    }

    protected void testConcurrentPaging(SequentialFileFactory factory, int numberOfThreads) throws Exception {
        Page page;
        FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
        int MAX_SIZE = 10240;
        final AtomicLong messageIdGenerator = new AtomicLong(0L);
        final AtomicInteger aliveProducers = new AtomicInteger(numberOfThreads);
        final CountDownLatch latchStart = new CountDownLatch(numberOfThreads);
        ConcurrentHashMap buffers = new ConcurrentHashMap();
        ArrayList readPages = new ArrayList();
        AddressSettings settings = new AddressSettings().setPageSizeBytes(10240).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        PagingStoreImpl storeImpl = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), factory, (PagingStoreFactory)storeFactory, new SimpleString("test"), settings, this.getExecutorFactory().getExecutor(), true);
        storeImpl.start();
        Assert.assertEquals((long)0L, (long)storeImpl.getNumberOfPages());
        storeImpl.startPaging();
        Assert.assertEquals((long)1L, (long)storeImpl.getNumberOfPages());
        SimpleString destination = new SimpleString("test");
        class WriterThread
        extends Thread {
            Exception e;
            final /* synthetic */ PagingStore val$storeImpl;
            final /* synthetic */ SimpleString val$destination;
            final /* synthetic */ ConcurrentHashMap val$buffers;
            final /* synthetic */ CountDownLatch val$latchStart;
            final /* synthetic */ AtomicInteger val$aliveProducers;

            WriterThread() {
                this.val$storeImpl = pagingStore;
                this.val$destination = simpleString;
                this.val$buffers = concurrentHashMap;
                this.val$latchStart = countDownLatch;
                this.val$aliveProducers = atomicInteger;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    RoutingContextImpl ctx2;
                    long id;
                    CoreMessage msg;
                    boolean firstTime = true;
                    while (this.val$storeImpl.page((Message)(msg = PagingStoreImplTest.this.createMessage(id = messageIdGenerator.incrementAndGet(), this.val$storeImpl, this.val$destination, PagingStoreImplTest.this.createRandomBuffer(id, 5))), (ctx2 = new RoutingContextImpl(null)).getTransaction(), ctx2.getContextListing(this.val$storeImpl.getStoreName()), PagingStoreImplTest.this.lock)) {
                        this.val$buffers.put(id, msg);
                        if (!firstTime) continue;
                        this.val$latchStart.countDown();
                        firstTime = false;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    this.e = e1;
                }
                finally {
                    this.val$aliveProducers.decrementAndGet();
                }
            }
        }
        WriterThread[] producerThread = new WriterThread[numberOfThreads];
        for (int i = 0; i < numberOfThreads; ++i) {
            producerThread[i] = new WriterThread();
            producerThread[i].start();
        }
        final class ReaderThread
        extends Thread {
            Exception e;
            final /* synthetic */ PagingStore val$storeImpl;
            final /* synthetic */ ArrayList val$readPages;

            ReaderThread() {
                this.val$storeImpl = pagingStore;
                this.val$readPages = arrayList;
            }

            @Override
            public void run() {
                try {
                    ActiveMQTestBase.waitForLatch((CountDownLatch)latchStart);
                    while (aliveProducers.get() > 0) {
                        Page page = this.val$storeImpl.depage();
                        if (page == null) continue;
                        this.val$readPages.add(page);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    this.e = e1;
                }
            }
        }
        ReaderThread consumer = new ReaderThread();
        consumer.start();
        for (int i = 0; i < numberOfThreads; ++i) {
            producerThread[i].join();
            if (producerThread[i].e == null) continue;
            throw producerThread[i].e;
        }
        consumer.join();
        if (consumer.e != null) {
            throw consumer.e;
        }
        ConcurrentHashMap<Long, Object> buffers2 = new ConcurrentHashMap<Long, Object>();
        for (Object page2 : readPages) {
            page2.open();
            List msgs = page2.read((StorageManager)new NullStorageManager());
            page2.close(false, false);
            for (PagedMessage msg : msgs) {
                long id = msg.getMessage().toCore().getBodyBuffer().readLong();
                msg.getMessage().toCore().getBodyBuffer().resetReaderIndex();
                Message msgWritten = (Message)buffers.remove(id);
                buffers2.put(id, msg.getMessage());
                Assert.assertNotNull((Object)msgWritten);
                Assert.assertEquals((Object)msg.getMessage().getAddress(), (Object)msgWritten.getAddress());
                ActiveMQTestBase.assertEqualsBuffers((int)10, (ActiveMQBuffer)msgWritten.toCore().getBodyBuffer(), (ActiveMQBuffer)msg.getMessage().toCore().getBodyBuffer());
            }
        }
        Assert.assertEquals((long)0L, (long)buffers.size());
        List files = factory.listFiles("page");
        Assert.assertTrue((files.size() != 0 ? (byte)1 : 0) != 0);
        for (String file : files) {
            SequentialFile fileTmp = factory.createSequentialFile(file);
            fileTmp.open();
            Assert.assertTrue((String)("The page file size (" + fileTmp.size() + ") shouldn't be > " + 10240), (fileTmp.size() <= 10240L ? (byte)1 : 0) != 0);
            fileTmp.close();
        }
        PagingStoreImpl storeImpl2 = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), factory, (PagingStoreFactory)storeFactory, new SimpleString("test"), settings, this.getExecutorFactory().getExecutor(), true);
        storeImpl2.start();
        int numberOfPages = storeImpl2.getNumberOfPages();
        Assert.assertTrue((numberOfPages != 0 ? (byte)1 : 0) != 0);
        storeImpl2.startPaging();
        storeImpl2.startPaging();
        Assert.assertEquals((long)numberOfPages, (long)storeImpl2.getNumberOfPages());
        long lastMessageId = messageIdGenerator.incrementAndGet();
        CoreMessage lastMsg = this.createMessage(lastMessageId, (PagingStore)storeImpl, destination, this.createRandomBuffer(lastMessageId, 5));
        storeImpl2.forceAnotherPage();
        RoutingContextImpl ctx = new RoutingContextImpl(null);
        storeImpl2.page((Message)lastMsg, ctx.getTransaction(), ctx.getContextListing(storeImpl2.getStoreName()), this.lock);
        buffers2.put(lastMessageId, lastMsg);
        Page lastPage = null;
        while ((page = storeImpl2.depage()) != null) {
            lastPage = page;
            page.open();
            List msgs = page.read((StorageManager)new NullStorageManager());
            page.close(false, false);
            for (PagedMessage msg : msgs) {
                long id = msg.getMessage().toCore().getBodyBuffer().readLong();
                Message msgWritten = (Message)buffers2.remove(id);
                Assert.assertNotNull((Object)msgWritten);
                Assert.assertEquals((Object)msg.getMessage().getAddress(), (Object)msgWritten.getAddress());
                ActiveMQTestBase.assertEqualsByteArrays((int)msgWritten.toCore().getBodyBuffer().writerIndex(), (byte[])msgWritten.toCore().getBodyBuffer().toByteBuffer().array(), (byte[])msg.getMessage().toCore().getBodyBuffer().toByteBuffer().array());
            }
        }
        lastPage.open();
        List lastMessages = lastPage.read((StorageManager)new NullStorageManager());
        lastPage.close(false, false);
        Assert.assertEquals((long)1L, (long)lastMessages.size());
        ((PagedMessage)lastMessages.get(0)).getMessage().toCore().getBodyBuffer().resetReaderIndex();
        Assert.assertEquals((long)((PagedMessage)lastMessages.get(0)).getMessage().toCore().getBodyBuffer().readLong(), (long)lastMessageId);
        Assert.assertEquals((long)0L, (long)buffers2.size());
        Assert.assertEquals((long)0L, (long)storeImpl.getAddressSize());
        storeImpl.stop();
    }

    @Test
    public void testRestartPage() throws Throwable {
        this.clearDataRecreateServerDirs();
        SequentialFileFactory factory = new NIOSequentialFileFactory(new File(this.getPageDir()), 1).setDatasync(false);
        FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
        int MAX_SIZE = 10240;
        AddressSettings settings = new AddressSettings().setPageSizeBytes(10240).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        PagingStoreImpl storeImpl = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), factory, (PagingStoreFactory)storeFactory, new SimpleString("test"), settings, this.getExecutorFactory().getExecutor(), true);
        storeImpl.start();
        Assert.assertEquals((long)0L, (long)storeImpl.getNumberOfPages());
        storeImpl.startPaging();
        storeImpl.depage();
        Assert.assertNull((Object)storeImpl.getCurrentPage());
        storeImpl.startPaging();
        Assert.assertNotNull((Object)storeImpl.getCurrentPage());
        storeImpl.stop();
    }

    @Test
    public void testOrderOnPaging() throws Throwable {
        this.clearDataRecreateServerDirs();
        SequentialFileFactory factory = new NIOSequentialFileFactory(new File(this.getPageDir()), 1).setDatasync(false);
        FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
        int MAX_SIZE = 10240;
        AddressSettings settings = new AddressSettings().setPageSizeBytes(10240).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        PagingStoreImpl store = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), factory, (PagingStoreFactory)storeFactory, new SimpleString("test"), settings, this.getExecutorFactory().getExecutor(), false);
        store.start();
        Assert.assertEquals((long)0L, (long)store.getNumberOfPages());
        store.startPaging();
        CountDownLatch producedLatch = new CountDownLatch(1);
        Assert.assertEquals((long)1L, (long)store.getNumberOfPages());
        SimpleString destination = new SimpleString("test");
        long NUMBER_OF_MESSAGES = 100000L;
        ArrayList errors = new ArrayList();
        class WriterThread
        extends Thread {
            final /* synthetic */ PagingStore val$store;
            final /* synthetic */ SimpleString val$destination;
            final /* synthetic */ CountDownLatch val$producedLatch;
            final /* synthetic */ List val$errors;

            WriterThread() {
                this.val$store = pagingStore;
                this.val$destination = simpleString;
                this.val$producedLatch = countDownLatch;
                this.val$errors = list;
                super("PageWriter");
            }

            @Override
            public void run() {
                try {
                    for (long i = 0L; i < 100000L; ++i) {
                        CoreMessage msg = PagingStoreImplTest.this.createMessage(i, this.val$store, this.val$destination, PagingStoreImplTest.this.createRandomBuffer(i, 1024));
                        msg.putLongProperty("count", i);
                        RoutingContextImpl ctx2 = new RoutingContextImpl(null);
                        while (!this.val$store.page((Message)msg, ctx2.getTransaction(), ctx2.getContextListing(this.val$store.getStoreName()), PagingStoreImplTest.this.lock)) {
                            this.val$store.startPaging();
                        }
                        if (i != 0L) continue;
                        this.val$producedLatch.countDown();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.val$errors.add(e);
                }
            }
        }
        WriterThread producerThread = new WriterThread();
        producerThread.start();
        class ReaderThread
        extends Thread {
            final /* synthetic */ PagingStore val$store;
            final /* synthetic */ List val$errors;

            ReaderThread() {
                this.val$store = pagingStore;
                this.val$errors = list;
                super("PageReader");
            }

            @Override
            public void run() {
                try {
                    long msgsRead = 0L;
                    while (msgsRead < 100000L) {
                        Page page = this.val$store.depage();
                        if (page != null) {
                            page.open();
                            List messages = page.read((StorageManager)new NullStorageManager());
                            for (PagedMessage pgmsg : messages) {
                                Message msg = pgmsg.getMessage();
                                Assert.assertEquals((long)msgsRead++, (long)msg.getMessageID());
                                Assert.assertEquals((long)msg.getMessageID(), (long)msg.getLongProperty("count"));
                            }
                            page.close(false, false);
                            page.delete(null);
                            continue;
                        }
                        log.debug((Object)("Depaged!!!! numerOfMessages = " + msgsRead + " of " + 100000L));
                        Thread.sleep(500L);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.val$errors.add(e);
                }
            }
        }
        ReaderThread consumer = new ReaderThread();
        consumer.start();
        producerThread.join();
        consumer.join();
        store.stop();
        Iterator iterator = errors.iterator();
        if (iterator.hasNext()) {
            Throwable e = (Throwable)iterator.next();
            throw e;
        }
    }

    @Test
    public void testWriteIncompletePage() throws Exception {
        this.clearDataRecreateServerDirs();
        SequentialFileFactory factory = new NIOSequentialFileFactory(new File(this.getPageDir()), 1).setDatasync(false);
        FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
        int MAX_SIZE = 0x100000;
        AddressSettings settings = new AddressSettings().setPageSizeBytes(0x100000).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        PagingStoreImpl storeImpl = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), factory, (PagingStoreFactory)storeFactory, new SimpleString("test"), settings, this.getExecutorFactory().getExecutor(), true);
        storeImpl.start();
        Assert.assertEquals((long)0L, (long)storeImpl.getNumberOfPages());
        storeImpl.startPaging();
        Page page = storeImpl.getCurrentPage();
        int num1 = 20;
        for (int i = 0; i < num1; ++i) {
            this.writePageMessage((PagingStore)storeImpl, i);
        }
        long position = page.getFile().position();
        this.writePageMessage((PagingStore)storeImpl, 30L);
        page.getFile().position(position);
        ByteBuffer buffer = ByteBuffer.allocate(10);
        for (int i = 0; i < buffer.capacity(); ++i) {
            buffer.put((byte)90);
        }
        buffer.rewind();
        page.getFile().writeDirect(buffer, true);
        storeImpl.stop();
        storeImpl.start();
        int num2 = 10;
        for (int i = 0; i < num2; ++i) {
            this.writePageMessage((PagingStore)storeImpl, i + num1);
        }
        storeImpl.stop();
        storeImpl.start();
        long msgsRead = 0L;
        while (msgsRead < (long)(num1 + num2)) {
            page = storeImpl.depage();
            PagingStoreImplTest.assertNotNull((String)("no page after read " + msgsRead + " msg"), (Object)page);
            page.open();
            List messages = page.read((StorageManager)new NullStorageManager());
            for (PagedMessage pgmsg : messages) {
                Message msg = pgmsg.getMessage();
                Assert.assertEquals((long)msgsRead, (long)msg.getMessageID());
                Assert.assertEquals((long)msg.getMessageID(), (long)msg.getLongProperty("count"));
                ++msgsRead;
            }
            page.close(false);
        }
        storeImpl.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogStartPaging() throws Exception {
        FakeSequentialFileFactory factory = new FakeSequentialFileFactory();
        FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
        PagingStoreImpl store = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), (SequentialFileFactory)factory, (PagingStoreFactory)storeFactory, destinationTestName, new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE), this.getExecutorFactory().getExecutor(), true);
        store.start();
        AssertionLoggerHandler.startCapture();
        try {
            store.startPaging();
            store.stopPaging();
            Assert.assertTrue((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ222038"}));
        }
        finally {
            AssertionLoggerHandler.stopCapture();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogStopPaging() throws Exception {
        FakeSequentialFileFactory factory = new FakeSequentialFileFactory();
        FakeStoreFactory storeFactory = new FakeStoreFactory(factory);
        PagingStoreImpl store = new PagingStoreImpl(destinationTestName, null, 100L, this.createMockManager(), this.createStorageManagerMock(), (SequentialFileFactory)factory, (PagingStoreFactory)storeFactory, destinationTestName, new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE), this.getExecutorFactory().getExecutor(), true);
        store.start();
        AssertionLoggerHandler.startCapture();
        try {
            store.startPaging();
            store.stopPaging();
            Assert.assertTrue((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224108"}));
        }
        finally {
            AssertionLoggerHandler.stopCapture();
        }
    }

    protected PagingManager createMockManager() {
        return new FakePagingManager();
    }

    private StorageManager createStorageManagerMock() {
        return new NullStorageManager();
    }

    private ExecutorFactory getExecutorFactory() {
        return new ExecutorFactory(){

            public ArtemisExecutor getExecutor() {
                return ArtemisExecutor.delegate((Executor)PagingStoreImplTest.this.executor);
            }
        };
    }

    protected void writePageMessage(PagingStore storeImpl, long id) throws Exception {
        CoreMessage msg = this.createMessage(id, storeImpl, destinationTestName, this.createRandomBuffer(id, 10));
        msg.putLongProperty("count", id);
        RoutingContextImpl ctx2 = new RoutingContextImpl(null);
        storeImpl.page((Message)msg, ctx2.getTransaction(), ctx2.getContextListing(storeImpl.getStoreName()), this.lock);
    }

    private CoreMessage createMessage(long id, PagingStore store, SimpleString destination, ActiveMQBuffer buffer) {
        CoreMessage msg = new CoreMessage(id, 50 + buffer.capacity());
        msg.setAddress(destination);
        msg.getBodyBuffer().resetReaderIndex();
        msg.getBodyBuffer().resetWriterIndex();
        msg.getBodyBuffer().writeBytes(buffer, buffer.capacity());
        return msg;
    }

    protected ActiveMQBuffer createRandomBuffer(long id, int size) {
        return RandomUtil.randomBuffer((int)size, (long[])new long[]{id});
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
    }

    @After
    public void tearDown() throws Exception {
        this.executor.shutdown();
        super.tearDown();
    }

    static {
        MessagePersister.registerPersister((Persister)CoreMessagePersister.getInstance());
        MessagePersister.registerPersister((Persister)AMQPMessagePersister.getInstance());
        destinationTestName = new SimpleString("test");
    }

    static final class FakeStoreFactory
    implements PagingStoreFactory {
        final SequentialFileFactory factory;

        FakeStoreFactory() {
            this.factory = new FakeSequentialFileFactory();
        }

        FakeStoreFactory(SequentialFileFactory factory) {
            this.factory = factory;
        }

        public SequentialFileFactory newFileFactory(SimpleString destinationName) throws Exception {
            return this.factory;
        }

        public void removeFileFactory(SequentialFileFactory fileFactory) throws Exception {
        }

        public PagingStore newStore(SimpleString destinationName, AddressSettings addressSettings) {
            return null;
        }

        public List<PagingStore> reloadStores(HierarchicalRepository<AddressSettings> addressSettingsRepository) throws Exception {
            return null;
        }

        public PageCursorProvider newCursorProvider(PagingStore store, StorageManager storageManager, AddressSettings addressSettings, ArtemisExecutor executor) {
            return new PageCursorProviderImpl(store, storageManager, executor, addressSettings.getPageCacheMaxSize());
        }

        public void setPagingManager(PagingManager manager) {
        }

        public void stop() throws InterruptedException {
        }

        public void injectMonitor(FileStoreMonitor monitor) throws Exception {
        }

        public void beforePageRead() throws Exception {
        }

        public void afterPageRead() throws Exception {
        }

        public ByteBuffer allocateDirectBuffer(int size) {
            return ByteBuffer.allocateDirect(size);
        }

        public void freeDirectuffer(ByteBuffer buffer) {
        }
    }
}

