/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import org.hibernate.envers.CollectionAuditTable;
import org.hibernate.envers.boot.model.CompositeIdentifier;
import org.hibernate.envers.boot.model.RootPersistentEntity;
import org.hibernate.envers.boot.spi.EnversMetadataBuildingContext;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.configuration.internal.metadata.AbstractCollectionMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.AuditEntityNameRegister;
import org.hibernate.envers.configuration.internal.metadata.AuditTableData;
import org.hibernate.envers.configuration.internal.metadata.BasicMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.CollectionMappedByResolver;
import org.hibernate.envers.configuration.internal.metadata.CollectionMetadataContext;
import org.hibernate.envers.configuration.internal.metadata.ColumnNameIterator;
import org.hibernate.envers.configuration.internal.metadata.QueryGeneratorBuilder;
import org.hibernate.envers.configuration.internal.metadata.ValueMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditJoinTableData;
import org.hibernate.envers.internal.EnversMessageLogger;
import org.hibernate.envers.internal.entities.EntityConfiguration;
import org.hibernate.envers.internal.entities.IdMappingData;
import org.hibernate.envers.internal.entities.mapper.relation.CommonCollectionMapperData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.internal.tools.MappingTools;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.jboss.logging.Logger;

public class MiddleTableCollectionMetadataGenerator
extends AbstractCollectionMetadataGenerator {
    private static final EnversMessageLogger LOG = (EnversMessageLogger)Logger.getMessageLogger(EnversMessageLogger.class, (String)MiddleTableCollectionMetadataGenerator.class.getName());

    public MiddleTableCollectionMetadataGenerator(EnversMetadataBuildingContext metadataBuildingContext, BasicMetadataGenerator basicMetadataGenerator, ValueMetadataGenerator valueMetadataGenerator) {
        super(metadataBuildingContext, basicMetadataGenerator, valueMetadataGenerator);
    }

    @Override
    public void addCollection(CollectionMetadataContext context) {
        String referencedPrefix;
        String referencingPrefixRelated;
        String mappedBy;
        String auditMiddleEntityName;
        String auditMiddleTableName;
        LOG.debugf("Adding audit mapping for property %s.%s: collection with a join table", context.getReferencingEntityName(), context.getPropertyName());
        if (!StringTools.isEmpty(context.getPropertyAuditingData().getJoinTable().getName())) {
            auditMiddleTableName = context.getPropertyAuditingData().getJoinTable().getName();
            auditMiddleEntityName = context.getPropertyAuditingData().getJoinTable().getName();
        } else {
            Configuration configuration = this.getMetadataBuildingContext().getConfiguration();
            String middleTableName = this.getMiddleTableName(context);
            auditMiddleTableName = configuration.getAuditTableName(null, middleTableName);
            auditMiddleEntityName = configuration.getAuditEntityName(middleTableName);
        }
        LOG.debugf("Using join table name: %s", auditMiddleTableName);
        RootPersistentEntity middleEntity = null;
        if (!context.getCollection().isInverse()) {
            AuditEntityNameRegister auditEntityNameRegistry = this.getMetadataBuildingContext().getAuditEntityNameRegistry();
            auditMiddleEntityName = auditEntityNameRegistry.createUnique(auditMiddleEntityName);
            auditEntityNameRegistry.register(auditMiddleEntityName);
            middleEntity = this.createMiddleEntity(context, auditMiddleTableName, auditMiddleEntityName);
        }
        EntityConfiguration referencingEntityConfiguration = context.getReferencingEntityConfiguration();
        IdMappingData referencingIdMapping = referencingEntityConfiguration.getIdMappingData();
        if (context.getCollection().isInverse()) {
            mappedBy = CollectionMappedByResolver.resolveMappedBy(context.getCollection().getCollectionTable(), this.getReferencedEntityMapping(context), context.getPropertyAuditingData());
            referencingPrefixRelated = mappedBy + "_";
            referencedPrefix = StringTools.getLastComponent(context.getReferencedEntityName());
        } else {
            mappedBy = null;
            referencingPrefixRelated = StringTools.getLastComponent(context.getReferencingEntityName()) + "_";
            referencedPrefix = context.getReferencedEntityName() == null ? "element" : context.getPropertyName();
        }
        MiddleIdData referencingIdData = this.createMiddleIdData(referencingIdMapping, referencingPrefixRelated, context.getReferencingEntityName());
        String orderBy = this.getOrderBy(context.getCollection());
        QueryGeneratorBuilder queryGeneratorBuilder = new QueryGeneratorBuilder(this.getMetadataBuildingContext().getConfiguration(), referencingIdData, auditMiddleEntityName, this.isRevisionTypeInId(context), this.getOrderByCollectionRole(context.getCollection(), orderBy));
        if (middleEntity != null) {
            this.addAttributesToEntity(middleEntity, this.getPrefixedIdAttributes(referencingPrefixRelated, ColumnNameIterator.from(context.getCollection().getKey().getColumnIterator()), referencingIdMapping));
        }
        MiddleComponentData elementComponentData = this.addValueToMiddleTable(context, context.getCollection().getElement(), middleEntity, queryGeneratorBuilder, referencedPrefix, context.getPropertyAuditingData().getJoinTable(), !this.isLobMapElementType(context));
        MiddleComponentData indexComponentData = this.addIndex(context, middleEntity, queryGeneratorBuilder);
        RelationQueryGenerator queryGenerator = queryGeneratorBuilder.build(elementComponentData, indexComponentData);
        CommonCollectionMapperData commonCollectionMapperData = this.createCommonCollectionMapperData(context, auditMiddleEntityName, referencingIdData, queryGenerator);
        this.addMapper(context, commonCollectionMapperData, elementComponentData, indexComponentData);
        this.storeMiddleEntityRelationInformation(context, mappedBy, referencingIdData, referencedPrefix, auditMiddleEntityName);
    }

    private String getMiddleTableName(CollectionMetadataContext context) {
        Collection collection = context.getCollection();
        if (collection.getElement() instanceof OneToMany && !collection.isInverse()) {
            String entityName = context.getReferencingEntityName();
            return StringTools.getLastComponent(entityName) + "_" + StringTools.getLastComponent(MappingTools.getReferencedEntityName(collection.getElement()));
        }
        CollectionAuditTable collectionAuditTable = context.getPropertyAuditingData().getCollectionAuditTable();
        if (collectionAuditTable != null) {
            return collectionAuditTable.name();
        }
        return collection.getCollectionTable().getName();
    }

    private RootPersistentEntity createMiddleEntity(CollectionMetadataContext context, String tableName, String entityName) {
        AuditTableData auditTableData = new AuditTableData(entityName, tableName, this.resolveSchema(context), this.resolveCatalog(context));
        RootPersistentEntity entity = new RootPersistentEntity(auditTableData, null);
        if (!context.isOneToManySingleTableSubclass()) {
            entity.setWhereClause(context.getCollection().getWhere());
        }
        CompositeIdentifier id = new CompositeIdentifier(this.getMetadataBuildingContext());
        entity.setIdentifier(id);
        this.addRevisionInfoRelationToIdentifier(id);
        boolean revisionTypeInId = this.isRevisionTypeInId(context);
        this.addRevisionTypeToAttributeContainer(revisionTypeInId ? id : entity, revisionTypeInId);
        this.addAuditStrategyAdditionalColumnsToEntity(entity);
        context.getEntityMappingData().addAdditionalMapping(entity);
        return entity;
    }

    private String resolveSchema(CollectionMetadataContext context) {
        CollectionAuditTable collectionAuditTable = context.getPropertyAuditingData().getCollectionAuditTable();
        if (collectionAuditTable != null && !StringTools.isEmpty(collectionAuditTable.schema())) {
            return collectionAuditTable.schema();
        }
        AuditJoinTableData joinTable = context.getPropertyAuditingData().getJoinTable();
        return this.getSchemaName(joinTable.getSchema(), context.getCollection().getCollectionTable());
    }

    private String resolveCatalog(CollectionMetadataContext context) {
        CollectionAuditTable collectionAuditTable = context.getPropertyAuditingData().getCollectionAuditTable();
        if (collectionAuditTable != null && !StringTools.isEmpty(collectionAuditTable.catalog())) {
            return collectionAuditTable.catalog();
        }
        AuditJoinTableData joinTable = context.getPropertyAuditingData().getJoinTable();
        return this.getCatalogName(joinTable.getCatalog(), context.getCollection().getCollectionTable());
    }

    private boolean isRevisionTypeInId(CollectionMetadataContext context) {
        return this.isEmbeddableElementType(context) || this.isLobMapElementType(context);
    }

    private PersistentClass getReferencedEntityMapping(CollectionMetadataContext context) {
        return this.getMetadataBuildingContext().getMetadataCollector().getEntityBinding(context.getReferencedEntityName());
    }

    private void storeMiddleEntityRelationInformation(CollectionMetadataContext context, String mappedBy, MiddleIdData referencingIdData, String referencedPrefix, String auditMiddleEntityName) {
        if (context.getReferencedEntityName() != null) {
            IdMappingData referencedIdMapping = this.getReferencedIdMappingData(context.getReferencingEntityName(), context.getReferencedEntityName(), context.getPropertyAuditingData(), true);
            MiddleIdData referencedIdData = this.createMiddleIdData(referencedIdMapping, referencedPrefix + "_", context.getReferencedEntityName());
            if (context.getCollection().isInverse()) {
                context.getReferencingEntityConfiguration().addToManyMiddleNotOwningRelation(context.getPropertyName(), mappedBy, context.getReferencedEntityName(), referencingIdData, referencedIdData, auditMiddleEntityName);
            } else {
                context.getReferencingEntityConfiguration().addToManyMiddleRelation(context.getPropertyName(), context.getReferencedEntityName(), referencingIdData, referencedIdData, auditMiddleEntityName);
            }
        } else {
            context.getReferencingEntityConfiguration().addToManyComponent(context.getPropertyName(), auditMiddleEntityName, referencingIdData);
        }
    }
}

