/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller.descriptions;

import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;

public class ChildResourceDescriptionResolver
implements ResourceDescriptionResolver {
    private final ResourceDescriptionResolver parent;
    private final String prefix;
    private final List<PathElement> paths;

    protected ChildResourceDescriptionResolver(ResourceDescriptionResolver parent, String prefix, List<PathElement> paths) {
        this.parent = parent;
        this.prefix = prefix;
        this.paths = paths;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return this.parent.getResourceBundle(locale);
    }

    public String getResourceAttributeDescription(String attributeName, Locale locale, ResourceBundle bundle) {
        Optional<MissingResourceException> exception = Optional.empty();
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, attributeName, new String[0]);
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException e) {
                if (!exception.isEmpty()) continue;
                exception = Optional.of(e);
            }
        }
        try {
            return this.parent.getResourceAttributeDescription(attributeName, locale, bundle);
        }
        catch (MissingResourceException e) {
            throw exception.orElse(e);
        }
    }

    public String getResourceAttributeValueTypeDescription(String attributeName, Locale locale, ResourceBundle bundle, String ... suffixes) {
        Optional<MissingResourceException> exception = Optional.empty();
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, attributeName, suffixes);
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException e) {
                if (!exception.isEmpty()) continue;
                exception = Optional.of(e);
            }
        }
        try {
            return this.parent.getResourceAttributeValueTypeDescription(attributeName, locale, bundle, suffixes);
        }
        catch (MissingResourceException e) {
            throw exception.orElse(e);
        }
    }

    public String getOperationDescription(String operationName, Locale locale, ResourceBundle bundle) {
        Optional<MissingResourceException> exception = Optional.empty();
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, operationName, new String[0]);
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException e) {
                if (!exception.isEmpty()) continue;
                exception = Optional.of(e);
            }
        }
        try {
            return this.parent.getOperationDescription(operationName, locale, bundle);
        }
        catch (MissingResourceException e) {
            throw exception.orElse(e);
        }
    }

    public String getOperationParameterDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle) {
        Optional<MissingResourceException> exception = Optional.empty();
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, operationName.equals("add") ? List.of(paramName) : List.of(operationName, paramName), new String[0]);
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException e) {
                if (!exception.isEmpty()) continue;
                exception = Optional.of(e);
            }
        }
        try {
            return this.parent.getOperationParameterDescription(operationName, paramName, locale, bundle);
        }
        catch (MissingResourceException e) {
            throw exception.orElse(e);
        }
    }

    public String getOperationParameterValueTypeDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle, String ... suffixes) {
        Optional<MissingResourceException> exception = Optional.empty();
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, operationName.equals("add") ? List.of(paramName) : List.of(operationName, paramName), suffixes);
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException e) {
                if (!exception.isEmpty()) continue;
                exception = Optional.of(e);
            }
        }
        try {
            return this.parent.getOperationParameterValueTypeDescription(operationName, paramName, locale, bundle, suffixes);
        }
        catch (MissingResourceException e) {
            throw exception.orElse(e);
        }
    }

    public String getOperationReplyDescription(String operationName, Locale locale, ResourceBundle bundle) {
        Optional<MissingResourceException> exception = Optional.empty();
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, List.of(operationName, "reply"), new String[0]);
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException e) {
                if (!exception.isEmpty()) continue;
                exception = Optional.of(e);
            }
        }
        try {
            return this.parent.getOperationReplyDescription(operationName, locale, bundle);
        }
        catch (MissingResourceException e) {
            throw exception.orElse(e);
        }
    }

    public String getOperationReplyValueTypeDescription(String operationName, Locale locale, ResourceBundle bundle, String ... suffixes) {
        Optional<MissingResourceException> exception = Optional.empty();
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, List.of(operationName, "reply"), suffixes);
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException e) {
                if (!exception.isEmpty()) continue;
                exception = Optional.of(e);
            }
        }
        try {
            return this.parent.getOperationReplyValueTypeDescription(operationName, locale, bundle, suffixes);
        }
        catch (MissingResourceException e) {
            throw exception.orElse(e);
        }
    }

    public String getNotificationDescription(String notificationType, Locale locale, ResourceBundle bundle) {
        Optional<MissingResourceException> exception = Optional.empty();
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, notificationType, new String[0]);
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException e) {
                if (!exception.isEmpty()) continue;
                exception = Optional.of(e);
            }
        }
        try {
            return this.parent.getNotificationDescription(notificationType, locale, bundle);
        }
        catch (MissingResourceException e) {
            throw exception.orElse(e);
        }
    }

    public String getChildTypeDescription(String childType, Locale locale, ResourceBundle bundle) {
        Optional<MissingResourceException> exception = Optional.empty();
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, childType, new String[0]);
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException e) {
                if (!exception.isEmpty()) continue;
                exception = Optional.of(e);
            }
        }
        try {
            return this.parent.getChildTypeDescription(childType, locale, bundle);
        }
        catch (MissingResourceException e) {
            throw exception.orElse(e);
        }
    }

    public String getResourceDescription(Locale locale, ResourceBundle bundle) {
        Optional<MissingResourceException> exception = Optional.empty();
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path);
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException e) {
                if (!exception.isEmpty()) continue;
                exception = Optional.of(e);
            }
        }
        try {
            return this.parent.getResourceDescription(locale, bundle);
        }
        catch (MissingResourceException e) {
            throw exception.orElse(e);
        }
    }

    public String getResourceDeprecatedDescription(Locale locale, ResourceBundle bundle) {
        Optional<MissingResourceException> exception = Optional.empty();
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, "deprecated", new String[0]);
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException e) {
                if (!exception.isEmpty()) continue;
                exception = Optional.of(e);
            }
        }
        try {
            return this.parent.getResourceDeprecatedDescription(locale, bundle);
        }
        catch (MissingResourceException e) {
            throw exception.orElse(e);
        }
    }

    public String getResourceAttributeDeprecatedDescription(String attributeName, Locale locale, ResourceBundle bundle) {
        Optional<MissingResourceException> exception = Optional.empty();
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, attributeName, "deprecated");
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException e) {
                if (!exception.isEmpty()) continue;
                exception = Optional.of(e);
            }
        }
        try {
            return this.parent.getResourceAttributeDeprecatedDescription(attributeName, locale, bundle);
        }
        catch (MissingResourceException e) {
            throw exception.orElse(e);
        }
    }

    public String getOperationDeprecatedDescription(String operationName, Locale locale, ResourceBundle bundle) {
        Optional<MissingResourceException> exception = Optional.empty();
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, operationName, "deprecated");
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException e) {
                if (!exception.isEmpty()) continue;
                exception = Optional.of(e);
            }
        }
        try {
            return this.parent.getOperationDeprecatedDescription(operationName, locale, bundle);
        }
        catch (MissingResourceException e) {
            throw exception.orElse(e);
        }
    }

    public String getOperationParameterDeprecatedDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle) {
        Optional<MissingResourceException> exception = Optional.empty();
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, operationName.equals("add") ? List.of(paramName) : List.of(operationName, paramName), "deprecated");
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException e) {
                if (!exception.isEmpty()) continue;
                exception = Optional.of(e);
            }
        }
        try {
            return this.parent.getOperationParameterDeprecatedDescription(operationName, paramName, locale, bundle);
        }
        catch (MissingResourceException e) {
            throw exception.orElse(e);
        }
    }

    private String getBundleKey(PathElement path) {
        return this.getBundleKey(path, List.of(), new String[0]);
    }

    private String getBundleKey(PathElement path, String key, String ... suffixes) {
        return this.getBundleKey(path, List.of(key), suffixes);
    }

    private String getBundleKey(PathElement path, List<String> keys, String ... suffixes) {
        StringBuilder builder = new StringBuilder(this.prefix);
        for (String value : path.isWildcard() ? List.of(path.getKey()) : List.of(path.getKey(), path.getValue())) {
            builder.append('.').append(value);
        }
        for (String key : keys) {
            builder.append('.').append(key);
        }
        for (String suffix : suffixes) {
            builder.append('.').append(suffix);
        }
        return builder.toString();
    }
}

