/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.docvalues.impl;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.MultiValueMode;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.ChildDocIds;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;

public abstract class TextMultiValuesToSingleValuesSource {
    protected final MultiValueMode mode;
    protected final NestedDocsProvider nestedDocsProvider;

    public static TextMultiValuesToSingleValuesSource fromField(String field, MultiValueMode mode, NestedDocsProvider nested) {
        return new FieldMultiValuesToSingleValuesSource(field, mode, nested);
    }

    public TextMultiValuesToSingleValuesSource(MultiValueMode mode, NestedDocsProvider nestedDocsProvider) {
        this.mode = mode;
        this.nestedDocsProvider = nestedDocsProvider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextMultiValuesToSingleValuesSource that = (TextMultiValuesToSingleValuesSource)o;
        return Objects.equals((Object)this.mode, (Object)that.mode) && Objects.equals(this.nestedDocsProvider, that.nestedDocsProvider);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.nestedDocsProvider});
    }

    public SortedDocValues getValues(LeafReaderContext ctx) throws IOException {
        SortedSetDocValues values = this.getSortedSetDocValues(ctx);
        if (this.nestedDocsProvider == null) {
            return this.select(values);
        }
        return this.select(values, this.nestedDocsProvider.childDocs(ctx, (DocIdSetIterator)values));
    }

    protected abstract SortedSetDocValues getSortedSetDocValues(LeafReaderContext var1) throws IOException;

    protected SortedDocValues select(final SortedSetDocValues values) {
        SortedDocValues singleton = DocValues.unwrapSingleton((SortedSetDocValues)values);
        if (singleton != null) {
            return singleton;
        }
        return new SortedSetDocValuesToSortedDocValuesWrapper(values){
            int docID;
            int lastEmittedOrd;
            {
                super(delegate);
                this.docID = -1;
                this.lastEmittedOrd = -1;
            }

            public int ordValue() {
                return this.lastEmittedOrd;
            }

            public int docID() {
                return this.docID;
            }

            public boolean advanceExact(int doc) throws IOException {
                if (values.advanceExact(doc)) {
                    this.lastEmittedOrd = (int)TextMultiValuesToSingleValuesSource.this.mode.pick(values);
                    this.docID = doc;
                    return true;
                }
                return false;
            }
        };
    }

    protected SortedDocValues select(final SortedSetDocValues values, final ChildDocIds childDocsWithValues) {
        if (childDocsWithValues == null) {
            return DocValues.emptySorted();
        }
        return new SortedSetDocValuesToSortedDocValuesWrapper(values){
            int lastSeenParentDoc;
            int lastEmittedOrd;
            {
                super(delegate);
                this.lastSeenParentDoc = -1;
                this.lastEmittedOrd = -1;
            }

            public int ordValue() {
                return this.lastEmittedOrd;
            }

            public int docID() {
                return this.lastSeenParentDoc;
            }

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming parent docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return true;
                }
                if (!childDocsWithValues.advanceExactParent(parentDoc)) {
                    return false;
                }
                this.lastSeenParentDoc = parentDoc;
                this.lastEmittedOrd = (int)TextMultiValuesToSingleValuesSource.this.mode.pick(values, childDocsWithValues);
                return true;
            }
        };
    }

    private static abstract class SortedSetDocValuesToSortedDocValuesWrapper
    extends SortedDocValues {
        private final SortedSetDocValues delegate;

        SortedSetDocValuesToSortedDocValuesWrapper(SortedSetDocValues delegate) {
            this.delegate = delegate;
            if (delegate.getValueCount() > Integer.MAX_VALUE) {
                throw new IllegalStateException("Cannot sort when more than 2147483647 terms are indexed");
            }
        }

        public int getValueCount() {
            return (int)this.delegate.getValueCount();
        }

        public BytesRef lookupOrd(int ord) throws IOException {
            return this.delegate.lookupOrd((long)ord);
        }

        public int nextDoc() {
            throw new UnsupportedOperationException();
        }

        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        public long cost() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FieldMultiValuesToSingleValuesSource
    extends TextMultiValuesToSingleValuesSource {
        private final String field;

        public FieldMultiValuesToSingleValuesSource(String field, MultiValueMode mode, NestedDocsProvider nestedDocsProvider) {
            super(mode, nestedDocsProvider);
            this.field = field;
        }

        public String toString() {
            return "text(" + this.field + "," + (Object)((Object)this.mode) + "," + this.nestedDocsProvider + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!super.equals(o)) {
                return false;
            }
            FieldMultiValuesToSingleValuesSource that = (FieldMultiValuesToSingleValuesSource)o;
            return Objects.equals(this.field, that.field);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.field);
        }

        @Override
        protected SortedSetDocValues getSortedSetDocValues(LeafReaderContext ctx) throws IOException {
            return DocValues.getSortedSet((LeafReader)ctx.reader(), (String)this.field);
        }
    }
}

