/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.ExternalContextFactoryImpl;
import com.sun.faces.context.FacesContextImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.FacesContextFactory;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.servlet.ServletRequest;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InjectionFacesContextFactory
extends FacesContextFactory {
    private static final Logger LOGGER = FacesLogger.CONTEXT.getLogger();
    private Field defaultFacesContext;
    private Field defaultExternalContext;

    public InjectionFacesContextFactory(FacesContextFactory delegate) {
        super(delegate);
        Util.notNull("facesContextFactory", delegate);
        try {
            this.defaultFacesContext = FacesContext.class.getDeclaredField("defaultFacesContext");
            this.defaultFacesContext.setAccessible(true);
        }
        catch (NoSuchFieldException nsfe) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to find private field named 'defaultFacesContext' in jakarta.faces.context.FacesContext.");
            }
        }
        catch (SecurityException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
            this.defaultFacesContext = null;
        }
        try {
            this.defaultExternalContext = ExternalContext.class.getDeclaredField("defaultExternalContext");
            this.defaultExternalContext.setAccessible(true);
        }
        catch (NoSuchFieldException nsfe) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to find private field named 'defaultExternalContext' in jakarta.faces.context.ExternalContext.");
            }
        }
        catch (SecurityException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
            this.defaultExternalContext = null;
        }
    }

    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) throws FacesException {
        FacesContext ctx = this.getWrapped().getFacesContext(context, request, response, lifecycle);
        if (ctx == null) {
            String message = MessageFormat.format("Delegate FacesContextFactory, {0}, returned null when calling getFacesContext().", this.getWrapped().getClass().getName());
            throw new IllegalStateException(message);
        }
        this.injectDefaults(ctx, request);
        return ctx;
    }

    private void injectDefaults(FacesContext target, Object request) {
        block9: {
            block8: {
                FacesContext defaultFC;
                if (this.defaultFacesContext != null && (defaultFC = FacesContextImpl.getDefaultFacesContext()) != null) {
                    try {
                        this.defaultFacesContext.set(target, defaultFC);
                    }
                    catch (IllegalAccessException e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block8;
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                    }
                }
            }
            if (this.defaultExternalContext != null) {
                ServletRequest reqObj;
                ExternalContext defaultExtContext = null;
                if (request instanceof ServletRequest && (defaultExtContext = (ExternalContext)(reqObj = (ServletRequest)request).getAttribute(ExternalContextFactoryImpl.DEFAULT_EXTERNAL_CONTEXT_KEY)) != null) {
                    reqObj.removeAttribute(ExternalContextFactoryImpl.DEFAULT_EXTERNAL_CONTEXT_KEY);
                }
                if (defaultExtContext != null) {
                    try {
                        this.defaultExternalContext.set(target.getExternalContext(), defaultExtContext);
                    }
                    catch (IllegalAccessException e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block9;
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                    }
                }
            }
        }
    }
}

