/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.resource.definition;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.glassfish.enterprise.concurrent.AbstractManagedExecutorService;
import org.glassfish.enterprise.concurrent.ManagedExecutorServiceAdapter;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.concurrent.ContextServiceImpl;
import org.jboss.as.ee.concurrent.service.ConcurrentServiceNames;
import org.jboss.as.ee.concurrent.service.ManagedExecutorServiceService;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.ee.subsystem.ManagedExecutorServiceResourceDefinition;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.msc.Service;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.common.cpu.ProcessorInfo;
import org.wildfly.extension.requestcontroller.RequestController;

public class ManagedExecutorDefinitionInjectionSource
extends ResourceDefinitionInjectionSource {
    public static final String CONTEXT_PROP = "context";
    public static final String HUNG_TASK_THRESHOLD_PROP = "hungTaskThreshold";
    public static final String MAX_ASYNC_PROP = "maxAsync";
    private static final String REQUEST_CONTROLLER_CAPABILITY_NAME = "org.wildfly.request-controller";
    private String contextServiceRef;
    private long hungTaskThreshold;
    private int maxAsync = ProcessorInfo.availableProcessors() * 2;
    private int hungTaskTerminationPeriod = 0;
    private boolean longRunningTasks = false;
    private long keepAliveTime = 60000L;
    private TimeUnit keepAliveTimeUnit = TimeUnit.MILLISECONDS;
    private long threadLifeTime = 0L;
    private int queueLength = Integer.MAX_VALUE;
    private AbstractManagedExecutorService.RejectPolicy rejectPolicy = AbstractManagedExecutorService.RejectPolicy.ABORT;
    private int threadPriority = 5;

    public ManagedExecutorDefinitionInjectionSource(String jndiName) {
        super(jndiName);
    }

    @Override
    public void getResourceValue(InjectionSource.ResolutionContext context, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, final Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        String resourceName = this.uniqueName(context);
        String resourceJndiName = "java:jboss/ee/concurrency/definition/managedExecutor/" + resourceName;
        CapabilityServiceSupport capabilityServiceSupport = (CapabilityServiceSupport)phaseContext.getDeploymentUnit().getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        try {
            ServiceName resourceServiceName = ManagedExecutorServiceResourceDefinition.CAPABILITY.getCapabilityServiceName(new String[]{resourceName});
            ServiceBuilder resourceServiceBuilder = phaseContext.getServiceTarget().addService(resourceServiceName);
            Supplier hungTasksPeriodicTerminationService = resourceServiceBuilder.requires(ConcurrentServiceNames.HUNG_TASK_PERIODIC_TERMINATION_SERVICE_NAME);
            final ManagedExecutorServiceService resourceService = new ManagedExecutorServiceService(resourceName, resourceJndiName, this.hungTaskThreshold, this.hungTaskTerminationPeriod, this.longRunningTasks, this.maxAsync, this.maxAsync, this.keepAliveTime, this.keepAliveTimeUnit, this.threadLifeTime, this.queueLength, this.rejectPolicy, this.threadPriority, hungTasksPeriodicTerminationService);
            resourceServiceBuilder.setInstance((Service)resourceService);
            String contextServiceRef = this.contextServiceRef == null || this.contextServiceRef.isEmpty() ? "java:comp/DefaultContextService" : this.contextServiceRef;
            ContextNames.BindInfo contextServiceBindInfo = ContextNames.bindInfoForEnvEntry((String)context.getApplicationName(), (String)context.getModuleName(), (String)context.getComponentName(), (!context.isCompUsesModule() ? 1 : 0) != 0, (String)contextServiceRef);
            Injector<ManagedReferenceFactory> contextServiceLookupInjector = new Injector<ManagedReferenceFactory>(){

                public void inject(ManagedReferenceFactory value) throws InjectionException {
                    resourceService.getContextServiceInjector().inject((Object)((ContextServiceImpl)((Object)value.getReference().getInstance())));
                }

                public void uninject() {
                    resourceService.getContextServiceInjector().uninject();
                }
            };
            contextServiceBindInfo.setupLookupInjection(resourceServiceBuilder, (Injector)contextServiceLookupInjector, phaseContext.getDeploymentUnit(), false);
            if (capabilityServiceSupport.hasCapability(REQUEST_CONTROLLER_CAPABILITY_NAME)) {
                resourceServiceBuilder.addDependency(capabilityServiceSupport.getCapabilityServiceName(REQUEST_CONTROLLER_CAPABILITY_NAME), RequestController.class, resourceService.getRequestController());
            }
            resourceServiceBuilder.install();
            serviceBuilder.addDependency(resourceServiceName, ManagedExecutorServiceAdapter.class, (Injector)new Injector<ManagedExecutorServiceAdapter>(){

                public void inject(final ManagedExecutorServiceAdapter resource) throws InjectionException {
                    injector.inject(() -> new ManagedReference(){

                        public void release() {
                        }

                        public Object getInstance() {
                            return resource;
                        }
                    });
                }

                public void uninject() {
                    injector.uninject();
                }
            });
        }
        catch (Exception e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    public String getContextServiceRef() {
        return this.contextServiceRef;
    }

    public void setContextServiceRef(String contextServiceRef) {
        this.contextServiceRef = contextServiceRef;
    }

    public long getHungTaskThreshold() {
        return this.hungTaskThreshold;
    }

    public void setHungTaskThreshold(long hungTaskThreshold) {
        this.hungTaskThreshold = hungTaskThreshold;
    }

    public int getMaxAsync() {
        return this.maxAsync;
    }

    public void setMaxAsync(int maxAsync) {
        if (maxAsync > 0) {
            this.maxAsync = maxAsync;
        }
    }

    public int getHungTaskTerminationPeriod() {
        return this.hungTaskTerminationPeriod;
    }

    public void setHungTaskTerminationPeriod(int hungTaskTerminationPeriod) {
        this.hungTaskTerminationPeriod = hungTaskTerminationPeriod;
    }

    public boolean isLongRunningTasks() {
        return this.longRunningTasks;
    }

    public void setLongRunningTasks(boolean longRunningTasks) {
        this.longRunningTasks = longRunningTasks;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public TimeUnit getKeepAliveTimeUnit() {
        return this.keepAliveTimeUnit;
    }

    public void setKeepAliveTimeUnit(TimeUnit keepAliveTimeUnit) {
        this.keepAliveTimeUnit = keepAliveTimeUnit;
    }

    public long getThreadLifeTime() {
        return this.threadLifeTime;
    }

    public void setThreadLifeTime(long threadLifeTime) {
        this.threadLifeTime = threadLifeTime;
    }

    public int getQueueLength() {
        return this.queueLength;
    }

    public void setQueueLength(int queueLength) {
        this.queueLength = queueLength;
    }

    public AbstractManagedExecutorService.RejectPolicy getRejectPolicy() {
        return this.rejectPolicy;
    }

    public void setRejectPolicy(AbstractManagedExecutorService.RejectPolicy rejectPolicy) {
        this.rejectPolicy = rejectPolicy;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }
}

