/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.CapabilityProvider;
import org.jboss.as.clustering.controller.ResourceDefinitionProvider;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceServiceConfiguratorFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleAttribute;
import org.jboss.as.clustering.controller.SimpleResourceRegistration;
import org.jboss.as.clustering.controller.SimpleResourceServiceHandler;
import org.jboss.as.clustering.controller.validation.IntRangeValidatorBuilder;
import org.jboss.as.clustering.controller.validation.LongRangeValidatorBuilder;
import org.jboss.as.clustering.controller.validation.ParameterValidatorBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.remote.ClientThreadPoolServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheContainerResourceDefinition;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;

public enum ThreadPoolResourceDefinition implements ResourceDefinitionProvider,
ThreadPoolDefinition,
ResourceServiceConfiguratorFactory,
UnaryOperator<SimpleResourceDefinition.Parameters>
{
    BLOCKING("blocking", 1, 150, 5000, TimeUnit.MINUTES.toMillis(1L), false, CacheContainerResourceDefinition.Capability.CONFIGURATION),
    LISTENER("listener", 1, 1, 1000, TimeUnit.MINUTES.toMillis(1L), false, CacheContainerResourceDefinition.Capability.CONFIGURATION),
    NON_BLOCKING("non-blocking", 2, 2, 1000, TimeUnit.MINUTES.toMillis(1L), true, CacheContainerResourceDefinition.Capability.CONFIGURATION),
    CLIENT("async", 99, 99, 0, 0L, true, RemoteCacheContainerResourceDefinition.Capability.CONFIGURATION){

        @Override
        public ResourceServiceConfigurator createServiceConfigurator(PathAddress address) {
            return new ClientThreadPoolServiceConfigurator(this, address);
        }
    };

    static final PathElement WILDCARD_PATH;
    private final PathElement path;
    private final Attribute minThreads;
    private final Attribute maxThreads;
    private final Attribute queueLength;
    private final Attribute keepAliveTime;
    private final boolean nonBlocking;
    private final CapabilityProvider baseCapability;

    private static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"thread-pool", (String)name);
    }

    private ThreadPoolResourceDefinition(String name, int defaultMinThreads, int defaultMaxThreads, int defaultQueueLength, long defaultKeepaliveTime, boolean nonBlocking, CapabilityProvider baseCapability) {
        this.path = ThreadPoolResourceDefinition.pathElement(name);
        this.minThreads = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("min-threads", ModelType.INT, new ModelNode(defaultMinThreads), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0)).build());
        this.maxThreads = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("max-threads", ModelType.INT, new ModelNode(defaultMaxThreads), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0)).build());
        this.queueLength = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("queue-length", ModelType.INT, new ModelNode(defaultQueueLength), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0)).build());
        this.keepAliveTime = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("keepalive-time", ModelType.LONG, new ModelNode(defaultKeepaliveTime), (ParameterValidatorBuilder)new LongRangeValidatorBuilder().min(0L)).build());
        this.nonBlocking = nonBlocking;
        this.baseCapability = baseCapability;
    }

    private static SimpleAttributeDefinitionBuilder createBuilder(String name, ModelType type, ModelNode defaultValue, ParameterValidatorBuilder validatorBuilder) {
        SimpleAttributeDefinitionBuilder builder = (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setMeasurementUnit((MeasurementUnit)(type == ModelType.LONG ? MeasurementUnit.MILLISECONDS : null));
        return (SimpleAttributeDefinitionBuilder)builder.setValidator(validatorBuilder.configure((AbstractAttributeDefinitionBuilder)builder).build());
    }

    @Override
    public SimpleResourceDefinition.Parameters apply(SimpleResourceDefinition.Parameters parameters) {
        return parameters;
    }

    public void register(ManagementResourceRegistration parent) {
        ResourceDescriptionResolver resolver = InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{this.path, ThreadPoolResourceDefinition.pathElement("*")});
        SimpleResourceDefinition definition = new SimpleResourceDefinition(this.apply(new SimpleResourceDefinition.Parameters(this.path, resolver)));
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)definition);
        ResourceDescriptor descriptor = new ResourceDescriptor(resolver).addAttributes(new Attribute[]{this.minThreads, this.maxThreads, this.queueLength, this.keepAliveTime});
        SimpleResourceServiceHandler handler = new SimpleResourceServiceHandler((ResourceServiceConfiguratorFactory)this);
        new SimpleResourceRegistration(descriptor, (ResourceServiceHandler)handler).register(registration);
    }

    public ResourceServiceConfigurator createServiceConfigurator(PathAddress address) {
        return new ThreadPoolServiceConfigurator(this, address);
    }

    public ServiceName getServiceName(PathAddress containerAddress) {
        return this.baseCapability.getServiceName(containerAddress).append(this.path.getKeyValuePair());
    }

    @Override
    public Attribute getMinThreads() {
        return this.minThreads;
    }

    @Override
    public Attribute getMaxThreads() {
        return this.maxThreads;
    }

    @Override
    public Attribute getQueueLength() {
        return this.queueLength;
    }

    @Override
    public Attribute getKeepAliveTime() {
        return this.keepAliveTime;
    }

    @Override
    public boolean isNonBlocking() {
        return this.nonBlocking;
    }

    public PathElement getPathElement() {
        return this.path;
    }

    static {
        WILDCARD_PATH = ThreadPoolResourceDefinition.pathElement("*");
    }
}

