/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.impl;

import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.SearchException;

public final class Throwables {
    private Throwables() {
    }

    public static RuntimeException toRuntimeException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable == null) {
            throw new AssertionFailure("Null throwable");
        }
        return new SearchException(throwable.getMessage(), throwable);
    }

    public static Exception expectException(Throwable throwable) {
        if (throwable instanceof Exception) {
            return (Exception)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable == null) {
            throw new AssertionFailure("Null throwable");
        }
        throw new AssertionFailure("Unexpected throwable type", throwable);
    }

    public static <T extends Throwable> T combine(T throwable, T otherThrowable) {
        T toThrow = throwable;
        if (otherThrowable != null) {
            if (toThrow != null) {
                toThrow.addSuppressed(otherThrowable);
            } else {
                toThrow = otherThrowable;
            }
        }
        return toThrow;
    }

    public static String getFirstNonNullMessage(Throwable t) {
        Throwable cause = t.getCause();
        while (t.getMessage() == null && cause != null) {
            t = cause;
            cause = t.getCause();
        }
        return t.getMessage();
    }

    public static String safeToString(Throwable throwableBeingHandled, Object object) {
        if (object == null) {
            return "null";
        }
        try {
            return object.toString();
        }
        catch (Throwable t) {
            throwableBeingHandled.addSuppressed(t);
            return "<" + object.getClass().getSimpleName() + "#toString() threw " + t.getClass().getSimpleName() + ">";
        }
    }
}

