/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import jakarta.persistence.OrderColumn;
import java.util.Map;
import org.hibernate.annotations.ListIndexBase;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.AnnotatedColumn;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.mapping.Join;

public class IndexColumn
extends AnnotatedColumn {
    private int base;

    public IndexColumn(boolean isImplicit, String sqlType, long length, int precision, int scale, String name, boolean nullable, boolean unique, boolean insertable, boolean updatable, String secondaryTableName, Map<String, Join> joins, PropertyHolder propertyHolder, MetadataBuildingContext buildingContext) {
        this.setImplicit(isImplicit);
        this.setSqlType(sqlType);
        this.setLength(length);
        this.setPrecision(precision);
        this.setScale(scale);
        this.setLogicalColumnName(name);
        this.setNullable(nullable);
        this.setUnique(unique);
        this.setInsertable(insertable);
        this.setUpdatable(updatable);
        this.setExplicitTableName(secondaryTableName);
        this.setPropertyHolder(propertyHolder);
        this.setJoins(joins);
        this.setBuildingContext(buildingContext);
        this.bind();
    }

    public static IndexColumn fromAnnotations(OrderColumn jpaAnnotation, org.hibernate.annotations.IndexColumn hibAnnotation, ListIndexBase indexBaseAnnotation, PropertyHolder propertyHolder, PropertyData inferredData, Map<String, Join> secondaryTables, MetadataBuildingContext context) {
        IndexColumn indexColumn;
        if (jpaAnnotation != null) {
            indexColumn = IndexColumn.buildColumnFromAnnotation(jpaAnnotation, propertyHolder, inferredData, secondaryTables, context);
        } else if (hibAnnotation != null) {
            indexColumn = IndexColumn.buildColumnFromAnnotation(hibAnnotation, propertyHolder, inferredData, context);
            indexColumn.setBase(hibAnnotation.base());
        } else {
            indexColumn = new IndexColumn(true, null, 0L, 0, 0, inferredData.getPropertyName() + "_ORDER", true, false, true, true, null, null, propertyHolder, context);
        }
        if (indexBaseAnnotation != null) {
            indexColumn.setBase(indexBaseAnnotation.value());
        }
        return indexColumn;
    }

    public int getBase() {
        return this.base;
    }

    public void setBase(int base) {
        this.base = base;
    }

    public static IndexColumn buildColumnFromAnnotation(OrderColumn ann, PropertyHolder propertyHolder, PropertyData inferredData, Map<String, Join> secondaryTables, MetadataBuildingContext buildingContext) {
        IndexColumn column;
        if (ann != null) {
            String sqlType = BinderHelper.isEmptyAnnotationValue(ann.columnDefinition()) ? null : ann.columnDefinition();
            Object name = BinderHelper.isEmptyAnnotationValue(ann.name()) ? inferredData.getPropertyName() + "_ORDER" : ann.name();
            column = new IndexColumn(false, sqlType, 0L, 0, 0, (String)name, ann.nullable(), false, ann.insertable(), ann.updatable(), null, secondaryTables, propertyHolder, buildingContext);
        } else {
            column = new IndexColumn(true, null, 0L, 0, 0, null, true, false, true, true, null, null, propertyHolder, buildingContext);
        }
        return column;
    }

    public static IndexColumn buildColumnFromAnnotation(org.hibernate.annotations.IndexColumn ann, PropertyHolder propertyHolder, PropertyData inferredData, MetadataBuildingContext buildingContext) {
        IndexColumn column;
        if (ann != null) {
            String sqlType = BinderHelper.isEmptyAnnotationValue(ann.columnDefinition()) ? null : ann.columnDefinition();
            String name = BinderHelper.isEmptyAnnotationValue(ann.name()) ? inferredData.getPropertyName() : ann.name();
            column = new IndexColumn(false, sqlType, 0L, 0, 0, name, ann.nullable(), false, true, true, null, null, propertyHolder, buildingContext);
            column.setBase(ann.base());
        } else {
            column = new IndexColumn(true, null, 0L, 0, 0, null, true, false, true, true, null, null, propertyHolder, buildingContext);
        }
        return column;
    }
}

