/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.SpannerDialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.tool.schema.spi.Exporter;

class SpannerDialectTableExporter
implements Exporter<Table> {
    private final SpannerDialect spannerDialect;
    private final String createTableTemplate;

    public SpannerDialectTableExporter(SpannerDialect spannerDialect) {
        this.spannerDialect = spannerDialect;
        this.createTableTemplate = this.spannerDialect.getCreateTableString() + " {0} ({1}) PRIMARY KEY ({2})";
    }

    @Override
    public String[] getSqlCreateStrings(Table table, Metadata metadata, SqlStringGenerationContext context) {
        Collection<Column> keyColumns = table.hasPrimaryKey() ? table.getPrimaryKey().getColumns() : (table.getForeignKeys().size() > 0 ? table.getColumns() : Collections.emptyList());
        return this.getTableString(table, metadata, keyColumns, context);
    }

    private String[] getTableString(Table table, Metadata metadata, Iterable<Column> keyColumns, SqlStringGenerationContext context) {
        String primaryKeyColNames = StreamSupport.stream(keyColumns.spliterator(), false).map(Column::getName).collect(Collectors.joining(","));
        StringJoiner colsAndTypes = new StringJoiner(",");
        for (Column column : table.getColumns()) {
            String sqlType = column.getSqlType(metadata.getDatabase().getTypeConfiguration(), this.spannerDialect, metadata);
            String columnDeclaration = column.getName() + " " + sqlType + (column.isNullable() ? this.spannerDialect.getNullColumnString(sqlType) : " not null");
            colsAndTypes.add(columnDeclaration);
        }
        ArrayList<String> statements = new ArrayList<String>();
        statements.add(MessageFormat.format(this.createTableTemplate, context.format(table.getQualifiedTableName()), colsAndTypes.toString(), primaryKeyColNames));
        return statements.toArray(new String[0]);
    }

    @Override
    public String[] getSqlDropStrings(Table table, Metadata metadata, SqlStringGenerationContext context) {
        ArrayList<Object> dropStrings = new ArrayList<Object>();
        Iterator<Index> index = table.getIndexIterator();
        while (index.hasNext()) {
            dropStrings.add("drop index " + index.next().getName());
        }
        dropStrings.add(this.spannerDialect.getDropTableString(context.format(table.getQualifiedTableName())));
        return dropStrings.toArray(new String[0]);
    }
}

