/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.Collections;
import java.util.List;
import org.hibernate.Incubating;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.query.sqm.CastType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public interface JdbcMapping
extends MappingType,
JdbcMappingContainer {
    public JavaType getJavaTypeDescriptor();

    public JdbcType getJdbcType();

    default public CastType getCastType() {
        return this.getJdbcType().getCastType();
    }

    public ValueExtractor<?> getJdbcValueExtractor();

    public ValueBinder getJdbcValueBinder();

    @Incubating
    default public JdbcLiteralFormatter getJdbcLiteralFormatter() {
        return this.getJdbcType().getJdbcLiteralFormatter(this.getMappedJavaType());
    }

    @Override
    default public JavaType<?> getMappedJavaType() {
        return this.getJavaTypeDescriptor();
    }

    @Incubating
    default public JavaType<?> getJdbcJavaType() {
        return this.getJavaTypeDescriptor();
    }

    @Incubating
    default public BasicValueConverter getValueConverter() {
        return null;
    }

    @Override
    default public int getJdbcTypeCount() {
        return 1;
    }

    @Override
    default public List<JdbcMapping> getJdbcMappings() {
        return Collections.singletonList(this);
    }

    @Override
    default public int forEachJdbcType(IndexedConsumer<JdbcMapping> action) {
        action.accept(0, this);
        return 1;
    }

    @Override
    default public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(0, this);
        return 1;
    }
}

