/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Type;
import org.hibernate.metamodel.model.domain.AnyMappingDomainType;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.model.domain.internal.AnyDiscriminatorConverter;
import org.hibernate.type.AnyType;
import org.hibernate.type.BasicType;
import org.hibernate.type.MetaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.internal.ConvertedBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;

public class AnyMappingDomainTypeImpl
implements AnyMappingDomainType<Class> {
    private final AnyType anyType;
    private final JavaType<Class> baseJtd;
    private final BasicType<Class> anyDiscriminatorType;

    public AnyMappingDomainTypeImpl(AnyType anyType, JavaType<Class> baseJtd, TypeConfiguration typeConfiguration) {
        this.anyType = anyType;
        this.baseJtd = baseJtd;
        MetaType discriminatorType = (MetaType)anyType.getDiscriminatorType();
        BasicType discriminatorBasicType = (BasicType)discriminatorType.getBaseType();
        this.anyDiscriminatorType = new ConvertedBasicTypeImpl<Class>(null, discriminatorBasicType.getJdbcType(), new AnyDiscriminatorConverter(discriminatorType, discriminatorBasicType, typeConfiguration));
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.ENTITY;
    }

    public Class<Class> getJavaType() {
        return this.anyType.getReturnedClass();
    }

    @Override
    public JavaType<Class> getExpressibleJavaType() {
        return this.baseJtd;
    }

    @Override
    public BasicType<Class> getDiscriminatorType() {
        return this.anyDiscriminatorType;
    }

    @Override
    public SimpleDomainType getKeyType() {
        return (BasicType)this.anyType.getIdentifierType();
    }
}

