/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableColumn;
import org.hibernate.dialect.temptable.TemporaryTableSessionUidColumn;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.OptimizableGenerator;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.mutation.internal.InsertHandler;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.SqmInsertStrategyHelper;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.InsertExecutionDelegate;
import org.hibernate.query.sqm.sql.BaseSqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.Assignable;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.BasicType;
import org.jboss.logging.Logger;

public class TableBasedInsertHandler
implements InsertHandler {
    private static final Logger log = Logger.getLogger(TableBasedInsertHandler.class);
    private final SqmInsertStatement<?> sqmInsertStatement;
    private final SessionFactoryImplementor sessionFactory;
    private final TemporaryTable entityTable;
    private final AfterUseAction afterUseAction;
    private final Function<SharedSessionContractImplementor, String> sessionUidAccess;
    private final DomainParameterXref domainParameterXref;
    private final JdbcParameter sessionUidParameter;
    private final EntityPersister entityDescriptor;

    TableBasedInsertHandler(SqmInsertStatement<?> sqmInsert, DomainParameterXref domainParameterXref, TemporaryTable entityTable, AfterUseAction afterUseAction, Function<SharedSessionContractImplementor, String> sessionUidAccess, SessionFactoryImplementor sessionFactory) {
        this.sqmInsertStatement = sqmInsert;
        this.afterUseAction = afterUseAction;
        this.sessionFactory = sessionFactory;
        this.entityTable = entityTable;
        this.sessionUidAccess = sessionUidAccess;
        this.domainParameterXref = domainParameterXref;
        String targetEntityName = ((SqmRoot)sqmInsert.getTarget()).getEntityName();
        this.entityDescriptor = sessionFactory.getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(targetEntityName);
        TemporaryTableSessionUidColumn sessionUidColumn = entityTable.getSessionUidColumn();
        this.sessionUidParameter = sessionUidColumn == null ? null : new JdbcParameterImpl(sessionUidColumn.getJdbcMapping());
    }

    public SqmInsertStatement<?> getSqmInsertStatement() {
        return this.sqmInsertStatement;
    }

    @Override
    public int execute(DomainQueryExecutionContext executionContext) {
        if (log.isTraceEnabled()) {
            log.tracef("Starting multi-table insert execution - %s", (Object)((SqmRoot)this.getSqmInsertStatement().getTarget()).getModel().getName());
        }
        SqmJdbcExecutionContextAdapter executionContextAdapter = SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(executionContext);
        return this.resolveDelegate(executionContext).execute(executionContextAdapter);
    }

    private ExecutionDelegate resolveDelegate(DomainQueryExecutionContext executionContext) {
        EntityPersister entityDescriptor = this.sessionFactory.getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(((SqmRoot)this.getSqmInsertStatement().getTarget()).getEntityName());
        MultiTableSqmMutationConverter converterDelegate = new MultiTableSqmMutationConverter(entityDescriptor, (SqmStatement<?>)this.getSqmInsertStatement(), (SqmRoot<?>)this.getSqmInsertStatement().getTarget(), this.domainParameterXref, executionContext.getQueryOptions(), executionContext.getSession().getLoadQueryInfluencers(), executionContext.getQueryParameterBindings(), this.sessionFactory);
        TableGroup insertingTableGroup = converterDelegate.getMutatingTableGroup();
        Map<SqmParameter<Object>, List<List<JdbcParameter>>> parameterResolutions = this.domainParameterXref.getSqmParameterCount() == 0 ? Collections.emptyMap() : new IdentityHashMap();
        ArrayList<Assignment> targetPathColumns = new ArrayList<Assignment>();
        LinkedHashMap paramTypeResolutions = new LinkedHashMap();
        NamedTableReference entityTableReference = new NamedTableReference(this.entityTable.getTableExpression(), "temptable_", true, this.sessionFactory);
        InsertStatement insertStatement = new InsertStatement(entityTableReference);
        BaseSqmToSqlAstConverter.AdditionalInsertValues additionalInsertValues = converterDelegate.visitInsertionTargetPaths((assigable, columnReferences) -> {
            insertStatement.addTargetColumnReferences((List<ColumnReference>)columnReferences);
            targetPathColumns.add(new Assignment((Assignable)assigable, (Expression)((Object)assigable)));
        }, this.sqmInsertStatement, entityDescriptor, insertingTableGroup, (sqmParameter, mappingType, jdbcParameters) -> {
            parameterResolutions.computeIfAbsent(sqmParameter, k -> new ArrayList(1)).add(jdbcParameters);
            paramTypeResolutions.put(sqmParameter, mappingType);
        });
        TemporaryTableSessionUidColumn sessionUidColumn = this.entityTable.getSessionUidColumn();
        if (this.sqmInsertStatement instanceof SqmInsertSelectStatement) {
            Object queryPart = converterDelegate.visitQueryPart((SqmQueryPart)((SqmInsertSelectStatement)this.sqmInsertStatement).getSelectQueryPart());
            ((QueryPart)queryPart).visitQuerySpecs(querySpec -> {
                Optimizer optimizer;
                if (additionalInsertValues.applySelections((QuerySpec)querySpec, this.sessionFactory)) {
                    TemporaryTableColumn rowNumberColumn = this.entityTable.getColumns().get(this.entityTable.getColumns().size() - (sessionUidColumn == null ? 1 : 2));
                    ColumnReference columnReference = new ColumnReference((String)null, rowNumberColumn.getColumnName(), false, null, null, rowNumberColumn.getJdbcMapping(), this.sessionFactory);
                    insertStatement.getTargetColumnReferences().set(insertStatement.getTargetColumnReferences().size() - 1, columnReference);
                    targetPathColumns.set(targetPathColumns.size() - 1, new Assignment(columnReference, columnReference));
                } else if (entityDescriptor.getIdentifierGenerator() instanceof OptimizableGenerator && (optimizer = ((OptimizableGenerator)entityDescriptor.getIdentifierGenerator()).getOptimizer()) != null && optimizer.getIncrementSize() > 1) {
                    if (!this.sessionFactory.getJdbcServices().getDialect().supportsWindowFunctions()) {
                        return;
                    }
                    TemporaryTableColumn rowNumberColumn = this.entityTable.getColumns().get(this.entityTable.getColumns().size() - (sessionUidColumn == null ? 1 : 2));
                    ColumnReference columnReference = new ColumnReference((String)null, rowNumberColumn.getColumnName(), false, null, null, rowNumberColumn.getJdbcMapping(), this.sessionFactory);
                    insertStatement.getTargetColumnReferences().add(columnReference);
                    targetPathColumns.add(new Assignment(columnReference, columnReference));
                    querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, SqmInsertStrategyHelper.createRowNumberingExpression(querySpec, this.sessionFactory)));
                }
                if (sessionUidColumn != null) {
                    ColumnReference sessionUidColumnReference = new ColumnReference((String)null, sessionUidColumn.getColumnName(), false, null, null, sessionUidColumn.getJdbcMapping(), this.sessionFactory);
                    insertStatement.getTargetColumnReferences().add(sessionUidColumnReference);
                    targetPathColumns.add(new Assignment(sessionUidColumnReference, this.sessionUidParameter));
                    querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(insertStatement.getTargetColumnReferences().size(), insertStatement.getTargetColumnReferences().size() - 1, this.sessionUidParameter));
                }
            });
            insertStatement.setSourceSelectStatement((QueryPart)queryPart);
        } else {
            BasicType rowNumberType;
            IdentifierGenerator generator = entityDescriptor.getIdentifierGenerator();
            if (generator instanceof OptimizableGenerator) {
                Optimizer optimizer = ((OptimizableGenerator)generator).getOptimizer();
                if (optimizer != null && optimizer.getIncrementSize() > 1) {
                    TemporaryTableColumn rowNumberColumn = this.entityTable.getColumns().get(this.entityTable.getColumns().size() - 1);
                    rowNumberType = (BasicType)rowNumberColumn.getJdbcMapping();
                    ColumnReference columnReference = new ColumnReference((String)null, rowNumberColumn.getColumnName(), false, null, null, rowNumberColumn.getJdbcMapping(), this.sessionFactory);
                    insertStatement.getTargetColumnReferences().add(columnReference);
                    targetPathColumns.add(new Assignment(columnReference, columnReference));
                } else {
                    rowNumberType = null;
                }
            } else {
                rowNumberType = null;
            }
            if (sessionUidColumn != null) {
                ColumnReference sessionUidColumnReference = new ColumnReference((String)null, sessionUidColumn.getColumnName(), false, null, null, sessionUidColumn.getJdbcMapping(), this.sessionFactory);
                insertStatement.getTargetColumnReferences().add(sessionUidColumnReference);
                targetPathColumns.add(new Assignment(sessionUidColumnReference, this.sessionUidParameter));
            }
            List<SqmValues> sqmValuesList = ((SqmInsertValuesStatement)this.sqmInsertStatement).getValuesList();
            ArrayList<Values> valuesList = new ArrayList<Values>(sqmValuesList.size());
            for (int i = 0; i < sqmValuesList.size(); ++i) {
                Values values = converterDelegate.visitValues(sqmValuesList.get(i));
                additionalInsertValues.applyValues(values);
                if (rowNumberType != null) {
                    values.getExpressions().add(new QueryLiteral<Integer>(i + 1, rowNumberType));
                }
                if (this.sessionUidParameter != null) {
                    values.getExpressions().add(this.sessionUidParameter);
                }
                valuesList.add(values);
            }
            insertStatement.setValuesList(valuesList);
        }
        converterDelegate.pruneTableGroupJoins();
        HashMap<String, TableReference> tableReferenceByAlias = CollectionHelper.mapOfSize(insertingTableGroup.getTableReferenceJoins().size() + 1);
        this.collectTableReference(insertingTableGroup.getPrimaryTableReference(), tableReferenceByAlias::put);
        for (int i = 0; i < insertingTableGroup.getTableReferenceJoins().size(); ++i) {
            this.collectTableReference(insertingTableGroup.getTableReferenceJoins().get(i), tableReferenceByAlias::put);
        }
        return new InsertExecutionDelegate(this.sqmInsertStatement, converterDelegate, this.entityTable, this.afterUseAction, this.sessionUidAccess, this.domainParameterXref, insertingTableGroup, tableReferenceByAlias, targetPathColumns, insertStatement, parameterResolutions, this.sessionUidParameter, paramTypeResolutions, executionContext);
    }

    private void collectTableReference(TableReference tableReference, BiConsumer<String, TableReference> consumer) {
        consumer.accept(tableReference.getIdentificationVariable(), tableReference);
    }

    private void collectTableReference(TableReferenceJoin tableReferenceJoin, BiConsumer<String, TableReference> consumer) {
        this.collectTableReference(tableReferenceJoin.getJoinedTableReference(), consumer);
    }

    public static interface ExecutionDelegate {
        public int execute(ExecutionContext var1);
    }
}

