/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.DelegatingTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.UnknownTableReferenceException;
import org.hibernate.sql.ast.tree.from.VirtualTableGroup;

public class MappedByTableGroup
extends DelegatingTableGroup
implements VirtualTableGroup {
    private final NavigablePath navigablePath;
    private final ModelPartContainer modelPart;
    private final TableGroup underlyingTableGroup;
    private final boolean fetched;
    private final TableGroup parentTableGroup;
    private final BiPredicate<NavigablePath, String> navigablePathChecker;

    public MappedByTableGroup(NavigablePath navigablePath, ModelPartContainer modelPart, TableGroup underlyingTableGroup, boolean fetched, TableGroup parentTableGroup, BiPredicate<NavigablePath, String> navigablePathChecker) {
        this.navigablePath = navigablePath;
        this.modelPart = modelPart;
        this.underlyingTableGroup = underlyingTableGroup;
        this.fetched = fetched;
        this.parentTableGroup = parentTableGroup;
        this.navigablePathChecker = navigablePathChecker;
    }

    @Override
    protected TableGroup getTableGroup() {
        return this.underlyingTableGroup;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public ModelPartContainer getExpressionType() {
        return this.getModelPart();
    }

    @Override
    public String getGroupAlias() {
        return null;
    }

    @Override
    public boolean isFetched() {
        return this.fetched;
    }

    @Override
    public ModelPartContainer getModelPart() {
        return this.modelPart;
    }

    @Override
    public boolean isRealTableGroup() {
        return false;
    }

    @Override
    public boolean isLateral() {
        return false;
    }

    @Override
    public List<TableGroupJoin> getTableGroupJoins() {
        return Collections.emptyList();
    }

    @Override
    public List<TableGroupJoin> getNestedTableGroupJoins() {
        return Collections.emptyList();
    }

    @Override
    public void visitTableGroupJoins(Consumer<TableGroupJoin> consumer) {
    }

    @Override
    public void visitNestedTableGroupJoins(Consumer<TableGroupJoin> consumer) {
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return Collections.emptyList();
    }

    @Override
    public TableReference resolveTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization) {
        TableReference tableReference = this.getTableReference(navigablePath, tableExpression, allowFkOptimization, true);
        if (tableReference == null) {
            throw new UnknownTableReferenceException(tableExpression, String.format(Locale.ROOT, "Unable to determine TableReference (`%s`) for `%s`", tableExpression, navigablePath));
        }
        return tableReference;
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization, boolean resolve) {
        TableReference reference;
        if (allowFkOptimization && (navigablePath == null || this.navigablePathChecker.test(navigablePath, tableExpression)) && (reference = this.parentTableGroup.getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve)) != null) {
            return reference;
        }
        return this.underlyingTableGroup.getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve);
    }
}

