/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain;

import java.util.function.BiConsumer;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.Association;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.BiDirectionalFetch;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public class CircularBiDirectionalFetchImpl
implements BiDirectionalFetch,
Association {
    private final FetchTiming timing;
    private final NavigablePath navigablePath;
    private final ToOneAttributeMapping fetchable;
    private final FetchParent fetchParent;
    private final LockMode lockMode;
    private final NavigablePath referencedNavigablePath;
    private final DomainResult<?> keyDomainResult;

    public CircularBiDirectionalFetchImpl(FetchTiming timing, NavigablePath navigablePath, FetchParent fetchParent, ToOneAttributeMapping fetchable, LockMode lockMode, NavigablePath referencedNavigablePath, DomainResult<?> keyDomainResult) {
        this.timing = timing;
        this.fetchParent = fetchParent;
        this.navigablePath = navigablePath;
        this.fetchable = fetchable;
        this.lockMode = lockMode;
        this.referencedNavigablePath = referencedNavigablePath;
        this.keyDomainResult = keyDomainResult;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public NavigablePath getReferencedPath() {
        return this.referencedNavigablePath;
    }

    @Override
    public FetchParent getFetchParent() {
        return this.fetchParent;
    }

    @Override
    public Fetchable getFetchedMapping() {
        return this.fetchable;
    }

    @Override
    public JavaType<?> getResultJavaType() {
        return this.fetchable.getJavaType();
    }

    public DomainResultAssembler createAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        return new CircularFetchAssembler(this.fetchable, this.getReferencedPath(), this.fetchable.getJavaType(), this.keyDomainResult == null ? null : this.keyDomainResult.createResultAssembler(parentAccess, creationState));
    }

    @Override
    public FetchTiming getTiming() {
        return this.timing;
    }

    @Override
    public boolean hasTableGroup() {
        return true;
    }

    @Override
    public String getFetchableName() {
        return this.fetchable.getFetchableName();
    }

    @Override
    public String getPartName() {
        return this.fetchable.getFetchableName();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.fetchable.getNavigableRole();
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.fetchable.findContainingEntityMapping();
    }

    @Override
    public MappingType getPartMappingType() {
        return this.fetchable.getPartMappingType();
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.fetchable.getJavaType();
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ForeignKeyDescriptor getForeignKeyDescriptor() {
        return ((Association)((Object)this.fetchParent)).getForeignKeyDescriptor();
    }

    @Override
    public ForeignKeyDescriptor.Nature getSideNature() {
        return ((Association)((Object)this.fetchParent)).getSideNature();
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        this.fetchable.breakDownJdbcValues(domainValue, valueConsumer, session);
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return this.fetchable.createDomainResult(navigablePath, tableGroup, resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.fetchable.applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.fetchable.applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    private static class CircularFetchAssembler
    implements DomainResultAssembler<Object> {
        private final NavigablePath circularPath;
        private final JavaType<?> javaType;
        private final ToOneAttributeMapping fetchable;
        private final DomainResultAssembler<?> keyDomainResultAssembler;

        public CircularFetchAssembler(ToOneAttributeMapping fetchable, NavigablePath circularPath, JavaType<?> javaType, DomainResultAssembler<?> keyDomainResultAssembler) {
            this.fetchable = fetchable;
            this.circularPath = circularPath;
            this.javaType = javaType;
            this.keyDomainResultAssembler = keyDomainResultAssembler;
        }

        @Override
        public Object assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
            Object initializedInstance;
            Object foreignKey;
            if (this.keyDomainResultAssembler != null && (foreignKey = this.keyDomainResultAssembler.assemble(rowProcessingState, options)) == null) {
                return null;
            }
            EntityInitializer initializer = this.resolveCircularInitializer(rowProcessingState);
            if (initializer == null) {
                if (this.circularPath.getParent() != null) {
                    NavigablePath path = this.circularPath.getParent();
                    Initializer parentInitializer = rowProcessingState.resolveInitializer(path);
                    while (!(parentInitializer instanceof EntityInitializer) && path.getParent() != null) {
                        path = path.getParent();
                        parentInitializer = rowProcessingState.resolveInitializer(path);
                    }
                    initializer = (EntityInitializer)parentInitializer;
                } else {
                    Initializer parentInitializer = rowProcessingState.resolveInitializer(this.circularPath);
                    assert (parentInitializer instanceof CollectionInitializer);
                    CollectionInitializer circ = (CollectionInitializer)parentInitializer;
                    EntityPersister entityPersister = (EntityPersister)this.fetchable.getMappedType();
                    CollectionKey collectionKey = circ.resolveCollectionKey(rowProcessingState);
                    Object key = collectionKey.getKey();
                    SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
                    PersistenceContext persistenceContext = session.getPersistenceContext();
                    if (this.fetchable.getReferencedPropertyName() != null) {
                        return this.loadByUniqueKey(entityPersister, key, session, persistenceContext);
                    }
                    EntityKey entityKey = new EntityKey(key, entityPersister);
                    Object proxy = persistenceContext.getProxy(entityKey);
                    if (proxy == null || !proxy.getClass().isAssignableFrom(this.javaType.getJavaTypeClass())) {
                        return persistenceContext.getEntity(entityKey);
                    }
                    return proxy;
                }
            }
            if (initializer.getInitializedInstance() == null) {
                initializer.resolveKey(rowProcessingState);
                initializer.resolveInstance(rowProcessingState);
            }
            if ((initializedInstance = initializer.getInitializedInstance()) instanceof HibernateProxy) {
                if (initializedInstance.getClass().isAssignableFrom(this.javaType.getJavaTypeClass())) {
                    return initializedInstance;
                }
                initializer.initializeInstance(rowProcessingState);
                return ((HibernateProxy)initializedInstance).getHibernateLazyInitializer().getImplementation();
            }
            return initializedInstance;
        }

        private Object loadByUniqueKey(EntityPersister entityPersister, Object key, SharedSessionContractImplementor session, PersistenceContext persistenceContext) {
            String uniqueKeyPropertyName = this.fetchable.getReferencedPropertyName();
            EntityUniqueKey euk = new EntityUniqueKey(entityPersister.getEntityName(), uniqueKeyPropertyName, key, entityPersister.getIdentifierType(), session.getFactory());
            Object entityInstance = persistenceContext.getEntity(euk);
            if (entityInstance == null && (entityInstance = ((UniqueKeyLoadable)entityPersister).loadByUniqueKey(uniqueKeyPropertyName, key, session)) != null) {
                persistenceContext.addEntity(euk, entityInstance);
            }
            return entityInstance;
        }

        private EntityInitializer resolveCircularInitializer(RowProcessingState rowProcessingState) {
            Initializer initializer = rowProcessingState.resolveInitializer(this.circularPath);
            if (initializer instanceof EntityInitializer) {
                return (EntityInitializer)initializer;
            }
            if (initializer instanceof CollectionInitializer) {
                return null;
            }
            ModelPart initializedPart = initializer.getInitializedPart();
            if (initializedPart instanceof EntityInitializer) {
                return (EntityInitializer)((Object)initializedPart);
            }
            NavigablePath path = this.circularPath.getParent();
            Initializer parentInitializer = rowProcessingState.resolveInitializer(path);
            while (!(parentInitializer instanceof EntityInitializer) && path.getParent() != null) {
                path = path.getParent();
                parentInitializer = rowProcessingState.resolveInitializer(path);
            }
            if (!(parentInitializer instanceof EntityInitializer)) {
                return null;
            }
            return (EntityInitializer)parentInitializer;
        }

        @Override
        public JavaType getAssembledJavaType() {
            return this.javaType;
        }
    }
}

