/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

public enum GenerationTiming {
    NEVER{

        @Override
        public boolean includesInsert() {
            return false;
        }

        @Override
        public boolean includesUpdate() {
            return false;
        }

        @Override
        public boolean includes(GenerationTiming timing) {
            return false;
        }
    }
    ,
    INSERT{

        @Override
        public boolean includesInsert() {
            return true;
        }

        @Override
        public boolean includesUpdate() {
            return false;
        }

        @Override
        public boolean includes(GenerationTiming timing) {
            return timing.includesInsert();
        }
    }
    ,
    ALWAYS{

        @Override
        public boolean includesInsert() {
            return true;
        }

        @Override
        public boolean includesUpdate() {
            return true;
        }

        @Override
        public boolean includes(GenerationTiming timing) {
            return timing != NEVER;
        }
    };


    public abstract boolean includesInsert();

    public abstract boolean includesUpdate();

    public abstract boolean includes(GenerationTiming var1);

    public static GenerationTiming parseFromName(String name) {
        if ("insert".equalsIgnoreCase(name)) {
            return INSERT;
        }
        if ("always".equalsIgnoreCase(name)) {
            return ALWAYS;
        }
        return NEVER;
    }
}

