/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalJavaType;
import org.hibernate.type.descriptor.java.ClockHelper;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.descriptor.java.VersionJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class LocalDateTimeJavaType
extends AbstractTemporalJavaType<LocalDateTime>
implements VersionJavaType<LocalDateTime> {
    public static final LocalDateTimeJavaType INSTANCE = new LocalDateTimeJavaType();

    public LocalDateTimeJavaType() {
        super(LocalDateTime.class, ImmutableMutabilityPlan.instance());
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIMESTAMP;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        return context.getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(93);
    }

    @Override
    protected <X> TemporalJavaType<X> forTimestampPrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    @Override
    public String toString(LocalDateTime value) {
        return DateTimeFormatter.ISO_DATE_TIME.format(value);
    }

    @Override
    public LocalDateTime fromString(CharSequence string) {
        return LocalDateTime.from(DateTimeFormatter.ISO_DATE_TIME.parse(string));
    }

    @Override
    public <X> X unwrap(LocalDateTime value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (LocalDateTime.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return (X)Timestamp.valueOf(value);
        }
        if (Date.class.isAssignableFrom(type)) {
            Instant instant = value.atZone(ZoneId.systemDefault()).toInstant();
            return (X)Date.from(instant);
        }
        if (Time.class.isAssignableFrom(type)) {
            Instant instant = value.atZone(ZoneId.systemDefault()).toInstant();
            return (X)Time.from(instant);
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            Instant instant = value.atZone(ZoneId.systemDefault()).toInstant();
            return (X)java.util.Date.from(instant);
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)GregorianCalendar.from(value.atZone(ZoneId.systemDefault()));
        }
        if (Long.class.isAssignableFrom(type)) {
            Instant instant = value.atZone(ZoneId.systemDefault()).toInstant();
            return (X)Long.valueOf(instant.toEpochMilli());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> LocalDateTime wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            return ts.toLocalDateTime();
        }
        if (value instanceof Long) {
            Instant instant = Instant.ofEpochMilli((Long)value);
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return LocalDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        }
        if (value instanceof java.util.Date) {
            Timestamp ts = (Timestamp)value;
            Instant instant = Instant.ofEpochMilli(ts.getTime());
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public boolean isWider(JavaType<?> javaType) {
        switch (javaType.getJavaType().getTypeName()) {
            case "java.sql.Date": 
            case "java.sql.Timestamp": 
            case "java.util.Date": 
            case "java.util.Calendar": {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return dialect.getDefaultTimestampPrecision();
    }

    @Override
    public LocalDateTime seed(Long length, Integer precision, Integer scale, SharedSessionContractImplementor session) {
        return LocalDateTime.now(ClockHelper.forPrecision(precision, session));
    }

    @Override
    public LocalDateTime next(LocalDateTime current, Long length, Integer precision, Integer scale, SharedSessionContractImplementor session) {
        return LocalDateTime.now(ClockHelper.forPrecision(precision, session));
    }
}

