/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc.internal;

import jakarta.persistence.TemporalType;
import java.sql.Time;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.hibernate.dialect.Dialect;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.spi.BasicJdbcLiteralFormatter;

public class JdbcLiteralFormatterTemporal<T>
extends BasicJdbcLiteralFormatter<T> {
    private final TemporalType precision;

    public JdbcLiteralFormatterTemporal(JavaType<T> javaType, TemporalType precision) {
        super(javaType);
        this.precision = precision;
    }

    @Override
    public void appendJdbcLiteral(SqlAppender appender, Object value, Dialect dialect, WrapperOptions wrapperOptions) {
        TimeZone jdbcTimeZone = wrapperOptions == null || wrapperOptions.getJdbcTimeZone() == null ? TimeZone.getDefault() : wrapperOptions.getJdbcTimeZone();
        if (value instanceof Date) {
            dialect.appendDateTimeLiteral(appender, (Date)value, this.precision, jdbcTimeZone);
        } else if (value instanceof Calendar) {
            dialect.appendDateTimeLiteral(appender, (Calendar)value, this.precision, jdbcTimeZone);
        } else if (value instanceof TemporalAccessor) {
            dialect.appendDateTimeLiteral(appender, (TemporalAccessor)value, this.precision, jdbcTimeZone);
        } else {
            switch (this.precision) {
                case DATE: {
                    dialect.appendDateTimeLiteral(appender, this.unwrap(value, java.sql.Date.class, wrapperOptions), this.precision, jdbcTimeZone);
                    break;
                }
                case TIME: {
                    dialect.appendDateTimeLiteral(appender, this.unwrap(value, Time.class, wrapperOptions), this.precision, jdbcTimeZone);
                    break;
                }
                default: {
                    dialect.appendDateTimeLiteral(appender, this.unwrap(value, Date.class, wrapperOptions), this.precision, jdbcTimeZone);
                }
            }
        }
    }
}

