/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.subsystem;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import org.jboss.as.appclient.logging.AppClientLogger;
import org.jboss.as.appclient.subsystem.ApplicationClientConfigurationPersister;
import org.jboss.as.appclient.subsystem.CommandLineArgumentUsageImpl;
import org.jboss.as.appclient.subsystem.parsing.AppClientXml;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.persistence.ConfigurationExtensionFactory;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.SystemExiter;
import org.jboss.as.version.ProductConfig;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.stdio.LoggingOutputStream;
import org.jboss.stdio.NullInputStream;
import org.jboss.stdio.SimpleStdioContextSelector;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class Main {
    private static final PrintStream STDOUT = System.out;
    private static final PrintStream STDERR = System.err;

    private static void usage() {
        CommandLineArgumentUsageImpl.printUsage(STDOUT);
    }

    private Main() {
    }

    public static void main(String[] args) {
        if (LogManager.getLogManager().getClass().getName().equals("org.jboss.logmanager.LogManager")) {
            try {
                Class.forName(ConsoleHandler.class.getName(), true, ConsoleHandler.class.getClassLoader());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            StdioContext.install();
            StdioContext context = StdioContext.create((InputStream)new NullInputStream(), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stdout"), (Level)org.jboss.logmanager.Level.INFO), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stderr"), (Level)org.jboss.logmanager.Level.ERROR));
            StdioContext.setStdioContextSelector((StdioContextSelector)new SimpleStdioContextSelector(context));
        }
        try {
            Module.registerURLStreamHandlerFactoryModule((Module)Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.jboss.vfs")));
            final ParsedOptions options = Main.determineEnvironment(args, new Properties(WildFlySecurityManager.getSystemPropertiesPrivileged()), WildFlySecurityManager.getSystemEnvironmentPrivileged(), ServerEnvironment.LaunchType.APPCLIENT);
            if (options == null) {
                return;
            }
            ServerEnvironment serverEnvironment = options.environment;
            List<String> clientArgs = options.clientArguments;
            if (clientArgs.isEmpty()) {
                STDERR.println(AppClientLogger.ROOT_LOGGER.appClientNotSpecified());
                Main.usage();
                Main.abort(null);
            } else {
                String deploymentName;
                String earPath;
                final QName rootElement = new QName(Namespace.CURRENT.getUriString(), "server");
                String file = clientArgs.get(0);
                final List<String> params = clientArgs.subList(1, clientArgs.size());
                int pos = file.lastIndexOf("#");
                if (pos == -1) {
                    earPath = file;
                    deploymentName = null;
                } else {
                    deploymentName = file.substring(pos + 1);
                    earPath = file.substring(0, pos);
                }
                Bootstrap bootstrap = Bootstrap.Factory.newInstance();
                Bootstrap.Configuration configuration = new Bootstrap.Configuration(serverEnvironment);
                configuration.setModuleLoader(Module.getBootModuleLoader());
                final ExtensionRegistry extensionRegistry = configuration.getExtensionRegistry();
                final AppClientXml parser = new AppClientXml(Module.getBootModuleLoader(), extensionRegistry);
                Bootstrap.ConfigurationPersisterFactory configurationPersisterFactory = new Bootstrap.ConfigurationPersisterFactory(){

                    public ExtensibleConfigurationPersister createConfigurationPersister(ServerEnvironment serverEnvironment, ExecutorService executorService) {
                        ApplicationClientConfigurationPersister persister = new ApplicationClientConfigurationPersister(earPath, deploymentName, options.hostUrl, options.propertiesFile, params, serverEnvironment.getServerConfigurationFile().getBootFile(), rootElement, (XMLElementReader<List<ModelNode>>)parser);
                        for (Namespace namespace : Namespace.domainValues()) {
                            if (namespace.equals((Object)Namespace.CURRENT)) continue;
                            persister.registerAdditionalRootElement(new QName(namespace.getUriString(), "server"), (XMLElementReader)parser);
                        }
                        extensionRegistry.setWriterRegistry((SubsystemXmlWriterRegistry)persister);
                        return persister;
                    }
                };
                configuration.setConfigurationPersisterFactory(configurationPersisterFactory);
                bootstrap.bootstrap(configuration, Collections.emptyList()).get();
            }
        }
        catch (Throwable t) {
            Main.abort(t);
        }
    }

    private static void abort(Throwable t) {
        try {
            if (t != null) {
                t.printStackTrace(STDERR);
            }
        }
        finally {
            SystemExiter.exit((int)1);
        }
    }

    public static ParsedOptions determineEnvironment(String[] args, Properties systemProperties, Map<String, String> systemEnvironment, ServerEnvironment.LaunchType launchType) {
        ArrayList<String> clientArguments = new ArrayList<String>();
        ParsedOptions ret = new ParsedOptions();
        ret.clientArguments = clientArguments;
        int argsLength = args.length;
        String appClientConfig = "appclient.xml";
        boolean clientArgs = false;
        boolean hostSet = false;
        String yamlFile = null;
        for (int i = 0; i < argsLength; ++i) {
            String arg = args[i];
            try {
                if (clientArgs) {
                    clientArguments.add(arg);
                    continue;
                }
                if ("--version".equals(arg) || "-v".equals(arg) || "-version".equals(arg) || "-V".equals(arg)) {
                    ProductConfig productConfig = new ProductConfig(Module.getBootModuleLoader(), WildFlySecurityManager.getPropertyPrivileged((String)"jboss.home.dir", null), null);
                    STDOUT.println(productConfig.getPrettyVersionString());
                    return null;
                }
                if ("--help".equals(arg) || "-h".equals(arg) || "-help".equals(arg)) {
                    Main.usage();
                    return null;
                }
                if ("--properties".equals(arg) || "-properties".equals(arg) || "-P".equals(arg)) {
                    if (Main.processProperties(arg, args[++i])) continue;
                    return null;
                }
                if (arg.startsWith("--properties")) {
                    String urlSpec = Main.parseValue(arg, "--properties");
                    if (urlSpec != null && Main.processProperties(arg, urlSpec)) continue;
                    return null;
                }
                if (arg.startsWith("-P")) {
                    String urlSpec = Main.parseValue(arg, "-P");
                    if (urlSpec != null && Main.processProperties(arg, urlSpec)) continue;
                    return null;
                }
                if (arg.startsWith("-properties")) {
                    String urlSpec = Main.parseValue(arg, "-properties");
                    if (urlSpec != null && Main.processProperties(arg, urlSpec)) continue;
                    return null;
                }
                if (arg.equals("-H") || arg.equals("--host")) {
                    String urlSpec;
                    if (ret.propertiesFile != null) {
                        throw AppClientLogger.ROOT_LOGGER.cannotSpecifyBothHostAndPropertiesFile();
                    }
                    hostSet = true;
                    ret.hostUrl = urlSpec = args[++i];
                    continue;
                }
                if (arg.startsWith("-H")) {
                    String urlSpec;
                    if (ret.propertiesFile != null) {
                        throw AppClientLogger.ROOT_LOGGER.cannotSpecifyBothHostAndPropertiesFile();
                    }
                    hostSet = true;
                    ret.hostUrl = urlSpec = Main.parseValue(arg, "-H");
                    continue;
                }
                if (arg.startsWith("--host")) {
                    String urlSpec;
                    if (ret.propertiesFile != null) {
                        throw AppClientLogger.ROOT_LOGGER.cannotSpecifyBothHostAndPropertiesFile();
                    }
                    hostSet = true;
                    ret.hostUrl = urlSpec = Main.parseValue(arg, "--host");
                    continue;
                }
                if (arg.startsWith("--ejb-client-properties")) {
                    String fileUrl;
                    if (hostSet) {
                        throw AppClientLogger.ROOT_LOGGER.cannotSpecifyBothHostAndPropertiesFile();
                    }
                    ret.propertiesFile = fileUrl = Main.parseValue(arg, "--ejb-client-properties");
                    continue;
                }
                if (arg.startsWith("-D")) {
                    String value;
                    String name;
                    int idx = arg.indexOf("=");
                    if (idx == -1) {
                        name = arg.substring(2);
                        value = "true";
                    } else {
                        name = arg.substring(2, idx);
                        value = arg.substring(idx + 1);
                    }
                    systemProperties.setProperty(name, value);
                    WildFlySecurityManager.setPropertyPrivileged((String)name, (String)value);
                    continue;
                }
                if (arg.startsWith("--appclient-config")) {
                    appClientConfig = Main.parseValue(arg, "--appclient-config");
                    continue;
                }
                if ("-secmgr".equals(arg)) continue;
                if (ConfigurationExtensionFactory.isConfigurationExtensionSupported() && ConfigurationExtensionFactory.commandLineContainsArgument((String)arg)) {
                    int idx = arg.indexOf("=");
                    if (idx == -1) {
                        int next = i + 1;
                        if (next < argsLength) {
                            yamlFile = args[next];
                            ++i;
                            continue;
                        }
                        STDERR.println(AppClientLogger.ROOT_LOGGER.argumentExpected(arg));
                        Main.usage();
                        return null;
                    }
                    yamlFile = arg.substring(idx + 1, arg.length());
                    continue;
                }
                if (arg.startsWith("-")) {
                    STDOUT.println(AppClientLogger.ROOT_LOGGER.unknownOption(arg));
                    Main.usage();
                    return null;
                }
                clientArgs = true;
                clientArguments.add(arg);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                STDERR.println(AppClientLogger.ROOT_LOGGER.argumentExpected(arg));
                Main.usage();
                return null;
            }
        }
        String hostControllerName = null;
        ProductConfig productConfig = new ProductConfig(Module.getBootModuleLoader(), WildFlySecurityManager.getPropertyPrivileged((String)"jboss.home.dir", null), (Map)systemProperties);
        ret.environment = new ServerEnvironment(hostControllerName, systemProperties, systemEnvironment, appClientConfig, null, launchType, null, productConfig, System.currentTimeMillis(), false, null, null, null, yamlFile);
        return ret;
    }

    private static String parseValue(String arg, String key) {
        String value = null;
        int splitPos = key.length();
        if (arg.length() <= splitPos + 1 || arg.charAt(splitPos) != '=') {
            Main.usage();
        } else {
            value = arg.substring(splitPos + 1);
        }
        return value;
    }

    private static boolean processProperties(String arg, String urlSpec) {
        URL url = null;
        try {
            url = Main.makeURL(urlSpec);
            Properties props = System.getProperties();
            props.load(url.openConnection().getInputStream());
            return true;
        }
        catch (MalformedURLException e) {
            STDERR.println(AppClientLogger.ROOT_LOGGER.malformedUrl(arg));
            Main.usage();
            return false;
        }
        catch (IOException e) {
            STDERR.println(AppClientLogger.ROOT_LOGGER.cannotLoadProperties(url));
            Main.usage();
            return false;
        }
    }

    private static URL makeURL(String urlspec) throws MalformedURLException {
        URL url;
        urlspec = urlspec.trim();
        try {
            url = new URL(urlspec);
            if (url.getProtocol().equals("file")) {
                File file = new File(url.getFile()).getCanonicalFile();
                url = file.toURI().toURL();
            }
        }
        catch (Exception e) {
            try {
                File file = new File(urlspec).getCanonicalFile();
                url = file.toURI().toURL();
            }
            catch (Exception n) {
                throw new MalformedURLException(n.toString());
            }
        }
        return url;
    }

    private static final class ParsedOptions {
        ServerEnvironment environment;
        List<String> clientArguments;
        String hostUrl = "http-remoting://localhost:8080";
        String propertiesFile;

        private ParsedOptions() {
        }
    }
}

