/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.SpawnedTestBase;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;
import org.junit.Assert;
import org.junit.Test;

public class JournalCrashTest
extends SpawnedTestBase {
    private static final int FIRST_RUN = 4;
    private static final int SECOND_RUN = 8;
    private static final int THIRD_RUN = 100;
    private static final int FOURTH_RUN = 400;
    private ActiveMQServer server;
    private ClientSessionFactory factory;
    private final SimpleString QUEUE = new SimpleString("queue");
    private ServerLocator locator;

    protected void startServer() throws Exception {
        Configuration config = this.createDefaultInVMConfig().setJournalFileSize(ActiveMQDefaultConfiguration.getDefaultJournalFileSize()).setJournalCompactMinFiles(ActiveMQDefaultConfiguration.getDefaultJournalCompactMinFiles()).setJournalCompactPercentage(ActiveMQDefaultConfiguration.getDefaultJournalCompactPercentage()).setJournalMinFiles(2);
        this.server = super.createServer(true, config);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
    }

    protected void stopServer() throws Exception {
        this.locator.close();
        JournalCrashTest.closeSessionFactory((ClientSessionFactory)this.factory);
        this.factory = null;
        JournalCrashTest.stopComponent((ActiveMQComponent)this.server);
        this.server = null;
    }

    public static void main(String[] arg) {
        try {
            if (arg.length != 3) {
                throw new IllegalArgumentException(Arrays.toString(arg));
            }
            String testDir = arg[0];
            int start = Integer.parseInt(arg[1]);
            int end = Integer.parseInt(arg[2]);
            JournalCrashTest restart = new JournalCrashTest();
            restart.setTestDir(testDir);
            restart.startServer();
            restart.sendMessages(start, end);
            Runtime.getRuntime().halt(100);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.exit(1);
        }
    }

    public void sendMessages(int start, int end) throws Exception {
        try (ClientSession session = this.factory.createSession(false, false);){
            try {
                session.createQueue(new QueueConfiguration(this.QUEUE));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ClientProducer prod = session.createProducer(this.QUEUE);
            for (int i = start; i < end; ++i) {
                ClientMessage msg = session.createMessage(true);
                msg.putIntProperty(new SimpleString("key"), i);
                msg.getBodyBuffer().writeUTF("message " + i);
                prod.send((Message)msg);
            }
            session.commit();
            session.close();
        }
    }

    @Test
    public void testRestartJournal() throws Throwable {
        this.runExternalProcess(this.getTestDir(), 0, 4);
        this.runExternalProcess(this.getTestDir(), 4, 8);
        this.runExternalProcess(this.getTestDir(), 8, 100);
        this.runExternalProcess(this.getTestDir(), 100, 400);
        this.printJournal();
        this.startServer();
        try (ClientSession session = this.factory.createSession(true, true);){
            ClientConsumer consumer = session.createConsumer(this.QUEUE);
            session.start();
            for (int i = 0; i < 400; ++i) {
                ClientMessage msg = consumer.receive(5000L);
                Assert.assertNotNull((String)("Msg at " + i), (Object)msg);
                msg.acknowledge();
                Assert.assertEquals((Object)i, (Object)msg.getObjectProperty(new SimpleString("key")));
            }
            session.close();
        }
    }

    private void runExternalProcess(String tempDir, int start, int end) throws Exception {
        System.err.println("running external process...");
        Process process = SpawnedVMSupport.spawnVM((String)((Object)((Object)this)).getClass().getCanonicalName(), (String)"-Xms128m", (String)"-Xmx128m", (String[])new String[0], (boolean)true, (boolean)true, (boolean)true, (String[])new String[]{tempDir, Integer.toString(start), Integer.toString(end)});
        Assert.assertEquals((long)100L, (long)process.waitFor());
    }

    private void printJournal() throws Exception {
        NIOSequentialFileFactory factory = new NIOSequentialFileFactory(new File(this.getJournalDir()), 100);
        JournalImpl journal = new JournalImpl(ActiveMQDefaultConfiguration.getDefaultJournalFileSize(), 2, 2, 0, 0, (SequentialFileFactory)factory, "activemq-data", "amq", 100);
        ArrayList records = new ArrayList();
        ArrayList transactions = new ArrayList();
        journal.start();
        journal.load(records, transactions, null);
        journal.stop();
    }
}

