/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessageHandlerTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private final SimpleString QUEUE = new SimpleString("ConsumerTestQueue");
    private ServerLocator locator;
    private ClientSessionFactory sf;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
    }

    @Test
    public void testSetMessageHandlerWithMessagesPending() throws Exception {
        ClientSession session = this.sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE, null, true);
        session.start();
        Thread.sleep(100L);
        class MyHandler
        implements MessageHandler {
            MyHandler() {
            }

            public void onMessage(ClientMessage message) {
                try {
                    Thread.sleep(10L);
                    message.acknowledge();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        consumer.setMessageHandler((MessageHandler)new MyHandler());
        Thread.sleep(100L);
        consumer.setMessageHandler(null);
        Thread.sleep(500L);
        Assert.assertNull((Object)consumer.getLastException());
        session.close();
    }

    @Test
    public void testSetResetMessageHandler() throws Exception {
        ClientSession session = this.sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            message.putIntProperty(new SimpleString("i"), i);
            producer.send((Message)message);
        }
        final ClientConsumer consumer = session.createConsumer(this.QUEUE);
        CountDownLatch latch = new CountDownLatch(50);
        class MyHandler
        implements MessageHandler {
            int messageReceived = 0;
            boolean failed;
            boolean started = true;
            private final CountDownLatch latch;

            MyHandler(CountDownLatch latch) {
                this.latch = latch;
            }

            public void onMessage(ClientMessage message) {
                try {
                    if (!this.started) {
                        this.failed = true;
                    }
                    ++this.messageReceived;
                    this.latch.countDown();
                    if (this.latch.getCount() == 0L) {
                        message.acknowledge();
                        this.started = false;
                        consumer.setMessageHandler(null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        MyHandler handler = new MyHandler(latch);
        consumer.setMessageHandler((MessageHandler)handler);
        session.start();
        MessageHandlerTest.waitForLatch((CountDownLatch)latch);
        Thread.sleep(100L);
        Assert.assertFalse((boolean)handler.failed);
        Assert.assertNull((Object)consumer.getLastException());
        latch = new CountDownLatch(50);
        handler = new MyHandler(latch);
        consumer.setMessageHandler((MessageHandler)handler);
        session.start();
        Assert.assertTrue((String)("message received " + handler.messageReceived), (boolean)latch.await(5L, TimeUnit.SECONDS));
        Thread.sleep(100L);
        Assert.assertFalse((boolean)handler.failed);
        Assert.assertNull((Object)consumer.getLastException());
        session.close();
    }

    @Test
    public void testSetUnsetMessageHandler() throws Exception {
        ClientSession session = this.sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            message.putIntProperty(new SimpleString("i"), i);
            producer.send((Message)message);
        }
        final ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        CountDownLatch latch = new CountDownLatch(50);
        class MyHandler
        implements MessageHandler {
            int messageReceived = 0;
            boolean failed;
            boolean started = true;
            private final CountDownLatch latch;

            MyHandler(CountDownLatch latch) {
                this.latch = latch;
            }

            public void onMessage(ClientMessage message) {
                try {
                    if (!this.started) {
                        this.failed = true;
                    }
                    ++this.messageReceived;
                    this.latch.countDown();
                    if (this.latch.getCount() == 0L) {
                        message.acknowledge();
                        this.started = false;
                        consumer.setMessageHandler(null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        MyHandler handler = new MyHandler(latch);
        consumer.setMessageHandler((MessageHandler)handler);
        MessageHandlerTest.waitForLatch((CountDownLatch)latch);
        Thread.sleep(100L);
        Assert.assertFalse((boolean)handler.failed);
        Assert.assertNull((Object)consumer.getLastException());
        consumer.setMessageHandler(null);
        ClientMessage cm = consumer.receiveImmediate();
        Assert.assertNotNull((Object)cm);
        session.close();
    }

    @Test
    public void testSetUnsetResetMessageHandler() throws Exception {
        ClientSession session = this.sf.createSession(false, true, true);
        session.createQueue(new QueueConfiguration(this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            message.putIntProperty(new SimpleString("i"), i);
            producer.send((Message)message);
        }
        final ClientConsumer consumer = session.createConsumer(this.QUEUE);
        session.start();
        CountDownLatch latch = new CountDownLatch(50);
        class MyHandler
        implements MessageHandler {
            int messageReceived = 0;
            boolean failed;
            boolean started = true;
            private final CountDownLatch latch;

            MyHandler(CountDownLatch latch) {
                this.latch = latch;
            }

            public void onMessage(ClientMessage message) {
                try {
                    if (!this.started) {
                        this.failed = true;
                    }
                    ++this.messageReceived;
                    this.latch.countDown();
                    if (this.latch.getCount() == 0L) {
                        message.acknowledge();
                        this.started = false;
                        consumer.setMessageHandler(null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        MyHandler handler = new MyHandler(latch);
        consumer.setMessageHandler((MessageHandler)handler);
        MessageHandlerTest.waitForLatch((CountDownLatch)latch);
        Thread.sleep(100L);
        Assert.assertFalse((boolean)handler.failed);
        Assert.assertNull((Object)consumer.getLastException());
        consumer.setMessageHandler(null);
        ClientMessage cm = consumer.receiveImmediate();
        Assert.assertNotNull((Object)cm);
        latch = new CountDownLatch(49);
        handler = new MyHandler(latch);
        consumer.setMessageHandler((MessageHandler)handler);
        session.start();
        Assert.assertTrue((String)("message received " + handler.messageReceived), (boolean)latch.await(5L, TimeUnit.SECONDS));
        Thread.sleep(100L);
        Assert.assertFalse((boolean)handler.failed);
        Assert.assertNull((Object)consumer.getLastException());
        session.close();
    }
}

