/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster;

import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQClusterSecurityException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.ActiveMQServerSideProtocolManagerFactory;
import org.apache.activemq.artemis.core.server.cluster.ClusterControl;
import org.apache.activemq.artemis.core.server.cluster.ClusterController;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManagerFactory;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.junit.Before;
import org.junit.Test;

public class ClusterControllerTest
extends ClusterTestBase {
    private ClusterConnectionConfiguration clusterConf0;
    private ClusterConnectionConfiguration clusterConf1;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setupServer(0, this.isFileStorage(), true);
        this.setupServer(1, this.isFileStorage(), true);
        this.getServer(0).getConfiguration().getAcceptorConfigurations().add(ClusterControllerTest.createTransportConfiguration((boolean)false, (boolean)true, (Map)ClusterControllerTest.generateParams((int)0, (boolean)false)));
        this.getServer(1).getConfiguration().getAcceptorConfigurations().add(ClusterControllerTest.createTransportConfiguration((boolean)false, (boolean)true, (Map)ClusterControllerTest.generateParams((int)1, (boolean)false)));
        this.getServer(0).getConfiguration().setSecurityEnabled(true);
        this.getServer(1).getConfiguration().setSecurityEnabled(true);
        this.getServer(1).getConfiguration().setClusterPassword("something different");
        this.clusterConf0 = new ClusterConnectionConfiguration().setName("cluster0").setAddress("queues").setMessageLoadBalancingType(MessageLoadBalancingType.ON_DEMAND).setMaxHops(1).setInitialConnectAttempts(8).setReconnectAttempts(10).setRetryInterval(250L).setMaxRetryInterval(4000L).setRetryIntervalMultiplier(2.0);
        this.clusterConf1 = new ClusterConnectionConfiguration().setName("cluster0").setAddress("queues").setMessageLoadBalancingType(MessageLoadBalancingType.ON_DEMAND).setMaxHops(1).setInitialConnectAttempts(8).setReconnectAttempts(10).setRetryInterval(250L).setMaxRetryInterval(4000L).setRetryIntervalMultiplier(2.0);
        this.setupClusterConnection(this.clusterConf0, true, 0, new int[0]);
        this.setupClusterConnection(this.clusterConf1, true, 1, new int[0]);
        this.startServers(0);
        this.startServers(1);
    }

    private boolean clusterConnectionConfigurationIsSameBeforeAfterStart(ClusterConnectionConfiguration clusterConnectionConfigurationBeforeStart, int node) {
        Double clusterConnectionConfigurationBeforeStartRIM;
        Double serverNodeClusterConnectionConfigurationRIM;
        boolean clusterConnectionConfigurationIsSame = false;
        Configuration serverNodeConfiguration = this.getServer(node).getConfiguration();
        ActiveMQServer serverNode = this.getServer(node);
        ClusterManager clusterManager = serverNode.getClusterManager();
        ClusterController clusterController = clusterManager.getClusterController();
        ServerLocator serverNodeLocator = clusterController.getServerLocator(new SimpleString(clusterConnectionConfigurationBeforeStart.getName()));
        List serverNodeClusterConnectionConfigurations = serverNodeConfiguration.getClusterConfigurations();
        if (serverNodeLocator.getInitialConnectAttempts() == clusterConnectionConfigurationBeforeStart.getInitialConnectAttempts() && serverNodeLocator.getReconnectAttempts() == clusterConnectionConfigurationBeforeStart.getReconnectAttempts() && serverNodeLocator.getRetryInterval() == clusterConnectionConfigurationBeforeStart.getRetryInterval() && serverNodeLocator.getMaxRetryInterval() == clusterConnectionConfigurationBeforeStart.getMaxRetryInterval() && 0 == (serverNodeClusterConnectionConfigurationRIM = Double.valueOf(serverNodeLocator.getRetryIntervalMultiplier())).compareTo(clusterConnectionConfigurationBeforeStartRIM = Double.valueOf(clusterConnectionConfigurationBeforeStart.getRetryIntervalMultiplier()))) {
            clusterConnectionConfigurationIsSame = true;
        }
        return clusterConnectionConfigurationIsSame;
    }

    @Test
    public void controlWithDifferentConnector() throws Exception {
        try (ServerLocatorImpl locator = (ServerLocatorImpl)this.createInVMNonHALocator();){
            locator.setProtocolManagerFactory((ClientProtocolManagerFactory)ActiveMQServerSideProtocolManagerFactory.getInstance((ServerLocator)locator, (StorageManager)this.servers[0].getStorageManager()));
            ClusterController controller = new ClusterController(this.getServer(0), this.getServer(0).getScheduledPool());
            ClusterControl clusterControl = controller.connectToNodeInCluster((ClientSessionFactoryInternal)locator.createSessionFactory());
            clusterControl.authorize();
        }
    }

    @Test
    public void controlWithDifferentPassword() throws Exception {
        try (ServerLocatorImpl locator = (ServerLocatorImpl)this.createInVMNonHALocator();){
            locator.setProtocolManagerFactory((ClientProtocolManagerFactory)ActiveMQServerSideProtocolManagerFactory.getInstance((ServerLocator)locator, (StorageManager)this.servers[0].getStorageManager()));
            ClusterController controller = new ClusterController(this.getServer(1), this.getServer(1).getScheduledPool());
            ClusterControl clusterControl = controller.connectToNodeInCluster((ClientSessionFactoryInternal)locator.createSessionFactory());
            try {
                clusterControl.authorize();
                ClusterControllerTest.fail((String)"should throw ActiveMQClusterSecurityException");
            }
            catch (Exception e) {
                ClusterControllerTest.assertTrue((String)"should throw ActiveMQClusterSecurityException", (boolean)(e instanceof ActiveMQClusterSecurityException));
            }
        }
    }

    @Test
    public void verifyServerLocatorsClusterConfiguration() {
        if (!this.clusterConnectionConfigurationIsSameBeforeAfterStart(this.clusterConf0, 0)) {
            ClusterControllerTest.fail((String)"serverLocator is not configured as per clusterConf0");
        }
        if (!this.clusterConnectionConfigurationIsSameBeforeAfterStart(this.clusterConf1, 1)) {
            ClusterControllerTest.fail((String)"serverLocator is not configured as per clusterConf1");
        }
    }
}

