/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.Context;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.registry.JndiBindingRegistry;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSConnectionFactory;
import org.apache.activemq.artemis.jms.server.impl.JMSServerManagerImpl;
import org.apache.activemq.artemis.spi.core.naming.BindingRegistry;
import org.apache.activemq.artemis.tests.integration.paging.PagingTest;
import org.apache.activemq.artemis.tests.unit.util.InVMNamingContext;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class PagingOrderTest
extends ActiveMQTestBase {
    private static final int PAGE_MAX = 102400;
    private static final int PAGE_SIZE = 10240;
    static final SimpleString ADDRESS = new SimpleString("SimpleAddress");
    private Connection conn;

    @Test
    public void testOrder1() throws Throwable {
        ClientMessage message;
        int i;
        boolean persistentMessages = true;
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        ActiveMQServer server = this.createServer(true, config, 10240, 102400L, new HashMap());
        server.start();
        int messageSize = 1024;
        int numberOfMessages = 500;
        ServerLocator locator = this.createInVMNonHALocator().setClientFailureCheckPeriod(1000L).setConnectionTTL(2000L).setReconnectAttempts(0).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setConsumerWindowSize(0x100000);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, false, false);
        server.addAddressInfo(new AddressInfo(ADDRESS, RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(ADDRESS).setRoutingType(RoutingType.ANYCAST));
        ClientProducer producer = session.createProducer(PagingTest.ADDRESS);
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingOrderTest.getSamplebyte((long)j));
        }
        for (int i2 = 0; i2 < 500; ++i2) {
            ClientMessage message2 = session.createMessage(persistentMessages);
            ActiveMQBuffer bodyLocal = message2.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message2.putIntProperty(new SimpleString("id"), i2);
            producer.send((org.apache.activemq.artemis.api.core.Message)message2);
            if (i2 % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        session.close();
        session = sf.createSession(true, true, 0);
        session.start();
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        for (i = 0; i < 250; ++i) {
            message = consumer.receive(5000L);
            PagingOrderTest.assertNotNull((Object)message);
            PagingOrderTest.assertEquals((long)i, (long)message.getIntProperty("id").intValue());
            if (i >= 100) continue;
            message.acknowledge();
        }
        session.close();
        sf.close();
        sf = this.createSessionFactory(locator);
        session = sf.createSession(true, true, 0);
        session.start();
        consumer = session.createConsumer(ADDRESS);
        for (i = 100; i < 500; ++i) {
            message = consumer.receive(5000L);
            PagingOrderTest.assertNotNull((Object)message);
            PagingOrderTest.assertEquals((long)i, (long)message.getIntProperty("id").intValue());
            message.acknowledge();
        }
        session.close();
    }

    @Test
    public void testPageCounter() throws Throwable {
        boolean persistentMessages = true;
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        ActiveMQServer server = this.createServer(true, config, 10240, 102400L, new HashMap());
        server.start();
        int messageSize = 1024;
        int numberOfMessages = 500;
        ServerLocator locator = this.createInVMNonHALocator().setClientFailureCheckPeriod(1000L).setConnectionTTL(2000L).setReconnectAttempts(0).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setConsumerWindowSize(0x100000);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, false, false);
        server.addAddressInfo(new AddressInfo(ADDRESS, RoutingType.ANYCAST));
        Queue q1 = server.createQueue(new QueueConfiguration(ADDRESS));
        Queue q2 = server.createQueue(new QueueConfiguration(new SimpleString("inactive")).setAddress(ADDRESS).setRoutingType(RoutingType.MULTICAST));
        ClientProducer producer = session.createProducer(PagingTest.ADDRESS);
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingOrderTest.getSamplebyte((long)j));
        }
        final AtomicInteger errors = new AtomicInteger(0);
        Thread t1 = new Thread(){

            @Override
            public void run() {
                try {
                    ServerLocator sl = PagingOrderTest.this.createInVMNonHALocator();
                    ClientSessionFactory sf = sl.createSessionFactory();
                    ClientSession sess = sf.createSession(true, true, 0);
                    sess.start();
                    ClientConsumer cons = sess.createConsumer(ADDRESS);
                    for (int i = 0; i < 500; ++i) {
                        ClientMessage msg = cons.receive(5000L);
                        Assert.assertNotNull((Object)msg);
                        Assert.assertEquals((long)i, (long)msg.getIntProperty("id").intValue());
                        msg.acknowledge();
                    }
                    Assert.assertNull((Object)cons.receiveImmediate());
                    sess.close();
                    sl.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
            }
        };
        t1.start();
        for (int i = 0; i < 500; ++i) {
            ClientMessage message = session.createMessage(persistentMessages);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty(new SimpleString("id"), i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 20 != 0) continue;
            session.commit();
        }
        session.commit();
        t1.join();
        PagingOrderTest.assertEquals((long)0L, (long)errors.get());
        PagingOrderTest.assertEquals((long)500L, (long)this.getMessageCount(q2));
        PagingOrderTest.assertEquals((long)500L, (long)this.getMessagesAdded(q2));
        PagingOrderTest.assertEquals((long)0L, (long)this.getMessageCount(q1));
        PagingOrderTest.assertEquals((long)500L, (long)this.getMessagesAdded(q1));
        session.close();
        sf.close();
        locator.close();
        server.stop();
        server.start();
        Bindings bindings = server.getPostOffice().getBindingsForAddress(ADDRESS);
        q1 = null;
        q2 = null;
        for (Binding bind : bindings.getBindings()) {
            if (!(bind instanceof LocalQueueBinding)) continue;
            LocalQueueBinding qb = (LocalQueueBinding)bind;
            if (qb.getQueue().getName().equals((Object)ADDRESS)) {
                q1 = qb.getQueue();
            }
            if (!qb.getQueue().getName().equals((Object)new SimpleString("inactive"))) continue;
            q2 = qb.getQueue();
        }
        PagingOrderTest.assertNotNull((Object)q1);
        PagingOrderTest.assertNotNull((Object)q2);
        PagingOrderTest.assertEquals((String)"q2 msg count", (long)500L, (long)this.getMessageCount(q2));
        PagingOrderTest.assertEquals((String)"q2 msgs added", (long)500L, (long)this.getMessagesAdded(q2));
        PagingOrderTest.assertEquals((String)"q1 msg count", (long)0L, (long)this.getMessageCount(q1));
        PagingOrderTest.assertEquals((String)"q1 msgs added", (long)0L, (long)this.getMessagesAdded(q1));
    }

    @Test
    public void testPageCounter2() throws Throwable {
        boolean persistentMessages = true;
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        ActiveMQServer server = this.createServer(true, config, 10240, 102400L, new HashMap());
        server.start();
        int messageSize = 1024;
        int numberOfMessages = 500;
        ServerLocator locator = this.createInVMNonHALocator().setClientFailureCheckPeriod(1000L).setConnectionTTL(2000L).setReconnectAttempts(0).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setConsumerWindowSize(0x100000);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, false, false);
        server.addAddressInfo(new AddressInfo(ADDRESS, RoutingType.ANYCAST));
        Queue q1 = server.createQueue(new QueueConfiguration(ADDRESS));
        Queue q2 = server.createQueue(new QueueConfiguration(new SimpleString("inactive")).setAddress(ADDRESS).setRoutingType(RoutingType.MULTICAST));
        ClientProducer producer = session.createProducer(PagingTest.ADDRESS);
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingOrderTest.getSamplebyte((long)j));
        }
        final AtomicInteger errors = new AtomicInteger(0);
        Thread t1 = new Thread(){

            @Override
            public void run() {
                try {
                    ServerLocator sl = PagingOrderTest.this.createInVMNonHALocator();
                    ClientSessionFactory sf = sl.createSessionFactory();
                    ClientSession sess = sf.createSession(true, true, 0);
                    sess.start();
                    ClientConsumer cons = sess.createConsumer(ADDRESS);
                    for (int i = 0; i < 100; ++i) {
                        ClientMessage msg = cons.receive(5000L);
                        Assert.assertNotNull((Object)msg);
                        Assert.assertEquals((long)i, (long)msg.getIntProperty("id").intValue());
                        msg.acknowledge();
                    }
                    sess.close();
                    sl.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
            }
        };
        for (int i = 0; i < 500; ++i) {
            ClientMessage message = session.createMessage(persistentMessages);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty(new SimpleString("id"), i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 20 != 0) continue;
            session.commit();
        }
        session.commit();
        t1.start();
        t1.join();
        PagingOrderTest.assertEquals((long)0L, (long)errors.get());
        long timeout = System.currentTimeMillis() + 10000L;
        while (400 != this.getMessageCount(q1) && System.currentTimeMillis() < timeout) {
            Thread.sleep(500L);
        }
        PagingOrderTest.assertEquals((long)500L, (long)this.getMessageCount(q2));
        PagingOrderTest.assertEquals((long)500L, (long)this.getMessagesAdded(q2));
        PagingOrderTest.assertEquals((long)400L, (long)this.getMessageCount(q1));
    }

    @Test
    public void testOrderOverRollback() throws Throwable {
        ClientMessage message;
        int i;
        boolean persistentMessages = true;
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        ActiveMQServer server = this.createServer(true, config, 10240, 102400L, new HashMap());
        server.start();
        int messageSize = 1024;
        int numberOfMessages = 3000;
        ServerLocator locator = this.createInVMNonHALocator().setClientFailureCheckPeriod(1000L).setConnectionTTL(2000L).setReconnectAttempts(0).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setConsumerWindowSize(0x100000);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, false, false);
        server.addAddressInfo(new AddressInfo(ADDRESS, RoutingType.ANYCAST));
        server.createQueue(new QueueConfiguration(ADDRESS).setRoutingType(RoutingType.ANYCAST));
        ClientProducer producer = session.createProducer(PagingTest.ADDRESS);
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingOrderTest.getSamplebyte((long)j));
        }
        for (int i2 = 0; i2 < 3000; ++i2) {
            ClientMessage message2 = session.createMessage(persistentMessages);
            ActiveMQBuffer bodyLocal = message2.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message2.putIntProperty(new SimpleString("id"), i2);
            producer.send((org.apache.activemq.artemis.api.core.Message)message2);
            if (i2 % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        session.close();
        session = sf.createSession(false, false, 0);
        session.start();
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        for (i = 0; i < 1500; ++i) {
            message = consumer.receive(5000L);
            PagingOrderTest.assertNotNull((Object)message);
            PagingOrderTest.assertEquals((long)i, (long)message.getIntProperty("id").intValue());
            message.acknowledge();
        }
        session.rollback();
        session.close();
        session = sf.createSession(false, false, 0);
        session.start();
        consumer = session.createConsumer(ADDRESS);
        for (i = 0; i < 3000; ++i) {
            message = consumer.receive(5000L);
            PagingOrderTest.assertNotNull((Object)message);
            PagingOrderTest.assertEquals((long)i, (long)message.getIntProperty("id").intValue());
            message.acknowledge();
        }
        session.commit();
    }

    @Test
    public void testOrderOverRollback2() throws Throwable {
        boolean persistentMessages = true;
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        ActiveMQServer server = this.createServer(true, config, 10240, 102400L, new HashMap());
        server.start();
        int messageSize = 1024;
        int numberOfMessages = 200;
        ServerLocator locator = this.createInVMNonHALocator().setClientFailureCheckPeriod(1000L).setConnectionTTL(2000L).setReconnectAttempts(0).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setConsumerWindowSize(0);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, false, false);
        server.addAddressInfo(new AddressInfo(ADDRESS, RoutingType.ANYCAST));
        QueueImpl queue = (QueueImpl)server.createQueue(new QueueConfiguration(ADDRESS).setRoutingType(RoutingType.ANYCAST));
        ClientProducer producer = session.createProducer(PagingTest.ADDRESS);
        byte[] body = new byte[1024];
        ByteBuffer bb = ByteBuffer.wrap(body);
        for (int j = 1; j <= 1024; ++j) {
            bb.put(PagingOrderTest.getSamplebyte((long)j));
        }
        for (int i = 0; i < 200; ++i) {
            ClientMessage message = session.createMessage(persistentMessages);
            ActiveMQBuffer bodyLocal = message.getBodyBuffer();
            bodyLocal.writeBytes(body);
            message.putIntProperty(new SimpleString("id"), i);
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
            if (i % 1000 != 0) continue;
            session.commit();
        }
        session.commit();
        session.close();
        session = sf.createSession(false, false, 0);
        session.start();
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        int numberOfRefs = queue.getNumberOfReferences();
        for (int ref = 0; ref < numberOfRefs; ++ref) {
            ClientMessage msg = consumer.receive(5000L);
            PagingOrderTest.assertNotNull((Object)msg);
            msg.acknowledge();
        }
        session.commit();
        session.close();
        session = sf.createSession(false, false, 0);
        session.start();
        consumer = session.createConsumer(ADDRESS);
        ClientMessage msg = consumer.receive(5000L);
        PagingOrderTest.assertNotNull((Object)msg);
        int msgIDRolledBack = msg.getIntProperty("id");
        msg.acknowledge();
        session.rollback();
        msg = consumer.receive(5000L);
        PagingOrderTest.assertNotNull((Object)msg);
        PagingOrderTest.assertEquals((long)msgIDRolledBack, (long)msg.getIntProperty("id").intValue());
        session.rollback();
        session.close();
        sf.close();
        locator.close();
        server.stop();
        server.start();
        locator = this.createInVMNonHALocator().setClientFailureCheckPeriod(1000L).setConnectionTTL(2000L).setReconnectAttempts(0).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setConsumerWindowSize(0);
        sf = this.createSessionFactory(locator);
        session = sf.createSession(false, false, 0);
        session.start();
        consumer = session.createConsumer(ADDRESS);
        for (int i = msgIDRolledBack; i < 200; ++i) {
            ClientMessage message = consumer.receive(5000L);
            PagingOrderTest.assertNotNull((Object)message);
            PagingOrderTest.assertEquals((long)i, (long)message.getIntProperty("id").intValue());
            message.acknowledge();
        }
        session.commit();
        session.close();
    }

    @Test
    public void testPagingOverCreatedDestinationTopics() throws Exception {
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        ActiveMQServer server = this.createServer(true, config, 10240, -1L, new HashMap());
        JMSServerManagerImpl jmsServer = new JMSServerManagerImpl(server);
        InVMNamingContext context = new InVMNamingContext();
        jmsServer.setRegistry((BindingRegistry)new JndiBindingRegistry((Context)context));
        jmsServer.start();
        jmsServer.createTopic(true, "tt", new String[]{"/topic/TT"});
        server.getActiveMQServerControl().addAddressSettings("TT", "DLQ", "DLQ", -1L, false, 5, 0x100000L, 10240, 5, 5L, 1.0, 1000L, 0L, false, "PAGE", -1L, 10L, "KILL", true, true, true, true);
        ActiveMQJMSConnectionFactory cf = (ActiveMQJMSConnectionFactory)ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        Connection conn = cf.createConnection();
        conn.setClientID("tst");
        Session sess = conn.createSession(false, 1);
        Topic topic = (Topic)context.lookup("/topic/TT");
        sess.createDurableSubscriber(topic, "t1");
        MessageProducer prod = sess.createProducer((Destination)topic);
        prod.setDeliveryMode(2);
        TextMessage txt = sess.createTextMessage("TST");
        prod.send((Message)txt);
        PagingStore store = server.getPagingManager().getPageStore(new SimpleString("TT"));
        PagingOrderTest.assertEquals((long)0x100000L, (long)store.getMaxSize());
        PagingOrderTest.assertEquals((long)10240L, (long)store.getPageSizeBytes());
        jmsServer.stop();
        server = this.createServer(true, config, 10240, -1L, new HashMap());
        jmsServer = new JMSServerManagerImpl(server);
        context = new InVMNamingContext();
        jmsServer.setRegistry((BindingRegistry)new JndiBindingRegistry((Context)context));
        jmsServer.start();
        AddressSettings settings = (AddressSettings)server.getAddressSettingsRepository().getMatch("TT");
        PagingOrderTest.assertEquals((long)0x100000L, (long)settings.getMaxSizeBytes());
        PagingOrderTest.assertEquals((long)10240L, (long)settings.getPageSizeBytes());
        PagingOrderTest.assertEquals((Object)AddressFullMessagePolicy.PAGE, (Object)settings.getAddressFullMessagePolicy());
        store = server.getPagingManager().getPageStore(new SimpleString("TT"));
        conn.close();
        server.stop();
    }

    @Test
    public void testPagingOverCreatedDestinationQueues() throws Exception {
        Configuration config = this.createDefaultInVMConfig().setJournalSyncNonTransactional(false);
        ActiveMQServer server = this.createServer(true, config, -1, -1L, new HashMap());
        ((AddressSettings)server.getAddressSettingsRepository().getMatch("#")).setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK);
        JMSServerManagerImpl jmsServer = new JMSServerManagerImpl(server);
        InVMNamingContext context = new InVMNamingContext();
        jmsServer.setRegistry((BindingRegistry)new JndiBindingRegistry((Context)context));
        jmsServer.start();
        server.getActiveMQServerControl().addAddressSettings("Q1", "DLQ", "DLQ", -1L, false, 5, 102400L, 10240, 5, 5L, 1.0, 1000L, 0L, false, "PAGE", -1L, 10L, "KILL", true, true, true, true);
        jmsServer.createQueue(true, "Q1", null, true, new String[]{"/queue/Q1"});
        ActiveMQJMSConnectionFactory cf = (ActiveMQJMSConnectionFactory)ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(INVM_CONNECTOR_FACTORY)});
        this.conn = cf.createConnection();
        this.conn.setClientID("tst");
        Session sess = this.conn.createSession(false, 1);
        jakarta.jms.Queue queue = (jakarta.jms.Queue)context.lookup("/queue/Q1");
        MessageProducer prod = sess.createProducer((Destination)queue);
        prod.setDeliveryMode(2);
        BytesMessage bmt = sess.createBytesMessage();
        bmt.writeBytes(new byte[1024]);
        for (int i = 0; i < 500; ++i) {
            prod.send((Message)bmt);
        }
        PagingStore store = server.getPagingManager().getPageStore(new SimpleString("Q1"));
        PagingOrderTest.assertEquals((long)102400L, (long)store.getMaxSize());
        PagingOrderTest.assertEquals((long)10240L, (long)store.getPageSizeBytes());
        PagingOrderTest.assertEquals((Object)AddressFullMessagePolicy.PAGE, (Object)store.getAddressFullMessagePolicy());
        jmsServer.stop();
        server = this.createServer(true, config, -1, -1L, new HashMap());
        ((AddressSettings)server.getAddressSettingsRepository().getMatch("#")).setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK);
        jmsServer = new JMSServerManagerImpl(server);
        context = new InVMNamingContext();
        jmsServer.setRegistry((BindingRegistry)new JndiBindingRegistry((Context)context));
        jmsServer.start();
        AddressSettings settings = (AddressSettings)server.getAddressSettingsRepository().getMatch("Q1");
        PagingOrderTest.assertEquals((long)102400L, (long)settings.getMaxSizeBytes());
        PagingOrderTest.assertEquals((long)10240L, (long)settings.getPageSizeBytes());
        PagingOrderTest.assertEquals((Object)AddressFullMessagePolicy.PAGE, (Object)settings.getAddressFullMessagePolicy());
        store = server.getPagingManager().getPageStore(new SimpleString("Q1"));
        PagingOrderTest.assertEquals((long)102400L, (long)store.getMaxSize());
        PagingOrderTest.assertEquals((long)10240L, (long)store.getPageSizeBytes());
        PagingOrderTest.assertEquals((Object)AddressFullMessagePolicy.PAGE, (Object)store.getAddressFullMessagePolicy());
    }
}

