/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.ra;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ResourceAdapter;
import java.util.HashSet;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactoryImpl;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionManager;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.service.extensions.ServiceUtils;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.integration.ra.ActiveMQRATestBase;
import org.apache.activemq.artemis.tests.integration.ra.DummyTransactionManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OutgoingConnectionNoJTATest
extends ActiveMQRATestBase {
    protected ActiveMQResourceAdapter resourceAdapter;
    protected ActiveMQRAConnectionFactory qraConnectionFactory;
    protected ActiveMQRAManagedConnectionFactory mcf;
    ActiveMQRAConnectionManager qraConnectionManager = new ActiveMQRAConnectionManager();

    @Override
    public boolean useSecurity() {
        return true;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.useDummyTransactionManager();
        super.setUp();
        ((ActiveMQJAASSecurityManager)this.server.getSecurityManager()).getConfiguration().addUser("testuser", "testpassword");
        ((ActiveMQJAASSecurityManager)this.server.getSecurityManager()).getConfiguration().addUser("guest", "guest");
        ((ActiveMQJAASSecurityManager)this.server.getSecurityManager()).getConfiguration().setDefaultUser("guest");
        ((ActiveMQJAASSecurityManager)this.server.getSecurityManager()).getConfiguration().addRole("testuser", "arole");
        ((ActiveMQJAASSecurityManager)this.server.getSecurityManager()).getConfiguration().addRole("guest", "arole");
        Role role = new Role("arole", true, true, true, true, true, true, true, true, true, true);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        this.server.getSecurityRepository().addMatch("mdbQueue", roles);
        this.resourceAdapter = new ActiveMQResourceAdapter();
        this.resourceAdapter.setEntries("[\"java://jmsXA\"]");
        this.resourceAdapter.setConnectorClassName(InVMConnectorFactory.class.getName());
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        this.resourceAdapter.start((BootstrapContext)ctx);
        this.mcf = new ActiveMQRAManagedConnectionFactory();
        this.mcf.setAllowLocalTransactions(Boolean.valueOf(true));
        this.mcf.setResourceAdapter((ResourceAdapter)this.resourceAdapter);
        this.qraConnectionFactory = new ActiveMQRAConnectionFactoryImpl(this.mcf, (ConnectionManager)this.qraConnectionManager);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        ((DummyTransactionManager)ServiceUtils.getTransactionManager()).tx = null;
        if (this.resourceAdapter != null) {
            this.resourceAdapter.stop();
        }
        this.qraConnectionManager.stop();
        super.tearDown();
    }

    @Test
    public void testSimpleMessageSendAndReceiveSessionTransacted() throws Exception {
        this.setupDLQ(10);
        this.resourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        this.resourceAdapter.start((BootstrapContext)ctx);
        ActiveMQRAManagedConnectionFactory mcf = new ActiveMQRAManagedConnectionFactory();
        mcf.setAllowLocalTransactions(Boolean.valueOf(true));
        mcf.setResourceAdapter((ResourceAdapter)this.resourceAdapter);
        ActiveMQRAConnectionFactoryImpl qraConnectionFactory = new ActiveMQRAConnectionFactoryImpl(mcf, (ConnectionManager)this.qraConnectionManager);
        QueueConnection queueConnection = qraConnectionFactory.createQueueConnection();
        Session s = queueConnection.createSession(true, 0);
        Queue q = ActiveMQJMSClient.createQueue((String)"mdbQueue");
        MessageProducer mp = s.createProducer((Destination)q);
        MessageConsumer consumer = s.createConsumer((Destination)q);
        TextMessage message = s.createTextMessage("test");
        mp.send((Message)message);
        s.commit();
        queueConnection.start();
        TextMessage textMessage = (TextMessage)consumer.receive(1000L);
        OutgoingConnectionNoJTATest.assertNotNull((Object)textMessage);
        OutgoingConnectionNoJTATest.assertEquals((Object)textMessage.getText(), (Object)"test");
        s.rollback();
        textMessage = (TextMessage)consumer.receive(1000L);
        OutgoingConnectionNoJTATest.assertNotNull((Object)textMessage);
        OutgoingConnectionNoJTATest.assertEquals((Object)textMessage.getText(), (Object)"test");
        s.commit();
        textMessage = (TextMessage)consumer.receiveNoWait();
        OutgoingConnectionNoJTATest.assertNull((Object)textMessage);
    }

    @Test
    public void testSimpleMessageSendAndReceiveNotTransacted() throws Exception {
        this.setupDLQ(10);
        this.resourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        this.resourceAdapter.start((BootstrapContext)ctx);
        ActiveMQRAManagedConnectionFactory mcf = new ActiveMQRAManagedConnectionFactory();
        mcf.setAllowLocalTransactions(Boolean.valueOf(true));
        mcf.setResourceAdapter((ResourceAdapter)this.resourceAdapter);
        ActiveMQRAConnectionFactoryImpl qraConnectionFactory = new ActiveMQRAConnectionFactoryImpl(mcf, (ConnectionManager)this.qraConnectionManager);
        QueueConnection queueConnection = qraConnectionFactory.createQueueConnection();
        Session s = queueConnection.createSession(false, 0);
        Queue q = ActiveMQJMSClient.createQueue((String)"mdbQueue");
        MessageProducer mp = s.createProducer((Destination)q);
        MessageConsumer consumer = s.createConsumer((Destination)q);
        TextMessage message = s.createTextMessage("test");
        mp.send((Message)message);
        s.commit();
        queueConnection.start();
        TextMessage textMessage = (TextMessage)consumer.receive(1000L);
        OutgoingConnectionNoJTATest.assertNotNull((Object)textMessage);
        OutgoingConnectionNoJTATest.assertEquals((Object)textMessage.getText(), (Object)"test");
        s.rollback();
        textMessage = (TextMessage)consumer.receive(1000L);
        OutgoingConnectionNoJTATest.assertNotNull((Object)textMessage);
        OutgoingConnectionNoJTATest.assertEquals((Object)textMessage.getText(), (Object)"test");
        s.commit();
        textMessage = (TextMessage)consumer.receiveNoWait();
        OutgoingConnectionNoJTATest.assertNull((Object)textMessage);
    }

    @Test
    public void testSimpleMessageSendAndReceiveSessionTransacted2() throws Exception {
        this.setupDLQ(10);
        this.resourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        this.resourceAdapter.start((BootstrapContext)ctx);
        ActiveMQRAManagedConnectionFactory mcf = new ActiveMQRAManagedConnectionFactory();
        mcf.setAllowLocalTransactions(Boolean.valueOf(true));
        mcf.setResourceAdapter((ResourceAdapter)this.resourceAdapter);
        ActiveMQRAConnectionFactoryImpl qraConnectionFactory = new ActiveMQRAConnectionFactoryImpl(mcf, (ConnectionManager)this.qraConnectionManager);
        QueueConnection queueConnection = qraConnectionFactory.createQueueConnection();
        Session s = queueConnection.createSession(0);
        Queue q = ActiveMQJMSClient.createQueue((String)"mdbQueue");
        MessageProducer mp = s.createProducer((Destination)q);
        MessageConsumer consumer = s.createConsumer((Destination)q);
        TextMessage message = s.createTextMessage("test");
        mp.send((Message)message);
        s.commit();
        queueConnection.start();
        TextMessage textMessage = (TextMessage)consumer.receive(1000L);
        OutgoingConnectionNoJTATest.assertNotNull((Object)textMessage);
        OutgoingConnectionNoJTATest.assertEquals((Object)textMessage.getText(), (Object)"test");
        s.rollback();
        textMessage = (TextMessage)consumer.receive(1000L);
        OutgoingConnectionNoJTATest.assertNotNull((Object)textMessage);
        OutgoingConnectionNoJTATest.assertEquals((Object)textMessage.getText(), (Object)"test");
        s.commit();
        textMessage = (TextMessage)consumer.receiveNoWait();
        OutgoingConnectionNoJTATest.assertNull((Object)textMessage);
    }

    @Test
    public void sessionNotTransactedTestNoActiveJTATx() throws Exception {
        JMSContext context = this.qraConnectionFactory.createContext(1);
        OutgoingConnectionNoJTATest.assertEquals((long)context.getSessionMode(), (long)1L);
    }

    @Test
    public void sessionTransactedTestNoActiveJTATx() throws Exception {
        try {
            this.qraConnectionFactory.createContext(0);
            OutgoingConnectionNoJTATest.fail((String)"Exception expected");
        }
        catch (JMSRuntimeException jMSRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testQueueSessionAckMode() throws Exception {
        QueueConnection queueConnection = this.qraConnectionFactory.createQueueConnection();
        Session s = queueConnection.createSession(false, 0);
        s.close();
    }

    @Test
    public void testSimpleSendNoXAJMSContext() throws Exception {
        Queue q = ActiveMQJMSClient.createQueue((String)"mdbQueue");
        try (ClientSessionFactory sf = this.locator.createSessionFactory();
             ClientSession session = sf.createSession();
             ClientConsumer consVerify = session.createConsumer("mdbQueue");
             JMSContext jmsctx = this.qraConnectionFactory.createContext();){
            session.start();
            JMSProducer producer = jmsctx.createProducer();
            producer.setProperty("strvalue", "hello");
            TextMessage msgsend = jmsctx.createTextMessage("hello");
            producer.send((Destination)q, (Message)msgsend);
            ClientMessage msg = consVerify.receive(1000L);
            OutgoingConnectionNoJTATest.assertNotNull((Object)msg);
            OutgoingConnectionNoJTATest.assertEquals((Object)"hello", (Object)msg.getStringProperty("strvalue"));
        }
    }

    @Test
    public void testSimpleMessageSendAndReceive() throws Exception {
        QueueConnection queueConnection = this.qraConnectionFactory.createQueueConnection();
        Session s = queueConnection.createSession(false, 1);
        Queue q = ActiveMQJMSClient.createQueue((String)"mdbQueue");
        MessageProducer mp = s.createProducer((Destination)q);
        MessageConsumer consumer = s.createConsumer((Destination)q);
        TextMessage message = s.createTextMessage("test");
        mp.send((Message)message);
        queueConnection.start();
        TextMessage textMessage = (TextMessage)consumer.receive(1000L);
        OutgoingConnectionNoJTATest.assertNotNull((Object)textMessage);
        OutgoingConnectionNoJTATest.assertEquals((Object)textMessage.getText(), (Object)"test");
    }

    @Test
    public void testSimpleSendNoXAJMS1() throws Exception {
        Queue q = ActiveMQJMSClient.createQueue((String)"mdbQueue");
        try (ClientSessionFactory sf = this.locator.createSessionFactory();
             ClientSession session = sf.createSession();
             ClientConsumer consVerify = session.createConsumer("mdbQueue");
             Connection conn = this.qraConnectionFactory.createConnection();){
            Session jmsSess = conn.createSession(false, 1);
            session.start();
            MessageProducer producer = jmsSess.createProducer((Destination)q);
            TextMessage msgsend = jmsSess.createTextMessage("hello");
            msgsend.setStringProperty("strvalue", "hello");
            producer.send((Message)msgsend);
            ClientMessage msg = consVerify.receive(1000L);
            OutgoingConnectionNoJTATest.assertNotNull((Object)msg);
            OutgoingConnectionNoJTATest.assertEquals((Object)"hello", (Object)msg.getStringProperty("strvalue"));
        }
    }
}

